﻿//Для наследования Список отчетов
BaseReportTaskListView = KS.extend(BaseDictionaryView, {
    onValuesSelected: function (args) {
        var view = this, field;
        if (Ext.isEmpty(args) || Ext.isEmpty(args[0])) {
            return;
        }
        for (field in args[0][0]) {
            if (field === 'ACTION') {
                switch (args[0][0][field]) {
                    case 'DO_SVOD_TPL':
                        var params = args[0][0]['DO_SVOD_TPL_PARAMS'];
                        view.svodTpl(params);
                        break;
                }
            } else if (field.indexOf("BATCH_PRINT") >= 0) {
                var savedFormLinks = args[0][0][field];
                this.batchPrint(savedFormLinks);
            }
        }
        BaseReportTaskListView.superclass.onValuesSelected.apply(this, arguments);
    },

    edsCheckCert: function() {
        var view = this.parentView || this;
        KS.XCrypt.viewContext = view;
        delete KS.XCrypt.lastSignError;
        if (KS.edsType >= 1) {
            view.serverCall({
                method: 'GetOpenData',
                params: [[], 'EdsCheckCert'],
                waitMessage: 'Чтение настроек ...',
                success: function(signSettings) {
                    view.initializeXCrypt(signSettings, view.getCertForEdsCheck, view);
                }
            });
        }
    },

    getCertForEdsCheck: function() {
        KS.XCrypt.selectCertificate(this.getCertInfo, this, false);
    },

    getCertInfo: function(certData) {
        this.checkedCertData = certData;
        KS.XCrypt.certInfo(certData.serial, this.getDataForEdsCheck, this);
    },

    getDataForEdsCheck: function (certInfo) {
        this.checkedCertInfo = certInfo;
        this.serverCall({
            method: 'GetBase64DataForTestSign',
            success: function (testBase64) {
                KS.XCrypt.sign(testBase64, this.checkedCertData.serial, 1, 'TspUrl=', this.edsCheckFileSigned, this);
            }
        })
    },

    edsCheckFileSigned: function(sign) {
        var signSuccess = true;
        if (this.checkSignForErrors(sign, true)) signSuccess = false;
        this.serverCall({
            method: 'ShowCertInfo',
            params: [this.checkedCertData, this.checkedCertInfo, signSuccess, KS.XCrypt.lastSignError || '', sign, KS.XCrypt.certsList]
        });
    },

    // ============= BATCH PRINT =======================
    batchPrint: function (savedFormLinks) {
        this.createTemplateControl(this.tpl.controls['batchGrid']);
        KS.showModal(this.batchGrid, {
            title: 'Очередь печати',
            autoHeight: false,
            height: 400,
            links: savedFormLinks
        }, true);
        this.fillBatchGrid(savedFormLinks);
    },

    fillBatchGrid: function (savedFormLinks) {
        var view = this;
        Ext.each(savedFormLinks, function(savedFormLink) {
            var rec = view.mainGrid.findRowByField('link_saved_form', savedFormLink);
            if (!rec) return;
            view.batchGrid.addRecord({
                state: 'queued',
                LINK_TASK: KS.Grid.getAnyCase(rec, 'LINK_TASK'),
                LINK_SAVED_FORM: savedFormLink,
                code: KS.Grid.getAnyCase(rec, 'FORM_CODE') || 'Н/Д',
                version: KS.Grid.getAnyCase(rec, 'VERSIONS') || KS.Grid.getAnyCase(rec, 'VERSION'),
                attr: KS.Grid.getAnyCase(rec, 'ATTRIBUTE_LABEL') || '',
                result: 'Ожидание'
            });
        });
        this.batchPrintNext();
    },

    findFirstBatchRow: function (state) {
        var idx = this.batchGrid.store.findBy(function (rec) {
            return rec.data.state == state;
        });
        return idx < 0 ? null : this.batchGrid.store.getAt(idx);
    },

    setBatchState: function (state, result) {
        this.printingRec.set('state', state);
        this.printingRec.set('result', result);
        this.printingRec.commit();
    },

    batchPrintNext: function () {
        this.printingRec = this.findFirstBatchRow('queued');
        if (!this.printingRec) {
            this.batchPrintFinalize();
            return;
        }
        this.setBatchState('printing', 'Печатается...');
        var recData = this.printingRec.data;
        this.serverCall({
            method: 'DoPrintWebReport',
            disableFog: true,
            waitMessage: 'Печать ' + recData.code + ' ...',
            params: new Array({
                LINK_TASK: recData.LINK_TASK || null,
                LINK_SAVED_FORM: recData.LINK_SAVED_FORM || null
            }),
            cancellable: true,
            success: this.batchPrintCallback,
            error: this.batchPrintError,
            abort: this.batchPrintFinalize
        });
    },

    batchPrintError: function () {
        this.setBatchState('error', 'Ошибка!');
        this.batchPrintNext();
    },

    batchPrintCallback: function (dict) {
        this.setBatchState('ok', '<a target="_blank" href="' + dict["PRINT_URL"] + '">Скачать</a>');
        this.batchPrintNext();
    },

    batchPrintFinalize: function () {
        var view = this;

        if (!view.batchGrid)
            return;
        view.batchGrid.store.each(function (rec) {
            if (rec.data.state == 'queued' || rec.data.state == 'printing') {
                rec.set('state', 'cancelled');
                rec.set('result', 'Отменено');
            }
        });

        view.serverCall({
            method: 'BatchPrintFinalize',
            waitMessage: 'Завершение печати ...',
            success: function (batchArchivePath) {
                if (!Ext.isEmpty(batchArchivePath)) {
                    view.setDisabledDownloadBatchBtn(false);
                    view.batchArchivePath = batchArchivePath;
                }
            }
        });
    },

    downloadZipBatchPrint: function () {
        var view = this.parentView;
        if (!Ext.isEmpty(view.batchArchivePath))
            view.openUrl(view.batchArchivePath);
    },

    setDisabledDownloadBatchBtn: function (disabled) {
        this.getToolbarItem(this.batchGrid, null, 'DOWNLOAD_ALL_BATCH').setDisabled(disabled);
    },

    // =====================================================
    
});

ReportTaskListView = KS.extend(BaseReportTaskListView, {
    customName: 'ReportTaskListView'
});
var vc = ReportTaskListView.prototype;

// ============= COMMON =======================
(function (viewClass) {
    var sc = ReportTaskListView.superclass;

    KS.apply(viewClass, {
        onTemplateRendered: function () {
            sc.onTemplateRendered.apply(this, arguments);
            this.subscribeStatusesRights(this.mainGridContainer, this.mainGrid);
            this.subscribeStatusesRights(this.versionsGrid, this.versionsGrid);
            if (this.data.settings.AutoUpdateInterval > 0) {
                var view = this;
                setInterval(function() { view.refreshList(); }, this.data.settings.AutoUpdateInterval * 60 * 1000);
            }
            this.tuneDeleteInTrash();

            this.containerPanel.on('activate', this.viewActivated, this);
        },
        
        viewActivated: function(){
            var rnv = this.getReportNavigationView();
            if (rnv && rnv.containerPanel && rnv.containerPanel.ownerCt)
                rnv.containerPanel.ownerCt.setActiveTab(rnv.containerPanel);
        },

        getReportNavigationView: function(){
            return KS.findSingleView('customNameExt', 'ReportNavigationView_ReportTaskList');
        },

        resetView: function () {
            this.rootEl.getLayout().setActiveItem(0);
            this.getToolbar(this.mainGrid).insert(1, this.mainGrid.createHideButton());
            this.correctCreateNotificationBtn();
        },

        isTrashCan: function() {
            if (!this.rootEl.rendered) return false;
            var cl = this.rootEl.getLayout(),
                idx = this.rootEl.items.indexOf(cl.activeItem);
            return (idx === 1);
        },

        selectFirstTask: function() {
            if (!this.rendered || !this.store || this.store.getTotalCount() === 0) return;
            var grid = this,
                view = grid.parentView,
                ati = view.findActiveTaskIdx(),
                taskIdx = ati < 0 ? 0 : ati;
            setTimeout(function() {
                grid.select(taskIdx);
            }, 0);
        },

        findActiveTaskIdx: function() {
            if (!this.activeTaskLink) return -1;
            var atl = this.activeTaskLink,
                grid = this.mainGrid,
                idx = grid.getStore().findBy(function(rec) {
                    return (grid.getAnyCase(rec, 'LINK_TASK') == atl);
                });
            return idx;
        },

        selectTask: function () {
            if (this.isTrashCan()) return;
            var tasks = this.mainGrid.getSelectedRecs();
            if (!Ext.isEmpty(tasks)) {
                var taskRec = tasks[0],
                    taskLink = KS.Grid.getAnyCase(taskRec, 'link_task');
                if (taskLink > 0 && this.activeTaskLink !== taskLink) {
                    this.activeTaskLink = taskLink;
                    if (this.versionsGrid) this.versionsGrid.reload();
                }
            }
        },

        showContextMenu: function (table, record, htmlElement, rowIndex, event) {
            var view = this;
            var menu = new Ext.menu.Menu({
                shadow: true,
                ignoreParentClicks: true,
                items: [
                    {
                        menuId: 'COPY',
                        code: 'COPY',
                        text: 'Копировать'
                    }
                ],
                listeners: {
                    'click': function (menu, itemClicked) {
                        switch (itemClicked.code) {
                            case 'COPY':
                                view.copyCellValue(record, event.position.column);
                                break;
                        }
                    }
                }
            });
            menu.showAt(event.getXY());

            event.stopEvent();
            return false;
        },

        copyCellValue: function (record, column) {
            var colDataIndex = column.dataIndex,
                dateFormat = column.dataType === 'system.datetime'
                    ? column.format
                    : null;

            var cellValue = record.data[colDataIndex];
            if (!Ext.isEmpty(cellValue)) {
                if (dateFormat)
                    cellValue = Ext.util.Format.date(cellValue, dateFormat);

                this.writeToClipboard(cellValue);
            }
        },

        getAdditionalGetDataParams: function (getDataParams) {
            getDataParams['isTrashCan'] = this.isTrashCan();
            if (getDataParams.itemId === 'versionsGrid') {
                getDataParams['taskLink'] = this.activeTaskLink;
            }
            if (this.showVersions)
                getDataParams['showVersions'] = this.showVersions.getValue();
        },

        onActivate: function (panel) {
            if (this.needRefresh) {
                this.refreshList();
                this.needRefresh = false;
            }
            KS.updateLayout(panel);
        },

        saveShowVersions: function (cb, showVersions) {
            this.serverCall({
                method: 'SaveShowVersions',
                params: [showVersions],
                success: function () {
                    this.mainGrid.reload();
                }
            });
        },

        showNotCreated: function (cb, showNotCreated) {
            this.serverCall({
                method: 'ShowNotCreated',
                params: [showNotCreated],
                success: function () {
                    this.mainGrid.reload();
                }
            });
        },

        clearMainGridFilters: function () {
            var view = this.parentView || this;
            view.mainGrid.removeGridFilter();
        },

        onBeforeClose: function () {
            var rnv = this.getReportNavigationView();
            if (rnv && rnv.containerPanel && rnv.containerPanel.ownerCt)
                rnv.containerPanel.ownerCt.setActiveTab(rnv.containerPanel)

            ReportTaskListView.superclass.onBeforeClose.call(this);
        }
    });
}(vc));

// ============= TOOLBAR =======================
(function (viewClass) {
    var sc = ReportTaskListView.superclass;

    KS.apply(viewClass, {
        modeComboSelected: function(combo, record) {
            var view = combo.parentView,
                cl = this.rootEl.getLayout(),
                mode = record.data.mode;
            cl.setActiveItem(mode);
            if (view.needAutoRefresh) {
                view.autoRefresh();
                if (KS.isDefined(mode)) {
                    if (view.isTrashCan()) {
                        view.recycleMode.setValue(mode);
                    } else {
                        view.mainMode.setValue(mode);
                    }
                }
            } else {
                view.reloadGrids(mode);
            }
        },

        getTbarClickHandler: function (tbarItem) {
            var code = tbarItem.code || '';
            switch (code) {
                case 'STATUSES':
                case 'CHECK_SUMS':
                case 'CALCULATE_KS_INSIDE':
                    return this.emtpyHandler;

                case 'REFRESH2':
                    return this.refreshList;

                case 'EDS':
                case 'SERVICE':
                    return null;

                case 'EDS_SIGN':
                    return this.taskListSign;

                case 'CLEAR_ALL_FILTERS':
                    return this.clearMainGridFilters;

                case 'EDS_CHECK_SERT':
                    return this.edsCheckCert;

                case 'DOWNLOAD_ALL_BATCH':
                    return this.downloadZipBatchPrint;

                case 'SAVE':
                case 'REFRESH':
                case 'EXIT':
                case 'MARK_INVERT':
                case 'MARK_INVERT2':
                case 'MARK_TOP':
                case 'MARK_ALL':
                case 'MARK_REST':
                case 'MARK_BETWEEN':
                case 'UNMARK':
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
            return this.executeToolbarOperation;
        },

        taskListSign: function () {
            var view = this.parentView,
                grid = view.findOwnerContainer(this, view.isGrid);
            if (view.data.settings.ReportEdsSchema > 0) {
                view.executeOperation('EDS_SIGN', grid);
            } else {
                view.ccc = grid.getCheckedCodes(true);
                view.executeOperation('EDS_CHECK', grid);
            }
        },

        afterSignData: function () {
            this.autoRefresh();
        },

        executeToolbarOperation: function() {
            var view = this.parentView,
                grid = view.findOwnerContainer(this, view.isGrid);
            if (grid && this.tbarNode) {
                var code = this.tbarNode.code || '',
                    confirmMsg = view.getConfirmMessage(grid, code);
                if (code === 'STATUS_EXPORT_86N') {
                    view.executeOperation(code, grid);
                } else if (code.indexOf('STATUS_') === 0) {
                    var sfsl = +code.replace('STATUS_', '');
                    var properties = {
                        LINK_STATUS: sfsl,
                        LINK_SAVED_FORM_STATUS: sfsl,
                        COMMENT: view.confirmMsg || ''
                    };
                    if (confirmMsg) {
                        KS.confirm(confirmMsg , "Подтвердите действие", function(btn) {
                            if (btn === 'yes' && sfsl > 0) 
                                view.executeOperation('SET_STATUSES', grid, properties);
                        });
                    } else {
                        if (sfsl > 0) 
                            view.executeOperation('SET_STATUSES', grid, properties);
                    }
                } else if (code === 'EXCEL_CLIENT'){
                    if (confirmMsg) {
                        KS.alert(confirmMsg, "Предупреждение");
                    } else {
                        if (KS.edsType == 0) {
                            KS.loadXcrypt(view.executeOperation, view, [code, grid]);
                        } else {
                            view.excelClientParams = {
                                code : code,
                                grid : grid
                            }
                            view.initializeXCrypt({}, view.executeOperation, view);
                        }
                    }
                } else if (code === 'CREATE_NOTIFICATION' || code === 'CREATE_NOTIFICATION2') {
                    view.getNotificationDate(code, grid);
                } else if (code === 'OUTPUT_FORMS' && !Ext.isEmpty(confirmMsg)){
                    KS.alert(confirmMsg, "Предупреждение");
                } else if (confirmMsg === 'cancel') {
                    return;
                } else if (confirmMsg) {
                    KS.confirm(confirmMsg + '. Продолжить?', "Подтвердите действие", function(btn) {
                        if (btn === 'yes') view.executeOperation(code, grid);
                    });
                } else {
                    view.executeOperation(code, grid);
                }
            } else {
                KS.msg('Неизвестная команда');
            }
        },

        getNotificationDate: function (code, grid) {
            var w = KS.showModal(this.createTemplateControl(this.tpl.controls['notificationPeriod']), {
                title: 'Выберите дату',
                width: 200,
                height: 100,
                minWidth: 200,
                minHeight: 100,
                buttonAlign: 'right',
                buttons: [{
                    text: 'OK',
                    scope: this,
                    handler: function() {
                        this.executeOperation(code, grid, { DATE: this.notificationPeriod.getValue() });
                        w.close();
                    }
                }]
            });
        },

        getConfirmMessage: function (grid, code) {
            var msg = null,
                rows = this.buildChosenRows(grid);
            code = code.toUpperCase();
            if (code.indexOf('DELETE') >= 0) {
                if (Ext.isEmpty(rows)) return 'cancel';
                var utc = this.data.settings.useTrashCan,
                    actionType = utc ? "отправлены в корзину" : "удалены";
                if (code == 'DELETE3') {
                    msg = 'Будут ' + actionType + ' все недействующие версии выбранных отчетов';
                } else if (code == 'DELETE_ALL') {
                    msg = 'Будут ' + actionType + ' все версии выбранных отчетов';
                } else {
                    msg = 'Будет ' + (utc ? (!this.isTrashCan() ? "отправлено в корзину" : "удалено из корзины") : "удалено") + ' отчетов: ' + rows.length;
                }
            } else if (code == 'DEFAULT') {
                var recs = grid.getCheckedRows(true);
                if (!Ext.isEmpty(recs))
                    msg = 'Сделать версию ' + grid.getAnyCase(recs[0], "VERSION") + ' активной?';
            } else if (code == 'EDS_UNSIGN') {
                if (!Ext.isEmpty(rows)) msg = 'Вы действительно хотите снять подпись?';
            } else if (code.indexOf('STATUS_') === 0) {
                var countReport = 3;
                if (this.data.settings != null &&
                    this.data.settings.countReportForConfirm > 0)
                    countReport = this.data.settings.countReportForConfirm;
                if (!Ext.isEmpty(rows) && rows.length >= countReport) msg = 'Сменить статус у выбранных отчетов (количество: '+ rows.length +')?';
            } else if (code == "EXCEL_CLIENT") {
                if (rows.length !== 1) {
                    msg = "Для выполнения операции необходимо выбрать только один отчет. Выбрано отчётов: "+rows.length;
                }
            } else if (code === "OUTPUT_FORMS"){
                if (Ext.isEmpty(rows)) return 'Для выполнения операции необходимо выделить один или несколько отчётов';
            }
            return msg;
        },

        setStatus: function() {
        },

        editReport: function () {
            var grid = this,
                view = this.parentView,
                rows = grid.getSelectedRows();
            var editBtn = view.getToolbarItem(view.mainGridContainer, 'top', 'EDIT');
            if (!Ext.isEmpty(editBtn)) {
                if (rows[0] && KS.Grid.getAnyCase(rows[0], 'LINK_TASK') < 0) {
                    KS.confirm('Отчет не создан. Создать?', "Подтвердите действие", function (btn) {
                        if (btn === 'yes') 
                            grid.parentView.executeOperation('BaseGrid', grid, {taskType: 2 });
                    });
                } else {
                    this.parentView.executeOperation('EDIT', grid, { taskType: 0 });
                }
            }
        },

        executeOperation: function (opCode, grid, additional) {
            if (this.excelClientParams){
                opCode = this.excelClientParams.code;
                grid = this.excelClientParams.grid;
                this.excelClientParams = null;
            }
            var rows = this.buildChosenRows(grid, opCode !== 'CREATE_NOTIFICATION');
            this.currentOpArgs = [].slice.call(arguments);
            this.serverCall({
                method: 'OnExecuteOperation',
                params: [opCode, rows, additional || {}],
                success: this.executeOperationCallback
            });
        },

        executeOperationCallback: function (result) {
            switch (result.operationCode) {
                case "EDIT":
                case "EDIT2":
                case "EDIT_MONO":
                case "OPEN_REPORT":
                    if (this.data.isOutcast) {
                        Ext.fireEvent('externalsourcetabopen', result.smartLink);
                        return;
                    }
                    break;

                case 'DELETE':
                case 'RESTORE':
                case 'DELETE_VERSIONS':
                case 'DELETE_NOT_ACTIVE_VERSIONS':
                case 'DELETE_ALL_VERSIONS':
                case 'RESTORE_VERSIONS':
                case 'EDS_UNSIGN':
                case 'CREATE_NOTIFICATION':
                case 'CREATE_NOTIFICATION2':
                    this.reloadGrids();
                    this.needAutoRefresh = true;
                    break;

                case 'DEFAULT':
                case 'DIFF_COUNT_1C':
                case 'BLOCK':
                case 'UNBLOCK':
                    this.refreshList();
                    break;

                case 'EXCEL_CLIENT':
                    this.openExcelClient.apply(this, arguments);
                    break;

                case 'EDS_CHECK':
                    if (KS.isEmpty(result.errorProtocol)) {
                        var view = this;
                        view.signDataSelector(view.ccc, function () { view.executeOperation('EDS_SIGN', view.mainGrid); });
                        delete view.ccc;
                    } else {
                        KS.Svod.showHtmlProtocol(result.errorProtocol);
                    }
                    break;

                case 'EDS_SIGN':
                    this.afterTrySign(result.signedData);
                    break;

                case 'SET_STATUSES':
                    if (result.confirm) {
                        this.buildConfirmWindow(result.confirm, result.confirmTitle, this.statusNoteConfirm);
                    } else {
                        this.refreshList();
                    }
                    break;

                case 'SAVE_STATUSES':
                    this.saveStatuses(result);

                default:
                    break;
            }

            this.processTaskResult(result.taskResultContext);
        },

        afterProcessTaskResult: function (taskResults) {
            var oargs = this.currentOpArgs;
            KS.apply(oargs[2], { taskResultContext: JSON.stringify(taskResults) });
            this.executeOperation.apply(this, oargs);
            delete this.currentOpArgs;
        },

        statusNoteConfirm: function () {
            var args = this.currentOpArgs;
            KS.apply(args[2], { COMMENT: this.confirmMsg });
            this.executeOperation.apply(this, args);
            delete this.currentOpArgs;
        },

        openExcelClient: function (result) {
            if (Ext.isEmpty(result['ArhivePath'])) {
                KS.warning('Ошибка загрузки данных Excel-клиента');
            } else {
                if (KS.edsType == 0) {
                    var xObj = KS.getXcryptObj();
                    xObj.RunExcelRep2(result['RootUrl'] || '', result['ArhivePath'], result['UserName'] || '');
                } else {
                    KS.XCrypt.cmInitor.container.Lavanda.Crypto.RunExcelRep2({
                        rootUrl: result['RootUrl'] || '',
                        archivePath: result['ArhivePath'],
                        userName: result['UserName'] || ''
                    });
                }
            }
        },

        subscribeStatusesRights: function (owner, grid) {
            if (KS.isEmpty(owner) || KS.isEmpty(grid)) return;
            var statuses = this.getToolbarItem(owner, 'top', 'STATUSES');
            if (KS.isEmpty(statuses) || !statuses.menu) return;
            var menu = statuses.menu;
            menu.grid = grid;
            menu.on('beforeshow', this.beforeShowStatuses, this);
        },

        beforeShowStatuses: function (menu) {
            var rows = this.buildChosenRows(menu.grid);
            if (KS.isEmpty(rows)) return false;
            this.serverCall({
                method: 'OnExecuteOperation',
                params: ['GET_STATUSES', rows, {}],
                disableFog: true,
                success: this.showStatuses
            });
            this._statusesMenu = menu;
            this.showStatuses({ statuses: [0] });
            this._statusesMenu = menu;
        },

        showStatuses: function (opRes) {
            var menu = this._statusesMenu;
            menu.statuses = opRes.statuses;
            delete this._statusesMenu;
            menu.items.each(function (item) {
                var code = item.tbarNode.code,
                    link = +code.split('_')[1];
                item.setVisible(jQuery.inArray(link, item.ownerCt.statuses) >= 0);
            });
            menu.enable();
            KS.updateLayout(menu);
        },

        saveStatuses: function(result) {
            var view = this;
            if (result.confirmMessage) {
                KS.confirm(result.confirmMessage, "Внимание", function(btn) {
                    var rows = view.buildChosenRows(view.mainGrid, true);
                    view.serverCall({
                        method: 'SaveStatuses',
                        params: [btn, result.operationCode, rows],
                        waitMessage: 'Смена статуса...',
                        success: view.reloadGrids
                    });
                });
            }
        },

        svodTpl: function (params) {
            this.serverCall({
                method: 'SvodFromTemplate',
                params: [params.identifier, params.budgetLink, params.organizationLink]
            });
        },

        //Настройка видимости кнопки удалить в корзине по настройке "Только администратор может чистить корзину"
        tuneDeleteInTrash: function() {
            var view = this.parentView || this;
            var deleteBtn = view.getToolbarItem(view.recycleGrid, 'top', 'DELETE');
            if (deleteBtn) {
                if (KS.isFunction(deleteBtn.setHidden)) deleteBtn.setHidden(!this.data.canDeleteFromTrash);
            }
        }
    });
}(vc));

// ============= RELOAD =======================
(function (viewClass) {
    KS.apply(viewClass, {
        reloadGrids: function (mode) {
            if (this.isTrashCan()) {
                if (KS.isDefined(mode)) this.recycleMode.setValue(mode);
                this.recycleGrid.reload();
            } else {
                if (KS.isDefined(mode)) this.mainMode.setValue(mode);
                if (this.versionsGrid) this.activeTaskLink = 0;
                this.mainGrid.reload();
            }
        },

        autoRefresh: function() {
            if (this.data.settings.autoUpdate) this.refreshList();
        },

        refreshList: function () {
            var view = this.parentView || this,
                viewState = null;
            if (!view.isActiveTab()) {
                view.needRefresh = true;
                return;
            }
            if (!view.data.isOutcast) {
                var rnv = view.getReportNavigationView();
                if (Ext.isEmpty(rnv)) return;
                viewState = rnv.getFilters();
                if (Ext.isEmpty(viewState)) return;
                view.correctCreateBtn(viewState);
                view.correctCreateNotificationBtn();
            }
            if (view.isRefreshing === true) {
                return;
            }
            view.isRefreshing = true;
            if (view.versionsGrid)
                view.activeTaskLink = 0;
            view.disableFilters();
            view.mainGrid.getSelectionModel().deselectAll();
            view.mainGrid.checkedCodes = [];
            view.serverCall({
                method: 'RefreshList',
                params: [viewState, view.isTrashCan(), true],
                cancellable: true,
                waitMessage: 'Обновление списка ...',
                success: view.refreshListCallback,
                complete: view.enableFilters
            });
        },

        refreshListCallback: function(data) {
            this.stopRefresh();
            this.needAutoRefresh = false;
            this.data.hasActiveBudget = data.hasActiveBudget;
            if (this.versionsGrid) this.versionsGrid.getStore().removeAll();
            this.reloadGrids();
        },

        stopRefresh: function() {
            this.isRefreshing = false;
        },

        enableFilters: function () {
            this.stopRefresh();
            var rnv = this.getReportNavigationView();
            if (rnv) rnv.refreshTaskListCallBack();
        },

        disableFilters: function () {
            var rnv = this.getReportNavigationView();
            if (rnv) rnv.containerPanel.disable();
        },

        correctCreateBtn: function (viewState) {
            var isSvod = (viewState.SvodType >= 0),
                createBtn = this.getToolbarItem(this.mainGridContainer, 'top', isSvod ? 'NEW2' : 'SVOD');
            if (KS.isSurDB) return;
            this.setTbarItemAttributes(createBtn,
                ({
                    text: isSvod ? 'Свод' : 'Создать',
                    tooltip: isSvod ? 'Свод' : 'Создать',
                    image: isSvod ? 'ks-icon-svod_mode' : 'ks-icon-new',
                    code: isSvod ? 'SVOD' : 'NEW2'
                }));
        },

        correctCreateNotificationBtn: function () {
            var rnv = this.getReportNavigationView(),
                createBtn = this.getToolbarItem(this.mainGridContainer, 'top', 'NEW2') ||
                    this.getToolbarItem(this.mainGridContainer, 'top', 'SVOD');
            if (KS.isEmpty(rnv) || KS.isEmpty(createBtn) || KS.isEmpty(createBtn.menu)) return;
            var notBtn = null;
            createBtn.menu.items.each(function(item) {
                if (item && item.tbarNode && (item.tbarNode.code === 'CREATE_NOTIFICATION')) notBtn = item;
            });
            if (KS.isEmpty(notBtn)) return;
            var selNode = rnv.budgetTree.getSelNode(),
                checked = rnv.budgetTree.getChecked(),
                enabled = selNode && selNode.parentNode.id != 'root' && KS.isEmpty(checked);
            if (!enabled) {
                Ext.each(checked, function(node) {
                    if (node && node.parentNode.id != 'root')
                        enabled = true;
                });
            }
            this.setTbarItemAttributes(notBtn, ({ disabled: !enabled }));
        }
    });
}(vc));

// ============= RENDERERS =======================
function defaultLinkSettingRenderer(value, metadata, record) {
    if (KS.Grid.getAnyCase(record, 'HIGHLIGHT') &&
        KS.Grid.getAnyCase(record, 'HIGHLIGHT') != '-1')
        return value;
    var ls = KS.Grid.getAnyCase(record, 'LINK_SETTING');
    if (ls) metadata.css += ' link-setting-' + ls;
    return value;
}

function vdksRenderer(value, metadata, record, rowIndex, colIndex, store) {
    defaultLinkSettingRenderer(value, metadata, record);
    var vec = KS.Grid.getAnyCase(record, 'VDKS_ERROR_COUNT'),
        isWaring = (KS.Grid.getAnyCase(record, 'CHECK_ERROR') == 2),
        view = store.grid.parentView;
    if (Ext.isEmpty(vec)) {
        return '';
    } else if (vec == 0) {
        metadata.css += ' link-setting-88';
    } else if (isWaring) {
        metadata.css += ' link-setting-77';
    } else {
        metadata.css += ' link-setting-99';
    }
    return '<span class="like-hypertext" onclick="' + getTLOArgs('VDKS_ERROR_COUNT', view, store, 1) + '">' + vec + '</span>';
}

function mdksRenderer(value, metadata, record, rowIndex, colIndex, store) {
    defaultLinkSettingRenderer(value, metadata, record);
    var state = +record.data.MDKS_ERROR_STATE,
        view = store.grid.parentView;
    switch (state) {
        case 1:
            metadata.css += ' link-setting-88';
            break;
        case 2:
            metadata.css += ' link-setting-99';
            break;
        case 3:
            metadata.css += ' link-setting-77';
            break;
        default:
            return value;
    }
    return '<span class="like-hypertext" onclick="' + getTLOArgs('MDKS_ERROR', view, store, 1) + '">' +value + '</span>';
}

function buhRenderer(value, metadata, record, rowIndex, colIndex, store) {
    defaultLinkSettingRenderer(value, metadata, record);
    var state = +record.data.DIFF_COUNT_1C_ERROR,
        view = store.grid.parentView;
    switch (state) {
        case 1:
            metadata.css += ' link-setting-88';
            break;
        case 2:
            metadata.css += ' link-setting-99';
            break;
        case 3:
            metadata.css += ' link-setting-77';
            break;
        default:
            return '<div class="fill-cntr" onclick="' + getTLOArgs('DIFF_COUNT_1C', view, store, 5) + '"></div>';
    }
    return '<span class="like-hypertext" onclick="' + getTLOArgs('DIFF_COUNT_1C', view, store, 5) + '">' + value + '</span>';
}

function ksoRenderer(value, metadata, record, rowIndex, colIndex, store) {
    defaultLinkSettingRenderer(value, metadata, record);
    var vec = KS.Grid.getAnyCase(record, 'SVOD_ERROR_COUNT'),
        view = store.grid.parentView;
    if (Ext.isEmpty(vec)) {
        return '';
    } else if (vec == 0) {
        metadata.css += ' link-setting-88';
    } else {
        metadata.css += ' link-setting-99';
    }
    return '<span class="like-hypertext" onclick="' + getTLOArgs('SVOD_ERROR_COUNT', view, store, 1) + '">' + vec + '</span>';
}

function edsRenderer(value, metadata, record) {
    defaultLinkSettingRenderer(value, metadata, record);
    if (KS.isEmpty(value) || value.indexOf('/') < 0) {
        return value;
    }
    var parts = value.split('/'),
        count = +parts[0],
        need = +parts[1];
    if (need > 0) {
        if (need > count) {
            metadata.css += count === 0 
                ? ' link-setting-99' 
                : ' link-setting-77';
        } else {
            metadata.css += ' link-setting-88';
        }
        return '<span class="like-hypertext">' + value + '</span>';
    }
    return "";
}

function filesRenderer(value, metadata, record, rowIndex, colIndex, store) {
    defaultLinkSettingRenderer(value, metadata, record);
    var hasFiles = KS.Grid.getAnyCase(record, 'EXIST_FILE'),
        view = store.grid.parentView;
    return (hasFiles === true || (KS.isString(hasFiles) && hasFiles.toLowerCase() === 'true'))
        ? '<img src="PlatformHandler.axd?icon=attach.png" onclick="' + getTLOArgs('SHOW_FILES', view, store, 0) + '"/>'
        : '';
}

function getTLOArgs(key, view, store, taskType) {
    return "execTaskListOperation('" + key + "','" + view.viewID + "','" + store.grid.itemId + "'," + taskType + ");";
}

function execTaskListOperation(key, viewId, gridId, taskType) {
    var view = KS.getView(viewId);
    if (view)
        setTimeout(function() {
            view.executeOperation(key, view[gridId], { taskType: taskType });
        }, 0);
}

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();