////////////////////////////////////////////////////////////////////////////////

function TRACE(msg, level) {
    if (KS.isDebug) {
        KS.log(msg, level);
    } 
}

////////////////////////////////////////////////////////////////////////////////

/**
 * Copies all the properties of config to obj.
 * @param {Object} obj The receiver of the properties
 * @param {Object} config The source of the properties
 * @param {Object} defaults A different object that will also be applied for default values
 * @return {Object} returns obj
 * @member KS apply
 */
KS.apply = function(o, c, defaults) {
    // no "this" reference for friendly out of scope calls
    if (defaults) KS.apply(o, defaults);
    if (o && c && typeof c == 'object') {
        for (var p in c)
            o[p] = c[p];
    }
    return o;
};

(function() {
    KS.apply(KS, {
        //определение пустоты строки, если null, 'null', 'NA', то тоже пусто
        IsEmpty: function(value) {
            value = KS.Trim(value);
            return (value == null || value == 'null' || value == 'undefined' || value + '' == 'undefined' || value == '#empty#' || value == 'NA' || value == '!NA!' || value == '' || value == 'NaN');
        },

        //определение равенства строк
        IsEqual: function(value1, value2) {
            if (KS.IsEmpty(value1) && KS.IsEmpty(value2)) return true;
            return (value1 == value2 || KS.Trim((value1 + '').toLowerCase()) == KS.Trim((value2 + '').toLowerCase()));
        },

        Replace: function(text, inchar, outchar) {
            if (KS.IsEmpty(text)) {
                return '';
            }
            text = text + '';
            var temp = text.split(inchar);
            return temp.join(outchar);
        },

        Ltrim: function(xstr) {
            if (xstr == null) return xstr;
            xstr += '';
            if (!(xstr.indexOf(' ') == 0)) return xstr;
            var astr = xstr.split(' ');
            var i = 0;
            while (i < astr.length) {
                if (!(astr[i] == (''))) break;
                i++;
            }
            astr = astr.slice(i);
            return astr.join(' ');
        },

        Rtrim: function(xstr) {
            if (xstr == null) return xstr;
            xstr += '';
            if (!(xstr.lastIndexOf(' ') == xstr.length - 1)) return xstr;
            var astr = xstr.split(' ');
            var i = astr.length - 1;
            while (i > 0) {
                if (!(astr[i] == (''))) break;
                i--;
            }
            astr = astr.slice(0, i + 1);
            return astr.join(' ');
        },

        Trim: function(xstr) {
            return KS.Rtrim(KS.Ltrim(xstr));
        },

        /**
        * Copies all the properties of config to obj if they don't already exist.
        * @param {Object} obj The receiver of the properties
        * @param {Object} config The source of the properties
        * @return {Object} returns obj
        */
        applyIf: function(o, c) {
            if (o) {
                for (var p in c) {
                    if (!KS.isDefined(o[p])) o[p] = c[p];
                }
            }
            return o;
        },

        /**
        * <p>Extends one class to create a subclass and optionally overrides members with the passed literal. This method
        * also adds the function "override()" to the subclass that can be used to override members of the class.</p>
        *
        * <p>This function also supports a 3-argument call in which the subclass's constructor is
        * passed as an argument. In this form, the parameters are as follows:</p>
        * <div class="mdetail-params"><ul>
        * <li><code>subclass</code> : Function <div class="sub-desc">The subclass constructor.</div></li>
        * <li><code>superclass</code> : Function <div class="sub-desc">The constructor of class being extended</div></li>
        * <li><code>overrides</code> : Object <div class="sub-desc">A literal with members which are copied into the subclass's
        * prototype, and are therefore shared among all instances of the new class.</div></li>
        * </ul></div>
        *
        * @param {Function} superclass The constructor of class being extended.
        * @param {Object} overrides <p>A literal with members which are copied into the subclass's
        * prototype, and are therefore shared between all instances of the new class.</p>
        * <p>This may contain a special member named <tt><b>constructor</b></tt>. This is used
        * to define the constructor of the new class, and is returned. If this property is
        * <i>not</i> specified, a constructor is generated and returned which just calls the
        * superclass's constructor passing on its parameters.</p>
        * <p><b>It is essential that you call the superclass constructor in any provided constructor. See example code.</b></p>
        * @return {Function} The subclass constructor from the <code>overrides</code> parameter, or a generated one if not provided.
        */
        extend: function() {
            // inline overrides
            var io = function(o) {
                for (var m in o)
                    this[m] = o[m];
            };
            var oc = Object.prototype.constructor;

            return function(sb, sp, overrides) {
                if (typeof sp == 'object') {
                    overrides = sp;
                    sp = sb;
                    sb = overrides.constructor != oc ? overrides.constructor : function() {
                        sp.apply(this, arguments);
                    };
                }
                var f = function() {
                    },
                    sbp,
                    spp = sp.prototype;

                f.prototype = spp;
                sbp = sb.prototype = new f();
                sbp.constructor = sb;
                sb.superclass = spp;
                if (spp.constructor == oc) {
                    spp.constructor = sp;
                }
                sb.override = function(o) {
                    KS.override(sb, o);
                };
                sbp.superclass = sbp.supr = (function() {
                    return spp;
                });
                sbp.override = io;
                KS.override(sb, overrides);
                sb.extend = function(o) {
                    return KS.extend(sb, o);
                };
                return sb;
            };
        }(),

        /**
        * Adds a list of functions to the prototype of an existing class, overwriting any existing methods with the same name.
        * Usage:<pre><code>
        KS.override(MyClass, {
        newMethod1: function(){
        // etc.
        },
        newMethod2: function(foo){
        // etc.
        }
        });
        </code></pre>
        * @param {Object} origclass The class to override
        * @param {Object} overrides The list of functions to add to origClass.  This should be specified as an object literal
        * containing one or more methods.
        * @method override
        */
        override: function(origclass, overrides) {
            if (overrides) {
                var p = origclass.prototype;
                KS.apply(p, overrides);
                if (overrides.hasOwnProperty('toString')) {
                    p.toString = overrides.toString;
                }
            }
        },

        /**
        * Creates namespaces to be used for scoping variables and classes so that they are not global.
        * Specifying the last node of a namespace implicitly creates all other nodes. Usage:
        * <pre><code>
        KS.namespace('Company', 'Company.data');
        KS.namespace('Company.data'); // equivalent and preferable to above syntax
        Company.Widget = function() { ... }
        Company.data.CustomStore = function(config) { ... }
        </code></pre>
        * @param {String} namespace1
        * @param {String} namespace2
        * @param {String} etc
        * @return {Object} The namespace object. (If multiple arguments are passed, this will be the last namespace created)
        * @method namespace
        */
        namespace: function() {
            var o, d;
            $.each(arguments, function(i, v) {
                d = v.split(".");
                o = window[d[0]] = window[d[0]] || {};
                $.each(d.slice(1), function(i2, v2) {
                    o = o[v2] = o[v2] || {};
                });
            });
            return o;
        },

        /**
        * Разбор объекта исключения во вменяемый текст сообщения
        */
        parseException: function(e) {
            var msg = e;
            if (KS.isDefined(e.message)) msg = e.message;
            try {
                var sf = e.popStackFrame();
                if (KS.isDefined(sf)) msg = msg + '\r\n[' + sf + ']';
            } catch (e) {
            }
            return msg;
        },

        // Get the integer value of a variable
        intval: function(mixedVar, base) {
            var tmp;
            if (typeof(mixedVar) == 'string') {
                tmp = parseInt(mixedVar);
                if (isNaN(tmp))
                    return 0;
                else
                    return tmp.toString(base || 10);
            } else if (typeof(mixedVar) == 'number')
                return Math.floor(mixedVar);
            else
                return 0;
        },

        getImage: function(src) {
            var i = new Image();
            i.src = src;
        },

        describeException: function(ex) {
            var s = '';
            var data = KS.isValid(ex.Data) ? ex.Data : {};

            if (KS.isValid(ex.Message)) {
                s += 'Message: ' + ex.Message + '\r\n';
                delete data.Message;
            }
            if (KS.isValid(ex.Type)) {
                s += 'Type: ' + ex.Type + '\r\n';
                delete data.Type;
            }
            if (KS.isValid(ex.TargetSite)) {
                s += 'TargetSite: ' + ex.TargetSite + '\r\n';
                delete data.TargetSite;
            }
            if (KS.isValid(ex.Source)) {
                s += 'Source: ' + ex.Source + '\r\n';
                delete data.Source;
            }
            for (var key in data)
                s += key + ': ' + data[key] + '\r\n';
            if (KS.isValid(ex.StackTrace))
                s += '\r\nStackTrace: \r\n' + ex.StackTrace + '\r\n';
            if (KS.isValid(ex.Inner))
                s += '\r\n\r\n----\r\nInner exception: \r\n' + KS.describeException(ex.Inner) + '\r\n';

            return s;
        },

        crc32Table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

        crc32: function(str) {
            var crc = 0 ^ (-1);
            str = str || '';
            for (var i = 0, iTop = str.length; i < iTop; i++) {
                var n = (crc ^ str.charCodeAt(i)) & 0xFF;
                var x = "0x" + this.crc32Table.substr(n * 9, 8);
                crc = (crc >>> 8) ^ x;
            }
            return crc ^ (-1);
        },

        copyToClipBoard: function(text) {
            if (window.clipboardData && clipboardData.setData) {
                clipboardData.setData("text", text);
            } else {
                var supportedBrowsers = ['msie', 'chrome', 'firefox', 'yabrowser', 'opera'];
                if (jQuery.inArray(KS.browser.name, supportedBrowsers) < 0) {
                    KS.warning(KS.L10n.funcWarning + ' ' +
                        'Internet explorer, Google chrome, Mozilla firefox, Яндекс браузер, Opera');
                    return;
                }

                if (navigator.clipboard) {
                    navigator.clipboard.writeText(text);
                } else {
                    var copyFn = function(e) {
                        e.clipboardData.setData('text/plain', text);
                        e.preventDefault();
                        document.removeEventListener('copy', copyFn);
                    };
    
                    document.addEventListener('copy', copyFn);
                    document.execCommand('copy');
                }
            }
        },

        // возвращает следующий уникальный идентификатор
        _unqueID: 0,
        getNextID: function() {
            return ++KS._unqueID;
        },

        _minFakeLink: -1,
        getFakeLink: function() {
            return KS._minFakeLink--;
        },

        // снимает скриншот и возвращает в виде строки
        takeScreenshot: function() {
            var html = $('html').html();
            return html;
        },

        formatSize: function(size, prec) {
            if (size < 1024) {
                return size + ' B';
            } else if (size > 1024 && size < 1024 * 1024) {
                return (size / 1024).toFixed(prec || 2) + ' KB';
            } else {
                return (size / (1024 * 1024)).toFixed(prec || 2) + ' MB)';
            }
        },

        getNbspString: function (value) { return value || '&nbsp' /*'&#160'*/; },

        cleanArray: function (src) {
            var newArray = new Array();
            for (var i = 0; i < src.length; i++) {
                if (!KS.isEmpty(src[i]))
                    newArray.push(src[i]);
            }
            return newArray;
        },

        zeroFill: function (number, width) {
            width -= number.toString().length;
            if (width > 0) {
                return new Array(width + (/\./.test(number) ? 2 : 1)).join('0') + number;
            }
            return number + "";
        },

        parseAjaxDateTime: function (stDateTime) {
            try {
                return eval(stDateTime.substring(1, stDateTime.length - 1));
            } catch (e) {
                return null;
            }
        },

        formatDate: function (date) {
            var day = date.getDate() + "",
                month = (date.getMonth() - 0 + 1) + "";
            day = (day.length != 1) ? day : "0" + day;
            month = (month.length != 1) ? month : "0" + month;
            return day + "." + month + "." + date.getFullYear();
        },

        registerStringCss: function(cssString) {
            cssString && $("<style type='text/css'>" + cssString + "</style>").appendTo("head");
        },

        registerCssStyles: function (cssList) {
            try {
                if (typeof (cssList) == 'string') {
                    cssList = KS.safeDecode(cssList);
                }
            } catch (e) {
                return;
            }

            if (cssList) {
                KS.registeredCss = KS.registeredCss || {};
                var cssBody = '';
                for (var clsIdx in cssList) {
                    var cls = cssList[clsIdx];
                    if (!KS.registeredCss[cls.Selector]) {
                        var props = cls.Properties,
                            clsBody = '';
                        for (var propName in props) {
                            if (propName && props[propName]) {
                                clsBody += '\t' + propName + ': ' + props[propName] + ';\r\n';
                            }
                        }
                        if (cls.Selector && clsBody) {
                            KS.registeredCss[cls.Selector] = clsBody;
                            cssBody += cls.Selector + ' {\r\n' + clsBody + '}\r\n';
                        }
                    }
                }
                if (!KS.isEmpty(cssBody)) {
                    $("<style type='text/css'>" + cssBody + "</style>").appendTo("head");
                }
            }
        },

        getServerUri: function () {
            var href = document.location.href.toLowerCase(),
                workspaceIdx = href.indexOf("/workspace.aspx");
            return (workspaceIdx < 0) ? null : href.substring(0, workspaceIdx);
        },

        checkHtml5UploadSupport: function () {
            return (window.File && window.FileReader && window.FileList && window.Blob);
        },

        openUrl: function (url) {
            if (url) {
                window.open(url, '_blank', 'height=580, width=840, resizable=yes, menubar=yes, location=no,status=yes, scrollbars=yes');
            }
        },
        
        downloadFile: function(url) {
            var link = $('<a/>');

            link.attr('download', url.split('/').reverse()[0]);
            link.attr('href', url);
            link[0].click();
        },

        requestGet: function(name) {
            if ((name = (new RegExp('[?&]' + encodeURIComponent(name) + '=([^&]*)')).exec(location.search)))
                return decodeURIComponent(name[1]);
            return null;
        },

        appendScript: function (jsUrl, onload, onerror) {
            var s = document.createElement('script');
            document.head.appendChild(s);
            s.onload = onload;
            s.onerror = onerror;
            s.type = 'text/javascript';
            s.src = jsUrl;
        }
    });
})();

/* Virtual/abstract - should be implemented by renderer */
(function () {
    function getBrowserInfo() {
        var result = null;
        try {
            var ua = navigator.userAgent, tem,
                M = ua.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i) || [];
            if (/trident/i.test(M[1])) {
                tem = /\brv[ :]+(\d+)/g.exec(ua) || [];
                result = {
                    name: 'msie',
                    fullName: 'Internet Explorer',
                    version: (tem[1] || '')
                };
            } else if (M[1] === 'Chrome') {
                tem = ua.match(/\b(OPR|Edge|YaBrowser)\/(\d+)/);
                if (tem != null) {
                    result = { version: tem[2] };
                    switch (tem[1]) {
                        case 'OPR':
                            result.name = 'opera';
                            result.fullName = 'Opera';
                            break;
                        case 'Edge':
                            result.name = 'edge';
                            result.fullName = 'Microsoft Edge';
                            break;
                        case 'YaBrowser':
                            result.name = 'yabrowser';
                            result.fullName = 'Яндекс.Браузер';
                            break;
                    }
                } else {
                    result = {
                        name: 'chrome',
                        fullName: 'Google Chrome',
                        version: M[2]
                    };
                }
            }
            M = M[2] ? [M[1], M[2]] : [navigator.appName, navigator.appVersion, '-?'];
            if ((tem = ua.match(/version\/(\d+)/i)) != null) {
                M.splice(1, 1, tem[1]);
            }
            if (!result) {
                result = {
                    name: M[0],
                    version: M[1]
                };
                // IE 6-10
                if (result.name === 'MSIE') {
                    result.name = 'msie';
                    result.fullName = 'Internet Explorer';
                }
                if (result.name === 'Firefox') {
                    result.name = 'firefox';
                    result.fullName = 'Mozilla Firefox';
                }
            }
            result.OS = 'Windows';
            if (/Linux/i.test(ua)) {
                result.OS = 'Linux';
            }
            if (/Android/i.test(ua)) {
                result.OS = 'Android';
            }
        } catch (e) {
            result = {
                name: '?',
                version: ''
            }
        }
        return result;
    }

    KS.apply(KS, {
        browser: getBrowserInfo(),

        stub: function () {
        },

        showHtmlProtocol: function (htmlProtocol) {
            KS.alert(htmlProtocol);
        },

        showModal: function () {
        },

        create: function () {
        },

        updateLayout: function () {
        },

        safeDecode: function (json) {
            try {
                return eval(json);
            } catch (e) {
                return null;
            }
        },

        isChrome: function () {
            return navigator.userAgent.toLowerCase().indexOf('chrome') > -1;
        },

        chromeVersion: function () {
            return KS.isChrome() ? navigator.userAgent.replace(/^.*Chrome\/([\d\.]+).*$/i, "$1").split('.') : false;
        },

        isGecko: function () {
            return false;
        },

        isEmpty: function () {
            return false;
        },

        isObject: function (v) {
            return !!v && Object.prototype.toString.call(v) === '[object Object]';
        },

        isString: function (v) {
            return typeof v === 'string';
        },

        isFunction: function (v) {
            return toString.apply(v) === '[object Function]';
        },

        isDefined: function (v) {
            return typeof v !== 'undefined';
        },

        isValid: function (v) {
            return KS.isDefined(v) && v != null;
        },

        isValidProp: function (obj, key) {
            return (String(key) in obj) && obj[String(key)] != null;
        },

        defer: function (fn, args, scope, delay) {
            var t = setTimeout(function () {
                try {
                    fn.apply(scope, args);
                } catch (ex) {
                    KS.error(null, null, null, ex);
                } finally {
                    clearTimeout(t);
                }
            }, delay);
        },

        logoutComplex: function () {
            KS.confirm(KS.L10n.exitComplexQuestion, KS.L10n.exitComplex, function (btn) {
                if (btn !== 'yes' || !KS.isDefined(WorkspaceView)) return;
                WorkspaceView.askLeavePage(false);
                KS.winvoke({ method: 'Logout', async: false, success: KS.esiaLogout });
            });
        }
    });
})();

KS.ns = KS.namespace;

Date.prototype.addDays = function(days) {
    this.setTime(this.getTime() + 86400 * 1000 * days);
    return this;
};
Date.prototype.addMinutes = function(minutes) {
    this.setTime(this.getTime() + 60 * 1000 * minutes);
    return this;
};
Date.prototype.addSeconds = function(seconds) {
    this.setTime(this.getTime() + 1000 * seconds);
    return this;
};