﻿OptionsExportXmlView = KS.extend(BaseDictionaryView, {});

(function(viewClass) {
    KS.apply(viewClass, {

        onServerShowRowEditor: function(value) {
            var view = this;
            view.pseWin = KS.showModal({
                xtype: 'textarea',
                itemId: 'pseArea',
                value: value
            },{
                layout: 'fit',
                plain: true,
                frame: true,
                autoScroll: true,
                modal: true,
                maximizable: true,
                minWidth: 400,
                minHeight: 300,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                title: "Редактирование...",
                buttonAlign: 'right',
                buttons: new Array({
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            var newValue = view.pseWin.getComponent("pseArea").getValue();
                            view.serverCall({
                                method: 'SaveTemplate',
                                params: [newValue]
                            });
                            view.pseWin.close();
                        }
                    }, 
                    {   xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.pseWin.close();
                        }
                    })
            }, true);
        }
    });
}(OptionsExportXmlView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();