﻿DocumentsForSignView = KS.extend(BaseReportTaskListView, {
    customName: 'DocumentForSignView'
});

(function (viewClass) {
    var sc = DocumentsForSignView.superclass;
    
    KS.apply(viewClass, {
        onTemplateRendered: function() {
            this.tunePeriodComp();
        },

        processToolbarItemControl: function(ctrl, tbarNode) {
            switch (tbarNode.code) {
                case 'Container1': // Компонент выбора периода
                    ctrl = this.createTemplateControl(this.tpl.controls['periodComponent']);
                    break;

                case 'Container2': // Комбобокс "Отображать отчеты"
                    ctrl.on('select', this.documentTypeComboChange, this);
                    break;

                case 'Container3': // Чекбокс "Все периоды"
                    ctrl.on('change', this.allPeriodsCheckedChange, this);
                    break;

            }
            return sc.processToolbarItemControl.call(this, ctrl, tbarNode);
        },

        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {
                case "PRINT_MENU":
                case 'EDS':
                    return null;

                case "PRINT":
                    return this.executeToolbarOperation;

                case 'EDS_SIGN':
                    return this.taskListSign;

                case 'EDS_CHECK_SERT':
                    return this.edsCheckCert;

                case 'REFRESH':
                case 'EXIT':
                case 'MARK_INVERT':
                case 'MARK_INVERT2':
                case 'MARK_TOP':
                case 'MARK_ALL':
                case 'MARK_REST':
                case 'MARK_BETWEEN':
                case 'UNMARK':
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
            return this.executeToolbarOperation;
        },

        taskListSign: function () {
            var view = this.parentView,
                grid = view.mainGrid;
            if (view.data.settings.ReportEdsSchema > 0) {
                view.executeOperation('EDS_SIGN', grid);
            } else {
                view.ccc = grid.getCheckedCodes(true);
                view.executeOperation('EDS_CHECK', grid);
            }
        },

        executeToolbarOperation: function() {
            var view = this.parentView,
                grid = view.mainGrid;
            if (grid && this.tbarNode) {
                var code = this.tbarNode.code || '',
                    confirmMsg = view.getConfirmMessage(grid, code);
                if (confirmMsg) {
                    KS.confirm(confirmMsg + '. Продолжить?', "Подтвердите действие", function(btn) {
                        if (btn === 'yes') view.executeOperation(code, grid);
                    });
                } else {
                    view.executeOperation(code, grid);
                }
            } else {
                KS.msg('Неизвестная команда');
            }
        },

        tunePeriodComp: function() {
            var periodComp = this.getPeriodComp();
            var allCheckValue = this.getAllPeriodsComp().setValue(false);
        },

        getPeriodComp: function() {
            return this.getToolbarItem(this.mainGrid, null, "Container1");
        },

        getAllPeriodsComp: function() {
            return this.getToolbarItem(this.mainGrid, null, "Container3");
        },

        periodCompChange:function() {
            var periodComp = this.getPeriodComp();
            this.serverCall({
                method: 'PeriodComponentChange',
                params: [periodComp.getPeriod()],
                success: function() {
                    this.mainGrid.reload();
                }
            });
        },

        allPeriodsCheckedChange: function(checkbox, newValue) {
            var periodComp = this.getPeriodComp();
            periodComp.setDisabled(newValue);
            this.serverCall({
                method: 'AllPeriodsCheckedChange',
                params: [newValue, periodComp.getPeriod()],
                success: function() {
                    this.mainGrid.reload();
                }
            });
        },

        documentTypeComboChange: function(combo) {
            var newValue = combo.getValue();
            this.serverCall({
                method: 'DocumentTypeComboChange',
                params: [newValue],
                success: function() {
                    this.mainGrid.reload();
                }
            });
        },

        getConfirmMessage: function (grid, code) {
            var msg = null,
                rows = this.buildChosenRows(grid);
            code = code.toUpperCase();
            if (code === 'EDS_UNSIGN' && !Ext.isEmpty(rows)) {
                msg = 'Вы действительно хотите снять подпись?';
            }
            return msg;
        },

        rowDblClickHandler: function() {
            this.editDocument();
        },

        editDocument: function () {
            var view = this.parentView || this,
                grid = view.mainGrid,
                rows = grid.getCheckedRows();
            if (Ext.isEmpty(rows)) return;
            grid.parentView.executeOperation('EDIT', grid, { taskType: 0 });
        },

        executeOperation: function (opCode, grid, additional) {
            if (this.excelClientParams){
                opCode = this.excelClientParams.code;
                grid = this.excelClientParams.grid;
                this.excelClientParams = null;
            }
            var rows = this.buildChosenRows(grid, opCode !== 'CREATE_NOTIFICATION');
            this.currentOpArgs = [].slice.call(arguments);
            this.serverCall({
                method: 'OnExecuteOperation',
                params: [opCode, rows, additional || {}],
                success: this.executeOperationCallback
            });
        },

        executeOperationCallback: function (result) {
            switch (result.operationCode) {

                case 'EDS_UNSIGN':
                case 'CREATE_NOTIFICATION':
                case 'CREATE_NOTIFICATION2':
                    this.mainGrid.reload();
                    break;

                case 'EDS_CHECK':
                    if (KS.isEmpty(result.errorProtocol)) {
                        var view = this;
                        view.signDataSelector(view.ccc, function () { view.executeOperation('EDS_SIGN', view.mainGrid); });
                        delete view.ccc;
                    } else {
                        KS.Svod.showHtmlProtocol(result.errorProtocol);
                    }
                    break;

                case 'EDS_SIGN':
                    this.afterTrySign(result.signedData);
                    break;

                default:
                    break;
            }

            this.processTaskResult(result.taskResultContext);
        },

        refreshDocuments: function () {
            var view = this.parentView || this;
            view.mainGrid.unmark();
            view.mainGrid.checkedCodes = [];
            view.serverCall({
                method: 'RefreshDocuments',
                cancellable: true,
                waitMessage: 'Обновление списка ...',
                success: view.refreshDocumentsCallback
            });
        },

        refreshDocumentsCallback: function() {
            this.mainGrid.reload();
        }
    });
}(DocumentsForSignView.prototype));

// ============= RENDERERS =======================
function defaultLinkSettingRenderer(value, metadata, record) {
    if (KS.Grid.getAnyCase(record, 'HIGHLIGHT') &&
        KS.Grid.getAnyCase(record, 'HIGHLIGHT') != '-1')
        return value;
    var ls = KS.Grid.getAnyCase(record, 'LINK_SETTING');
    if (ls) metadata.css += ' link-setting-' + ls;
    return value;
}

function forSignVdksRenderer(value, metadata, record, rowIndex, colIndex, store) {
    defaultLinkSettingRenderer(value, metadata, record);
    var vec = KS.Grid.getAnyCase(record, 'VDKS_ERROR_COUNT'),
        isWaring = (KS.Grid.getAnyCase(record, 'CHECK_ERROR') == 2),
        view = store.grid.parentView;
    if (Ext.isEmpty(vec)) {
        return '';
    } else if (vec == 0) {
        metadata.css += ' link-setting-88';
    } else if (isWaring) {
        metadata.css += ' link-setting-77';
    } else {
        metadata.css += ' link-setting-99';
    }
    return '<span class="like-hypertext" onclick="' + getTLOArgs('VDKS_ERROR_COUNT', view, store, 1) + '">' + vec + '</span>';
}

function forSignMdksRenderer(value, metadata, record, rowIndex, colIndex, store) {
    defaultLinkSettingRenderer(value, metadata, record);
    var state = +record.data.MDKS_ERROR_STATE,
        view = store.grid.parentView;
    switch (state) {
        case 1:
            metadata.css += ' link-setting-88';
            break;
        case 2:
            metadata.css += ' link-setting-99';
            break;
        case 3:
            metadata.css += ' link-setting-77';
            break;
        default:
            return value;
    }
    return '<span class="like-hypertext" onclick="' + getTLOArgs('MDKS_ERROR', view, store, 1) + '">' +value + '</span>';
}

function forSignEdsRenderer(value, metadata, record) {
    defaultLinkSettingRenderer(value, metadata, record);
    if (KS.isEmpty(value) || value.indexOf('/') < 0) {
        return value;
    }
    var parts = value.split('/'),
        count = +parts[0],
        need = +parts[1];
    if (need > 0) {
        if (count === need) {
            metadata.css += ' link-setting-88';
        } else if (count === 0) {
            metadata.css += ' link-setting-99';
        } else if (count < need) {
            metadata.css += ' link-setting-77';
        }
    }
    return '<span style="text-align: center;">' + value + '</span>';
}

function forSignFilesRenderer(value, metadata, record, rowIndex, colIndex, store) {
    defaultLinkSettingRenderer(value, metadata, record);
    var hasFiles = KS.Grid.getAnyCase(record, 'EXIST_FILE'),
        view = store.grid.parentView;
    return (hasFiles === true || (KS.isString(hasFiles) && hasFiles.toLowerCase() === 'true'))
        ? '<img src="PlatformHandler.axd?icon=attach.png" onclick="' + getTLOArgs('EXIST_FILE', view, store, 5) + '"/>'
        : '';
}

function getTLOArgs(key, view, store, taskType) {
    return "execTaskListOperation('" + key + "','" + view.viewID + "','" + store.grid.itemId + "'," + taskType + ");";
}

function execTaskListOperation(key, viewId, gridId, taskType) {
    var view = KS.getView(viewId);
    if (view)
        setTimeout(function() {
            view.executeOperation(key, view[gridId], { taskType: taskType });
        }, 0);
}