﻿PerformanceView = KS.extend(KS.Ext.ClientView, {
    onTemplateRendered: function () {
        this.fetchData();
    },

    fetchData: function () {
        var view = this.parentView || this;

        view.collectFormValues();
        view.serverCall({
            method: 'DoFetchData',
            waitMessage: 'Чтение данных...',
            params: [view.data],
            success: function (dataSeries) {
                view.dataSeries = dataSeries;
                view.setDictionaries();
                view.applyKeyFilters();
            }
        });
    },

    saveFilteredData: function () {
        var view = this.parentView || this;
        view.collectFormValues();
        view.serverCall({
            method: 'SaveFilteredData',
            waitMessage: 'Сохранение выборки...',
            params: [view.data],
            success: KS.openUrl
        });
    },

    exportData: function () {
        var view = this.parentView || this;
        view.serverCall({
            method: 'ExportCountersData',
            waitMessage: 'Экспорт базы счетчиков производительности ...',
            success: KS.openUrl
        });
    }
});

// Filters
(function (viewClass) {
    KS.apply(viewClass, {
        collectFormValues: function () {
            var view = this;

            view.data.BeginDate = Ext.util.Format.date(view.beginDate.getValue(), 'Y-m-d');
            view.data.BeginTime = view.beginTime.getValue();
            view.data.EndDate = Ext.util.Format.date(view.endDate.getValue(), 'Y-m-d');
            view.data.EndTime = view.endTime.getValue();

            view.data.User = view.user.getValue();

            Ext.each(view.data.Counters, function (counter) {
                var counterControl = view.filters.items.findBy(function (fset) {
                    return fset.title === this.Name;
                }, counter);
                if (counterControl) {
                    counter.Checked = !counterControl.collapsed;
                    counterControl.items.each(function (item, idx) {
                        if (!counterControl.collapsed && item.isComposite) {
                            counterControl.counter.Keys[idx].Filter = item.txt.getValue();
                        }
                    });
                }
            });
        },

        applyKeyFilters: function () {
            var view = this;
            view.collectFormValues();
            view.serverCall({
                method: 'ApplyKeyFilters',
                waitMessage: 'Обработка данных...',
                params: [view.data],
                success: function (dataSeries) {
                    view.dataSeries = dataSeries;
                    view.updateChart();
                }
            });
        },

        findCounterControl: function (name) {
            var view = this,
                result = null;
            Ext.each(view.counterControls, function (counterControl) {
                if (counterControl.title === name) {
                    result = counterControl;
                }
            });
            return result;
        },

        findDataSerie: function (name) {
            var view = this,
                result = null;
            Ext.each(view.dataSeries, function (dataSerie) {
                if (dataSerie.Name === name) {
                    result = dataSerie;
                }
            });
            return result;
        },

        setDictionaries: function () {
            var view = this;
            Ext.each(view.counterControls, function (counterControl) {
                var counter = counterControl.counter,
                    dataSerie = view.findDataSerie(counter.Name);
                Ext.each(counter.Keys, function (key, keyIdx) {
                    var dict = null,
                        composite = counterControl.items.items[keyIdx];
                    if (!composite.selBtn) {
                        return;
                    }
                    if (dataSerie && dataSerie.KeyDictionaries) {
                        dict = dataSerie.KeyDictionaries['key' + keyIdx];
                    }
                    composite.selBtn.dict = dict;
                    composite.selBtn.setDisabled(!dict || dict.length == 0);
                });
            });
        },

        showDictionary: function (selBtn) {
        },

        clearKeyFilter: function (clrBtn) {
            if (Ext.isEmpty(clrBtn.txt.getValue())) return;
            clrBtn.txt.setValue('');
            this.applyKeyFilters();
        },

        selectDictValue: function () {
            var view = this;
            var selection = view.dictGrid.getSelectionModel().getSelected();
            if (!selection) {
                return;
            }
            view.dictGrid.txt.setValue(selection.get('txt'));
            view.dictWindow.close(true);
            view.applyKeyFilters();
        }
    });
}(PerformanceView.prototype));

// Chart
(function (viewClass) {
    KS.apply(viewClass, {
        updateChart: function () {
            var view = this;
            if (!view.dataSeries) return;
            view.chartPanelWrapper.removeAll();
            Ext.define('ChartStore',
                {
                    extend: 'Ext.data.Store'
                });

            var chartSeries = [];
            var yAxises = [];
            var color = ['#FF0000', '#00BFFF', '#008000', '#FFFF00', '#800080', '#0000FF', '#800000'];
            var points = 0;
            var data = [];
            var yName, colorSerie, maxVal = 0;

            Ext.each(view.dataSeries, function (dataSerie, dsIdx) {
                Ext.each(dataSerie.Values, function (value, valIdx) {
                    if (value.JavaScriptStamp > 0 && !isNaN(parseFloat(value.Value))) {
                        var xvalue = value.JavaScriptStamp;
                        var timezoneOffset1 = new Date(value.JavaScriptStamp).getTimezoneOffset();
                        var date1 = new Date(value.JavaScriptStamp).setMinutes(new Date(value.JavaScriptStamp).getMinutes() + timezoneOffset1);
                        if (maxVal < value.Value)
                            maxVal = value.Value;
                        switch (dataSerie.Name) {
                            case "Users":
                                xvalue = value.JavaScriptStamp;
                                data.push({
                                    x: date1,
                                    data1: +value.Value,
                                    data2: null, data3: null,
                                    description: value
                                });
                                break;
                            case "CPU":
                                xvalue = valIdx;
                                data.push({
                                    x: date1,
                                    data2: +value.Value,
                                    data1: null, data3: null,
                                    description: value
                                });
                                break;
                            case "Memory":
                                xvalue = valIdx;
                                data.push({
                                    x: date1,
                                    data3: (+value.Value) / 1073741824, // чтобы значение было в гигабайтах
                                    data2: null, data1: null,
                                    description: value
                                });
                                break;
                            default:
                                xvalue = valIdx;
                                data.push({
                                    x: date1,
                                    data3: +value.Value,
                                    data2: null, data1: null,
                                    description: value
                                });
                                break;
                        }
                    }

                    points++;
                });

                switch (dataSerie.Name) {
                    case "Users":
                        yName = 'data1';
                        colorSerie = color[0];
                        break;
                    case "CPU":
                        yName = 'data2';
                        colorSerie = color[1];
                        break;
                    case "Memory":
                        yName = 'data3';
                        colorSerie = color[2];
                        dataSerie.Unit = "Gbyte"
                        maxVal /= 1073741824;
                        break;
                    default:
                        yName = 'data3';
                        colorSerie = color[2];
                        break;
                }

                yAxises.push({
                    type: 'numeric',
                    minimum: 0,
                    position: 'left',
                    maximum: (maxVal > 40) ? (maxVal + 10) : (maxVal + 2),
                    fields: [yName],
                    title: {
                        fields: yName,
                        text: dataSerie.Name + (!Ext.isEmpty(dataSerie.Unit) ? (", " + dataSerie.Unit) : ""),
                        color: colorSerie
                    },
                    style: {
                        strokeStyle: colorSerie
                    },
                    label: {
                        fill: colorSerie
                    }
                });

                chartSeries.push({
                    type: 'line',
                    title: dataSerie.Name,
                    xField: 'x',
                    yField: [yName],
                    marker: {
                        animation: {
                            duration: 200,
                            easing: 'backOut'
                        },
                        radius: 4,
                        color: colorSerie
                    },
                    style: {
                        lineWidth: 2,
                        strokeStyle: colorSerie
                    },
                    highlightCfg: {
                        scaling: 2
                    },
                    tooltip: {
                        trackMouse: true,
                        renderer: function (toolT, record, item) {
                            var title = item.series.getTitle();
                            var field;
                            switch (title) {
                                case "Users":
                                    field = 'data1';
                                    break;
                                case "CPU":
                                    field = 'data2';
                                    break;
                                default:
                                    field = 'data3';
                                    break;
                            }
                            var keys = '';
                            var description = record.get('description');
                            if (description && description.Keys) {
                                Ext.each(description.Keys, function(key) {
                                    if (!Ext.isEmpty(key)) {
                                        keys += key + '<br>';
                                    }
                                });
                            }
                            toolT.setHtml('<b>' +
                                title + ' = ' + record.get(field) +
                                '</b><br>' +
                                (new Date(record.get('x')).toLocaleTimeString()) +
                                '<br>' + keys);
                        }
                    }
                });
                maxVal = 0;
            });

            yAxises.push({
                id: 'bottom',
                position: 'bottom',
                type: 'time',
                dateFormat: 'H:i:s ',
                grid: true, fields: ['x'],
                tooltipFormat: "H:i"
            });

            var chart = {
                xtype: 'chartnavigator',
                reference: 'refChartNavigator',
                autoShow: true,
                title: "Статистика производительности" +
                    "(Счетчиков: " + view.dataSeries.length + ", точек: " + points + ")",
                layout: 'fit',
                width: '10%',
                height: 300,
                chart: {
                    xtype: 'cartesian',
                    reference: 'refDataChart',
                    width: '100%',
                    height: '100%',
                    interactions: {
                        type: 'panzoom',
                        zoomOnPanGesture: false,
                        axes: {
                            left: {
                                allowPan: false,
                                allowZoom: false
                            }
                        }
                    },
                    animation: {
                        duration: 200
                    },
                    innerPadding: {
                        left: 40,
                        right: 40
                    },
                    store: {
                        fields: ['x', 'data3', 'data2', 'data1'],
                        data: data
                    },
                    axes: yAxises,
                    series: chartSeries
                },
                navigator: {
                    axis: 'bottom',
                    xAxis: {
                        tickPixelInterval: 100,
                        gridLineColor: '#ffcccc',
                        gridLineWidth: 15
                    }
                }
            };
            view.chartPanelWrapper.add(Ext.create('Ext.chart.navigator.Container', chart));
        },

        renderChart: function () {
            var view = this,
                chartSeries = [];

            view.valuesDict = {};
        }
    });
}(PerformanceView.prototype));

// Browsers
(function (viewClass) {
    KS.apply(viewClass, {
        getBrowsersInfo: function () {
            var view = this.parentView || this;
            view.collectFormValues();
            view.serverCall({
                method: 'GetBrowsersInfo',
                params: [view.data],
                progressOnly: true,
                success: view.updateBrowsersInfo
            });
        },

        updateBrowsersInfo: function (data) {
            var store = this.browsers.getStore();
            store.removeAll();
            this.versions.getStore().removeAll();
            if (data) {
                for (var name in data) {
                    if (data.hasOwnProperty(name)) {
                        var details = data[name],
                            versions = '',
                            versionsCount = 0,
                            count = 0;
                        for (var version in details) {
                            if (details.hasOwnProperty(version)) {
                                versionsCount++;
                                versions += version + ',';
                                count += details[version];
                            }
                        }
                        var newRec = this.browsers.addRecord({
                            txt: name /*+ ' (' + versions.substring(0, versions.length - 1) + ')'*/,
                            versionsCount: count,
                            count: count
                        });
                        newRec.details = details;
                        store.add(newRec);
                    }
                }
            }
            this.calcPercents(store);
            this.updateBrowsersChart(store);
        },

        calcPercents: function (store) {
            var all = 0;
            store.each(function (rec) {
                all += +rec.get('count');
            });
            store.each(function (rec) {
                rec.set('percent', +Math.round(rec.get('count') * 1000 / all) / 10);
                rec.commit();
            });
        },

        selectBrowser: function (grid, browRow) {
            var details = browRow.details || {},
                store = this.versions.getStore();
            store.browName = browRow.get('txt');
            store.removeAll();
            for (var version in details) {
                if (details.hasOwnProperty(version)) {
                    var newRec = this.versions.addRecord({
                        txt: version,
                        count: details[version]
                    });
                    store.add(newRec);
                }
            }
            this.calcPercents(store);
            this.updateBrowsersChart(store);
        },

        updateBrowsersChart: function (store) {
            this.browsersPanelWrapper.removeAll();
            var data = [];
            store.each(function (rec) {
                data.push({
                    name: rec.get('txt'),
                    y: rec.get('count')
                });
            });

            // draw beautiful pie
            //var  themes = Ext.chart.theme;
            var chart = Ext.create({
                xtype: 'polar',
                title: "Статистика браузеров",
                width: 50,
                height: 50,
                innerPadding: 85,
                animate: true,
                theme: 'Sky',
                interactions: ['rotate', 'itemhighlight'],
                store: {
                    fields: ['name', 'y'],
                    data: data
                },
                series: {
                    type: 'pie3d',
                    highlight: true,
                    angleField: 'y',
                    label: {
                        field: 'name',
                        display: 'rotate'
                    },
                    tooltip: {
                        trackMouse: true,
                        style: 'background: #fff',
                        renderer: function (storeItem, item) {
                            var all = 0;
                            store.each(function (rec) {
                                all += +rec.get('count');
                            });
                            storeItem.setHtml(item.get('name') + ': ' + Math.round(item.get('y') * 1000 / all) / 10 + '%');
                        }
                    },
                    donut: 0
                }
            });
            this.browsersPanelWrapper.add(chart);
        }
    });
}(PerformanceView.prototype));