﻿DictionaryEODView = KS.extend(BaseDictionaryView, {});

// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function () {
            this.cachedValues = [];
            this.mainGridJsonLoad();
        },

        touch: function () {
            this.hasChanges = true;
            this.setSavedState(false);
            this.getToolbarItem(this.rootPanel, null, 'SAVE').setDisabled(false);
        },

        discardChanges: function () {
            this.hasChanges = false;
            this.setSavedState(true);
            this.getToolbarItem(this.rootPanel, null, 'SAVE').setDisabled(true);
        },

        saveChanges: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'SaveChangesDictEOD',
                params: [view.cachedValues],
                waitMessage: 'Сохранение...',
                success: view.saveChangesCallback
            });
        },

        saveChangesCallback: function(hasError) {
            if (!hasError) {
                this.discardChanges();
                this.reload();
                this.cachedValues = [];
            }
        },

        resetView: function () {
            this.mainGrid.reload();
            this.formatDescGrid.reload();
        },

        deleteHandler: function() {
            var view = this.parentView || this;
            var gridId = this.gridPropertyName;
            if (!view[gridId]) return;
            var ccc = view[gridId].getCheckedCodes(true);
            if (Ext.isEmpty(ccc)) return;
            KS.confirm("Удалить выделенные строки?", "Подтвердите удаление", function (btn) {
                if (btn === 'yes')
                    view.deleteHandlerInternal(ccc, gridId);
            });
        },

        deleteHandlerInternal: function (ccc, gridId) {
            var view = this;
            this.serverCall({
                method: 'DeleteEODRows',
                params: [gridId, ccc],
                waitMessage: 'Удаление ...',
                success: function(deleted) {
                    if (deleted) {
                        view[gridId].reload();
                        view.touch();
                    }
                }
            });
        },

        mainGridJsonLoad: function() {
            var checkedRows = this.mainGrid.getCheckedRows();
            if (checkedRows.length > 0) {
                this.selectMainGrid(this.mainGrid, checkedRows[0]);
            }
        },

        selectMainGrid: function(grid, record) {
            this.formatDescrFilter = "link_exchange_format = -1";
            var linkFormat = KS.Grid.getAnyCase(record, "LINK_EXCHANGE_FORMAT");
            if (linkFormat) {
                this.formatDescrFilter += " OR link_exchange_format = " + linkFormat;
            }
            this.formatDescGrid.reload();
        },

        getAdditionalGetDataParams: function(gdp) {
            if (gdp.itemId === "formatDescGrid") {
                gdp.constantFilter = this.formatDescrFilter || "";
            }
        },

        editGridCell: function(plugin, context) {
            if (context.originalValue !== context.value) {
                this.addInCachedValues(context.grid.ctrlId, 
                    context.grid.closeCode, 
                    KS.Grid.getAnyCase(context.record, context.grid.closeCode),
                    context.field, 
                    context.value);
                this.touch();
            }
        },

        addInCachedValues: function(gridId, closeCodeFieldName, closeCodeValue, dataIndex, newValue) {
            var cvalue = {
                'gridId': gridId,
                'closeCodeFieldName': closeCodeFieldName,
                'closeCodeValue': closeCodeValue,
                'dataIndex': dataIndex,
                'newValue': newValue
            };
            this.cachedValues.push(cvalue);
        },

        addNewEODFormat: function() {
            var view = this.parentView;
            view.createEODFormatPropGrid("NEW", null);
        },

        editEODFormat: function() {
            var view = this.parentView;
            var closeCodes = view.mainGrid.getCheckedCodes();
            if (closeCodes.length > 0) {
                view.createEODFormatPropGrid("EDIT", closeCodes[0]);
            }
        },

        dblclickMainGrid: function(gridView, td, cellIndex, record) {
            if (this.data.isSelecting) {
                this.select();
            } else {
                var closeCode = KS.Grid.getAnyCase(record, gridView.grid.closeCode);
                if (closeCode) {
                    this.createEODFormatPropGrid("EDIT", closeCode);
                }
            }
        },

        addNewEODFormatDesc: function() {
            var view = this.parentView || this;
            var checkedRows = view.mainGrid.getCheckedRows();
            if (checkedRows.length > 0) {
                var linkFormat = KS.Grid.getAnyCase(checkedRows[0], "LINK_EXCHANGE_FORMAT");
                var closeCodeName = view.formatDescGrid.closeCode;
                view.serverCall({
                    method: 'AddEODDescRow',
                    disableFog: true,
                    params: [linkFormat, closeCodeName],
                    success: function(dataRow) {
                        view.formatDescGrid.addRecord(dataRow);
                        view.touch();
                    }
                });
            }
        },

        cellClickFormatGrid: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            var col = e.position.column;
            if (col.editable && 
                col.dataIndex === "SCHEMA") {
                var value = KS.Grid.getAnyCase(record, col.dataIndex);
                this.showPopupStringEditor(value, col, record, gridView.grid);
                return false;
            }
        },

        showPopupStringEditor: function (value, cfg, rec, grid) {
            var view = this;
            view.pseWin = KS.showModal({
                xtype: 'textarea',
                itemId: 'pseArea',
                value: value
            },{
                layout: 'fit',
                plain: true,
                frame: true,
                autoScroll: true,
                modal: true,
                maximizable: true,
                minWidth: 400,
                minHeight: 300,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                title: cfg.text,
                buttonAlign: 'right',
                buttons: new Array({
                    text: 'Применить',
                    cls: 'marked-button',
                    handler: function () {
                        var newValue = view.pseWin.getComponent("pseArea").getValue();
                        if (value !== newValue) {
                            rec.set(cfg.dataIndex, newValue);
                            view.addInCachedValues(grid.ctrlId, grid.closeCode, KS.Grid.getAnyCase(rec, grid.closeCode), cfg.dataIndex, newValue);
                            view.touch();
                        }
                        view.pseWin.close(true);
                    }
                })
            }, true);

            view.pseWin.getComponent("pseArea").selectText(value.length);
        },

        editEODFormatDesc: function() {

        },

        createEODFormatPropGrid: function(mode, closeCode) {
            var view = this;
            var closeCodeName = this.mainGrid.closeCode;
            view.serverCall({
                method: 'GetEODPropGridData',
                waitMessage: 'Открывается ...',
                params: [mode, closeCode, closeCodeName],
                success: function(settings) {
                    view.showEODFormatPropGrid(settings, mode === "EDIT", closeCode);
                }
            });
        },

        showEODFormatPropGrid: function(settings, isEdit, closeCode) {
            this.eodFormatGrid = this.getPropertyGridByOption(settings, "eodFormatGrid", "Свойства");
            var view = this;
            this.eodFormatPanel =  KS.showModal(this.eodFormatGrid, {
                title: 'Свойства',
                autoHeight: false,    
                layout: "fit",
                height: 500, 
                minHeight: 200,
                width: 650,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.editEODFormGrid(isEdit, closeCode);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.eodFormatPanel.close();
                        }
                    }]
            }, true);
        },

        editEODFormGrid: function(isEdit, closeCode) {
            var view = this;
            var newValues = this.eodFormatGrid.source;
            var closeCodeName = this.mainGrid.closeCode;
            view.serverCall({
                method: 'EditEODFormat',
                params: [newValues, isEdit, closeCode, closeCodeName],
                waitMessage: isEdit ? 'Редактрование ...' : 'Создание ...',
                success: function(result) {
                    if (result === true) {
                        view.mainGrid.reload();
                        view.eodFormatPanel.close();
                        view.touch();
                    }
                }
            });
        }
    });
}(DictionaryEODView.prototype));

Ext.define('DictionaryEOD.numberEditor',
    {
        extend: 'Ext.form.TextField',
        allowBlank: true,
        maskRe: /[0-9.,-]/
    });

function dictionaryEODDateRenderer(value) {
    if (!Ext.isEmpty(value) && (new Date(value) != "Invalid Date")) {
        value = new Date(value);
    }
    if (Ext.isString(value) && !Ext.isEmpty(value)) {
//        var parsed = KS.parseAjaxDateTime(value);
//        if (parsed) {
//            value = Ext.util.Format.date(parsed, 'd.m.Y');
//        } else if (value.length > 10) {
            value = value.substring(0, 10);
//        }
    } else {
        value = Ext.util.Format.date(value, 'd.m.Y');
    }
    return (value == '06.06.2079') ? '' : value;
}

function dictionaryEODSchemeRenderer(value) {
    return "<xmp style='margin: 0'>" + value + "</xmp>";
}

if (typeof (Sys) !== 'undefined') { Sys.Application.notifyScriptLoaded(); }