////////////////////////////////////////////////////////////////////////////////
KS.MacroSequenceData = function(data) {
    var me = this;
    me.Sequence = data.Sequence || null;
    me.Key = data.Key || null;
    me.CurrentIndex = data.CurrentIndex;
    me.Functions = data.Functions || [];
    me.OnCompleteTaskName = data.OnCompleteTaskName;
    me.OnFailedTaskName = data.OnFailedTaskName;
    me.Arguments = data.Arguments || { };
};

KS.MacroSequence = KS.extend(KS.MacroSequenceData, {
    constructor: function(data) {
        KS.MacroSequence.superclass.constructor.call(this, data);

        var me = this, i, j, k, f, p, r, cSchema;
        me.terminated = false;

        me.ClassName = "MacroSequence";
        me.CallerView = data.CallerView || ((!!me.Arguments && !!me.Arguments.CALLER_VIEW_ID) ? KS.getView(me.Arguments.CALLER_VIEW_ID) : null);
        me.CallerInfo = data.CallerInfo;

        cSchema = (!!data.Arguments && !!data.Arguments.DICTIONARY_ARGUMENTS) ? data.Arguments.DICTIONARY_ARGUMENTS.ControlSchema : null;
        me.cmpxID = !cSchema ? "" : String.format("{0}.{1}", cSchema.TableIndex, cSchema.ColumnName);

        //для удобства обращения к макросу
        if (!!me.Sequence.Function) {
            for (i = 0; i < me.Sequence.Function.length; i++) {
                f = me.Sequence.Function[i];
                f.isClient = f.Name in KS.clientTasks;
                if (!f.Param) continue;
                //преобразование параметра от <Rel> и для доступа к нему по его имени
                for (j = 0; j < f.Param.length; j++) {
                    p = f.Param[j];
                    if (!!p.Rel) {
                        r = p.Rel.split(",");
                        for (k = 0; k < r.length; k++)
                            p.Value = KS.Replace(p.Value, "{" + (k + 1) + "}", "{" + r[k] + "}");
                    }
                    f.Param[p.Name] = p;
                }
                //значение параметра
                f.getParamValue = function(g) { return !g ? "" : (KS.IsEmpty(g.Value) ? "" : g.Value); };
            }
        }
    },

    moveNext: function() {
        var ret = false;

        if (this.terminated)
            return false;

        if (typeof(this.Sequence) !== 'undefined' && this.Sequence != null) {
            var n = this.CurrentIndex + 1;
            if (n < this.Sequence.Function.length) {
                this.CurrentIndex = n;
                ret = true;
            }
        }
        return ret;
    },

    getCurrentMacro: function() {
        var macro = null;
        if (typeof(this.Sequence) !== 'undefined' && this.Sequence != null &&
            this.CurrentIndex >= 0 && this.CurrentIndex < this.Sequence.Function.length) {
            macro = this.Sequence.Function[this.CurrentIndex];
        }
        return macro;
    },

    getPreviousMacro: function() {
        var macro = null;
        if (typeof(this.Sequence) !== 'undefined' && this.Sequence != null && this.CurrentIndex > 0) {
            macro = this.Sequence.Function[this.CurrentIndex - 1];
        }
        return macro;
    },

    getNextMacro: function() {
        var macro = null;
        if (typeof(this.Sequence) !== 'undefined' && this.Sequence != null && this.CurrentIndex < this.Sequence.Function.length - 1) {
            macro = this.Sequence.Function[this.CurrentIndex + 1];
        }
        return macro;
    },

    invokeStep: function() {
        var me = this;
        if (me.terminated) return;
        var taskName = me.getCurrentMacro().Name;
        if (taskName in KS.clientTasks) {
            setTimeout(function() {
                KS.clientTasks[taskName].fn(me);
                if (!KS.clientTasks[taskName].fledged)
                    KS.MacroManager.executeNextStep(me);
            }, 0);
        } else {
            me.CurrentIndex -= 1;
            me.jumpToServer();
        }
    },

    jumpToServer: function() {
        if (this.terminated) return;
        var data = KS.isDefined(this.CallerView) && KS.isFunction(this.CallerView.getSyncData) ? this.CallerView.getSyncData() : null;
        if (KS.IsEmpty(this.Key)) {
            this.CallerView.serverCall({
                method: 'CreateMacroExecution',
                waitMessage: KS.L10n.waitMessage,
                params: [this.CurrentIndex, this.Arguments, data]
            });
        } else {
            this.CallerView.serverCall({
                method: 'ContinueMacroExecution',
                params: [this.Key, this.CurrentIndex, this.Arguments, data]
            });
        }
    },

    terminate: function() {
        this.terminated = true;
        WorkspaceView.serverCall.apply(WorkspaceView, [{
            method: 'TerminateMacroExecution',
            params: [this.Key]
        }]);
    }
});

KS.MacroManager = { };
KS.apply(KS.MacroManager, {
    executeNextStep: function(sequence) {
        if (!!sequence.CallerView) {
            sequence.CallerView.syncClientData.apply(sequence.CallerView, [sequence]);
        }

        if (sequence.terminated) return;

        if (!sequence.moveNext())
        {
            if (!KS.IsEmpty(sequence.Key))
                sequence.jumpToServer.apply(sequence);
            return;
        }
        sequence.invokeStep.apply(sequence);
    }
});