////////////////////////////////////////////////////////////////////////////////
// Ajax core
KS.Ajax = {
    isOnline: true,
    pingTimer: null,

    setOnline: function(o) {
        KS.Ajax.isOnline = !!o;
        return false;
    },

    pingServer: function() {
        var id;
        if (typeof(KS.pageView) !== 'undefined')
            id = KS.pageView.id + ',Simplified';
        else if (typeof(WorkspaceView) !== 'undefined')
            id = WorkspaceView.id + ',Explorer';
        else //if (typeof(OutcastView) !== 'undefined')
            id = OutcastView.id + ',Explorer';
        id += ',' + KS.desktop;

        var p = new KS.Ajax.Request({
            data: id,
            url: KS.pingPath,
            method: 'PingSession',
            detectOffline: true,
            success: function() {
                KS.Ajax.setOnline(true);
            },
            error: function() {
                KS.Ajax.setOnline(false);
            }
        });

        $.ajax(p);
    },

    showOnlineStatus: function(/*palki*/) {
    }
};

KS.Ajax.Request = function() {
    var me = this;

    me.uniqueID = KS.getNextID();
    me.type = 'POST';
    me.cache = false;
    me.context = me;
    me.viewContext = null;
    me.dataType = 'json';
    me.processData = false;
    me.contentType = 'application/json';
    me.waitMessage = KS.L10n.waitMessage;
    me.disableFog = false;
    me.async = null;
    me.repeatCounter = 0;
    me.cancellable = false;
    me.detectOffline = false; // включение логики обнаружения оффлайна

    me.onError = me.onSuccess = me.onComplete = me.onOffline = me.onAbort = me.onTimeout = me.onBackground = null;

    $.each(arguments,
        function(index, value) {
            if (KS.isDefined(value.uniqueID)) me.uniqueID = value.uniqueID;
            if (KS.isDefined(value.viewContext)) me.viewContext = value.viewContext;
            if (KS.isDefined(value.url)) me.url = value.url;
            if (KS.isDefined(value.method)) me.method = value.method;
            if (KS.isDefined(value.waitMessage)) me.waitMessage = value.waitMessage;
            if (KS.isDefined(value.success)) me.onSuccess = value.success;
            if (KS.isDefined(value.error)) me.onError = value.error;
            if (KS.isDefined(value.complete)) me.onComplete = value.complete;
            if (KS.isDefined(value.abort)) me.onAbort = value.abort;
            if (KS.isDefined(value.offline)) me.onOffline = value.offline;
            if (KS.isDefined(value.delay)) me.onTimeout = value.delay;
            if (KS.isDefined(value.background)) me.onBackground = value.background;
            if (KS.isDefined(value.data)) me.data = KS.isHttps() ? value.data : KS.Base64.encode(value.data);
            if (KS.isDefined(value.disableFog)) me.disableFog = value.disableFog;
            if (KS.isDefined(value.progressOnly)) me.progressOnly = value.progressOnly;
            if (KS.isDefined(value.async)) me.async = value.async;
            if (KS.isDefined(value.timeout)) me.timeout = value.timeout;
            if (KS.isDefined(value.cancellable)) me.cancellable = value.cancellable;
            if (KS.isDefined(value.detectOffline)) me.detectOffline = value.detectOffline;
        });

    if (me.async == null) me.async = true;
    if (!me.async) me.disableFog = true;

    // handlers can't be empty for simplicity
    if (me.onError == null) me.onError = function(message) { KS.error(null, null, null, message); };

    if (me.onSuccess == null) me.onSuccess = KS.stub;
    if (me.onComplete == null) me.onComplete = KS.stub;
    if (me.onAbort == null) me.onAbort = KS.stub;
    if (me.onTimeout == null) {
        me.onTimeout = function(clientSide, message, details) {
            KS.warning(message, KS.L10n.ajax_CommunicationProblem, null, details);
        };
    }
    if (me.onBackground == null) {
        me.onBackground = function() {
            KS.alert(KS.L10n.ajax_RunningMethod + me.method + KS.L10n.ajax_ContinueBackground);
        };
    }

    if (me.onOffline == null)
        me.onOffline = function() {
            KS.Ajax.setOnline(false);
        };

    // A function to be called if the request fails. The function receives three arguments: 
    // The jqXHR (in jQuery 1.4.x, XMLHttpRequest) object, a string describing the type of 
    // error that occurred and an optional exception object, if one occurred. Possible values
    // for the second argument (besides null) are "timeout", "error", "abort", and "parsererror".
    me.error = function(jqXHR, textStatus, errorThrown) {
        var status = jqXHR.status;

        if (KS.isValid(me.viewContext) && !me.disableFog)
            me.viewContext.stopWaiting.apply(me.viewContext);

        if (textStatus == 'abort') {
            me.abort();
            return;
        }

        if (textStatus == 'timeout' || (status != 200 && status != 500)) {
            if (me.detectOffline) {
                // считаем это переходом в оффлайн
                KS.Stat.fireEvent(status);
                if (++me.repeatCounter >= 2) {
                    KS.Stat.fireEvent('OFF');
                    me._callOffline(errorThrown);
                } else {
                    KS.Stat.fireEvent('REP');
                    $.ajax(me);
                }
            } else
                me._callDelay(true);
            return;
        }

        KS.Stat.fireEvent(status);

        if (me.viewContext != null)
            me.onError.apply(me.viewContext, [errorThrown]);
        else
            me.onError(errorThrown);
    };

    // A function to be called if the request succeeds. The function gets passed three 
    // arguments: The data returned from the server, formatted according to the dataType
    // parameter; a string describing the status; and the jqXHR (in jQuery 1.4.x, XMLHttpRequest) object.
    me.success = function(data, textStatus, jqXHR) {
        var action = function() {
            if (KS.isValid(me.viewContext) && !me.disableFog)
                me.viewContext.stopWaiting.apply(me.viewContext);

            var contentType = jqXHR.getResponseHeader("Content-Type");
            if (jqXHR.status === 200 && contentType.toLowerCase().indexOf("text/html") >= 0) {
                // assume that our login has expired - reload our current page
                window.location.reload();
            }
            KS.Ajax.setOnline(true);

            var execCallback = function (callback, scope, result) {
                if (KS.isFunction(callback)) {
                    callback.apply(scope, [result]);
                } else if (KS.isObject(callback) && KS.isFunction(callback.fn)) {
                    callback.fn.apply(callback.scope || scope, [result]);
                }
            }

            if (KS.isValid(data)) {
                if (KS.isDefined(data.value))
                    data.value = KS.isHttps() ? data.value : JSON.parse(KS.Base64.decode(data.value));
                if (KS.isDefined(data.value) && KS.isDefined(data.value.actions) && data.value.actions.length > 0) {
                    KS.ajaxResultQueue = KS.ajaxResultQueue.concat(data.value.actions);
                    KS.logActions();
                }

                // возможно сервер затребовал повтор
                var repeatReason = KS.queueCheckRepeat(me);
                if (repeatReason === true) {
                    me.repeatCounter++;
                    KS.Stat.fireEvent('REP');
                    $.ajax(me);
                    return;
                } else if (repeatReason === 23) {
                    return;
                }

                KS.Stat.fireEvent('TOT');

                if (KS.queueExecuteActions(me))
                    return;

                if (KS.isDefined(data.error)) {
                    KS.Stat.fireEvent('EXC');
                    me._callError(data.error);
                } else if (KS.isDefined(data.timeout)) {
                    KS.Stat.fireEvent('EXC');
                    me._callDelay(true, data.timeout);
                } else if (!me.backgroundCalled) {
                    if (KS.isDefined(data.value)) {
                        if (KS.isValid(me.viewContext) && me.viewContext._closing && me.method !== 'CloseView') {
                            KS.log('Success callback skipped: ' + me.method, 'ajax');
                        } else {
                            var scope = KS.isValid(me.viewContext) ? me.viewContext : me;
                            execCallback(me.onSuccess, scope, data.value.result);
                        }
                    }
                }
            } else {
                KS.Stat.fireEvent('EMP');
                throw KS.L10n.ajax_ResponseServerEmpty;
            }
        };

        if (KS.catchErrors) {
            try {
                action();
            } catch (e) {
                me._callError(e);
                KS.error(null, null, null, e);
            }
        } else
            action();
    };

    // A function to be called when the request finishes (after success and error callbacks are executed).
    // The function gets passed two arguments: The jqXHR (in jQuery 1.4.x, XMLHTTPRequest) object and a 
    // string categorizing the status of the request ("success", "notmodified", "error", "timeout",
    // "abort", or "parsererror").
    me.complete = function(jqXHR, textStatus) {
        var c = me.viewContext;
        if (KS.isValid(c)) {
            if (c.hideProgressBar) c.hideProgressBar();
            me.onComplete.apply(c, [textStatus]);
            c.removeFromAjaxQueue.apply(c, [me.uniqueID]);
            c.continueFromAjaxQueue.apply(c);
        } else
            me.onComplete(textStatus);
    };

    me.abort = function(jqXHR) {
        //debugger;
        if (KS.isValid(me.viewContext))
            me.onAbort.apply(me.viewContext, [jqXHR]);
        else
            me.onAbort(jqXHR);
    };

    me.beforeSend = function(xhr) {
        // если запрос не отслеживает оффлайн, то даже не пытаемся 
        if (!KS.Ajax.isOnline && !me.detectOffline)
            return false;

        if (KS.isValid(me.viewContext)) {
            xhr.setRequestHeader("X-Ajax-Method", me.method);
            xhr.setRequestHeader("X-Ajax-ViewID", me.viewContext.viewID);
            xhr.setRequestHeader("X-Ajax-DesktopID", KS.desktop);
        }
        xhr.setRequestHeader("X-Ajax-Repeat", me.repeatCounter);

        if (KS.isValid(me.viewContext)) {
            if (!me.disableFog && !me.progressOnly) {
                if (me.cancellable) {
                    me.viewContext.pleaseWait.apply(me.viewContext,
                        [
                            me.waitMessage,
                            function() {
                                xhr.abort();
                                //me.onAbort.apply(me);
                            }
                        ]);
                } else {
                    me.viewContext.pleaseWait.apply(me.viewContext, [me.waitMessage]);
                }
            }

            if ((!me.disableFog || me.progressOnly) && me.viewContext.showProgressBar) {
                me.viewContext.showProgressBar();
            }
        }

        return true;
    };

    me._callError = function(message) {
        if (!message.Data)
            message.Data = {};
        if (KS.displayExceptionDetails && !message.isonlyerror)
            message.Data["DataSent"] = me.data;
        message = KS.parseException(message);
        if (me.viewContext != null)
            me.onError.apply(me.viewContext, [message]);
        else
            me.onError(message);
    };

    me._callOffline = function(errorThrown) {
        KS.Ajax.setOnline(false);
        if (me.viewContext != null) {
            if (!me.disableFog)
                me.viewContext.stopWaiting.apply(me.viewContext);
            me.onOffline.apply(me.viewContext, [errorThrown]);
        } else
            me.onOffline(errorThrown);
        return;
    };

    me._callDelay = function(clientSide, details) {
        var msg = KS.L10n.ajax_ServerTimedOut;
        if (me.viewContext != null)
            me.onTimeout.apply(me.viewContext, [clientSide, msg, details]);
        else
            me.onTimeout(clientSide, msg, details);
        return;
    };

    // если запрос не отслеживает оффлайн, то сразу вызываем обработчик
    if (!KS.Ajax.isOnline && !me.detectOffline) {
        me._callOffline(KS.L10n.ajax_ServerLostConnection);
        me.complete(null, 'timeout');
        return;
    }
};