﻿AssignColumnsView = KS.extend(BaseDictionaryView, {});

(function (viewClass) {
    KS.apply(viewClass, {
        openColumnsDictionary: function () {
            var view = this.parentView,
                checkedCodes = this.colLinks;
            view.colWin = KS.showModal(view.createTemplateControl(view.tpl.controls['colGrid']),
                {
                    title: 'Выбор колонок',
                    autoHeight: false,
                    height: 400,
                    buttonalign: 'right',
                    buttons: new Array({
                        text: 'Выбрать',
                        parentView: view,
                        textField: this,
                        handler: view.setSelectedColumns
                    })
                },
                true);
            view.colGrid.getStore().each(function (rec) {
                var linkCol = rec.get('LINK_COL'),
                    check = jQuery.inArray(linkCol, checkedCodes) >= 0;
                view.colGrid.checkRecord(rec, check, true);
            });
        },

        setSelectedColumns: function () {
            var view = this.parentView,
                rows = view.colGrid.getCheckedRows(false),
                colLinks = [],
                text = '';
            Ext.each(rows, function(row) { 
                colLinks.push(view.colGrid.getCloseCode(row));
                text += view.colGrid.getAnyCase(row, 'name') + '; ';
            });
            this.textField.colLinks = colLinks;
            this.textField.setValue(text);
            view.colWin.close(true);
        },

        selected: function () {
            var view = this.parentView || this,
                assignedColumns = {};
            view.columnsPanel.items.each(function (editor) {
                var tf = editor.textField,
                    linksStr = '';
                Ext.each(tf.colLinks, function (linkCol) { linksStr += (linkCol + ','); });
                assignedColumns[tf.dataColumn.dataIndex] = linksStr;
            });
            view.serverCall({
                method: 'Selected',
                params: [assignedColumns]
            });
        }
    });
}(AssignColumnsView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();