﻿(function() {
    Ext.define('KS.Ext.SpreadsheetFrame', {
        extend: 'Ext.panel.Panel',

        alias: 'spreadsheet.frame',

        loadMask: 'Загрузка...',

        spreadsheet: null,

        iframeHtml: null,

        parentView: null,

        listeners: {
            documentchanged: 'onDocumentChanged',
            selectionchanged: 'onSelectionChanged',
            cellendedit: 'onCellEndEdit',
            customcommandexecuted: 'onCustomCommandExecuted'
        },

        constructor: function(cfg, ctrl) {
            var spreadsheetFrame = this;

            spreadsheetFrame.ksObjs = {};
            KS.apply(spreadsheetFrame,
                KS.apply(cfg || {}, ctrl ? ctrl.json : null),
                {
                    isTpl: true,
                    plugins: []
                });

            if (spreadsheetFrame.layout === 'box') {
                spreadsheetFrame.layout = {
                    type: 'box',
                    pack: 'center',
                    align: 'center'
                };
            }

            if (ctrl && ctrl.ui) {
                spreadsheetFrame.ui = ctrl.ui;
            }

            KS.Ext.SpreadsheetFrame.superclass.constructor.call(spreadsheetFrame);
        },

        controller: {
            onDocumentChanged: function (s, e) {
                var me = this.view;

                if (me.parentView && me.parentView.onSpreadsheetDocumentChanged)
                    me.parentView.onSpreadsheetDocumentChanged(s, e);
            },

            onSelectionChanged: function (s, e) {
                var me = this.view;

                if (me.parentView && me.parentView.onSpreadsheetSelectionChanged)
                    me.parentView.onSpreadsheetSelectionChanged(s, e);
            },

            onCellEndEdit: function (s, e) {
                var me = this.view;

                if (me.parentView && me.parentView.onSpreadsheetCellEndEdit)
                    me.parentView.onSpreadsheetCellEndEdit(s, e);
            },

            onCustomCommandExecuted: function (s, e) {
                var me = this.view;
                me.executeCustomCommand(s, e);
            }
        },

        initComponent: function () {
            this.callParent();
        },

        beforeDestroy: function () {
            this.closeSession();
        },

        initSpreadsheet: function (spreadsheet, parentView) {
            this.spreadsheet = spreadsheet;
            this.parentView = parentView;
            this.iframeHtml = document.getElementById(`spreadsheet_frame_${parentView.viewID}`);
            if (this.body)
                this.body.unmask();

            if (parentView.getFormulaBar) {
                this.addFormulaBar(spreadsheet, parentView.getFormulaBar.bind(parentView));
            }
        },

        addFormulaBar: function (spreadsheet, getFormulaBar) {
            spreadsheet.GetActiveCellPosition = function () {
                var paneManager = this.getPaneManager(),
                    selectionInternal = this.getSelectionInternal(),
                    internalSelectionWithModelIndices = selectionInternal.getConvertedToModelIndices(paneManager);
                return {
                    column: internalSelectionWithModelIndices.activeCellColIndex,
                    row: internalSelectionWithModelIndices.activeCellRowIndex
                };
            }.bind(spreadsheet);

            spreadsheet.GetActiveCellFormula = function () {
                var position = this.GetActiveCellPosition();
                return this.getPaneManager().getCellEditingText(position.column, position.row);
            }.bind(spreadsheet);

            var formulaBarHtml = getFormulaBar().getEl().dom;
            formulaBarHtml.addEventListener("keyup", function(event) {
                if (event.key === "Enter")
                    spreadsheet.focus();
            });
            formulaBarHtml.addEventListener("focusin", function() {
                spreadsheet.formulaBarCellPosition = spreadsheet.GetActiveCellPosition();
            });
            formulaBarHtml.addEventListener("focusout", function() {
                var position = spreadsheet.formulaBarCellPosition;
                if (position) {
                    spreadsheet.SetCellValue(position.column, position.row, getFormulaBar().getValue());
                    spreadsheet.formulaBarCellPosition = undefined;
                }
            });
        },

        setSrc: function (src) {
            var me = this;
            if (me.body)
                me.body.mask(me.loadMask);
            me.iframeHtml.src = src;
        },

        reloadFrame: function () {
            if (this.iframeHtml)
                this.iframeHtml.contentWindow.location.reload(true);
        },

        getSpreadsheetState: function () {
            var me = this;
            return me.spreadsheet.getSpreadsheetState();
        },

        executeCustomCommand: function (s, e) {
            var me = this;
            var command = e.commandName;

            switch (command) {
                case 'btnDownload':
                    me.downloadAs(null);
                    break
                case 'btnDownloadHtml':
                    me.downloadAs('html');
                    break
                case 'btnDownloadPdf':
                    me.downloadAs('pdf');
                    break
                case 'btnPrint':
                    me.print();
                    break
                case 'btnSetStringFormat':
                    me.setStringFormatForSelection();
                    break;
            }
        },

        saveDocument: function (successCallback, callbackContext) {
            var me = this;
            var spreadsheetState = me.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'MKS/SaveDocument',
                data: { spreadsheetState: spreadsheetState },
                success: function () {
                    if (typeof successCallback === 'function')
                        successCallback.call(callbackContext || me, arguments);
                }
            });
        },

        saveDocumentCopy: function (tempFileKey, successCallback, callbackContext) {
            var me = this;
            var spreadsheetState = me.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'MKS/SaveDocumentCopy',
                data: {
                    spreadsheetState: spreadsheetState,
                    tempFileKey: tempFileKey
                },
                success: function () {
                    if (typeof successCallback === 'function')
                        successCallback.call(callbackContext || me);
                }
            });
        },

        downloadFile: function () {
            var me = this;
            var spreadsheetState = me.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'MKS/GetDownloadUrl',
                data: { spreadsheetState: spreadsheetState },
                success: function (downloadUrl) {
                    window.open(downloadUrl);
                }
            });
        },

        downloadAs: function (format) {
            var me = this;
            me._submitForm('/MKS/DownloadAs', format);
        },

        print: function () {
            var me = this;
            var spreadsheetState = me.getSpreadsheetState();
            window.open('PrintSpreadsheet?stateId=' + spreadsheetState.SpreadsheetWorkSessionId);
        },

        closeSession: function () {
            var me = this;
            if (!me.spreadsheet) return; // todo: в модальных окнах spreadsheet при beforeDestroy будет null
            var spreadsheetState = me.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'MKS/CloseSession',
                data: { spreadsheetState: spreadsheetState }
            });
        },

        setBackgroundColorForSelection: function (colorHex, selection, successCallback, callbackContext) {
            var me = this;
            var spreadsheetState = me.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'MKS/SetBackgroundColorForSelection',
                data: {
                    spreadsheetState: spreadsheetState,
                    colorHex: colorHex,
                    cellSelection: selection || me.spreadsheet.GetSelection()
                },
                success: function () {
                    if (typeof successCallback === 'function')
                        successCallback.call(callbackContext || me);
                }
            });
        },

        setStringFormatForSelection: function () {
            var me = this;
            var spreadsheetState = me.getSpreadsheetState();
            $.ajax({
                type: 'POST',
                url: 'MKS/SetStringFormatForSelection',
                data: {
                    spreadsheetState: spreadsheetState,
                    cellSelection: me.spreadsheet.GetSelection()
                }
            });
        },

        _submitForm: function (action, format) {
            var me = this;
            var spreadsheetState = me.getSpreadsheetState();
            var formExport = me.iframeHtml.contentWindow.document.getElementById('formExport');
            if (formExport) {
                var inputs = formExport.getElementsByTagName('input');
                for (const input of inputs) {
                    switch (input.name) {
                        case 'SpreadsheetWorkSessionId':
                            input.value = spreadsheetState.SpreadsheetWorkSessionId;
                            break;
                        case 'Format':
                            input.value = format;
                            break;
                    }
                }

                formExport.setAttribute('action', action);
                formExport.submit();
            }
        },

        _hiddenDownload: function (url) {
            var iframe = document.createElement('iframe');
            iframe.style.display = 'none';
            iframe.src = url;
            document.body.appendChild(iframe);

            // Clean up after download starts
            setTimeout(function() {
                document.body.removeChild(iframe);
            }, 1000);
        }
    });

    function createSpreadsheetFrame(ctrl, cfg) {
        KS.apply(cfg,
            {
                ctrl: ctrl
            });
        var spreadsheetFrame = new KS.Svod.SpreadsheetFrame(ctrl, cfg);
        KS.Ext.setTemplateListeners(spreadsheetFrame, ctrl.listeners, ctrl.parentView);
        return spreadsheetFrame;
    }

    KS.Ext.registerControlRenderer('spreadsheetFrame', createSpreadsheetFrame);
})();