﻿@echo off
chcp 65001 > nul
setlocal enabledelayedexpansion

echo Создание файла конфига appsettings.Production.json
echo.

if exist "appsettings.Production.json" (
    echo Файл appsettings.Production.json уже существует. Перезаписать? ^(y/n^)
    set /p "overwrite="
    if /i "!overwrite!" neq "y" (
        echo Операция отменена.
        pause
        exit /b 1
    )
)
echo Генерация секретного ключа
echo.

set "SECRET_KEY="
for /f "delims=" %%i in ('powershell -Command "Add-Type -AssemblyName System.Security; $bytes = New-Object byte[] 32; [Security.Cryptography.RandomNumberGenerator]::Create().GetBytes($bytes); [Convert]::ToBase64String($bytes)"') do set "SECRET_KEY=%%i"

echo Сгенерированный ключ: !SECRET_KEY!
echo.

(
echo {
echo   "Serilog": {
echo     "MinimumLevel": {
echo       "Default": "Warning",
echo       "Override": {
echo         "Microsoft": "Warning",
echo         "Microsoft.Hosting.Lifetime": "Warning",
echo         "Microsoft.EntityFrameworkCore.Database.Command": "Warning"
echo       }
echo     },
echo     "WriteTo": [
echo       {
echo         "Name": "File",
echo         "Args": {
echo           "path": "./logs/log-.txt",
echo           "rollingInterval": "Day"
echo         }
echo       }
echo     ]
echo   },
echo.
echo   "SqlClient": {
echo     "DataSourceType": "",
echo     "Server": "",
echo     "DataBase": "",
echo     "UserName": "",
echo     "Password": ""
echo   },
echo.
echo   "Authentication": {
echo     "AuthenticationMethod": "1",
echo     "BuiltInJwtBearer": {
echo       "SecurityKey": "!SECRET_KEY!"
echo     }
echo   },
echo.
echo   "SystemSettings": {
echo     "AlternativeUploadService_comment": "Сервис оправдательных документов (переопределяет значение из БД)",
echo     "AlternativeUploadService": ""
echo   }
echo }
) > "appsettings.Production.json"

echo Настройки заданы. Файл appsettings.Production.json создан успешно!
echo.

pause