﻿WikiView = KS.extend(BaseDictionaryView, {
    rowDblClickHandler: function (gridView, record, element, rowIndex, e) {
        var column = e.position.column;
        var closeCode = KS.Grid.getAnyCase(record, gridView.grid.closeCode);
        if (column.dataIndex && column.dataIndex.toUpperCase() === "FILE_NAME"){
            this.showFileChooserPanel(column.dataIndex, record, closeCode);
            return false;
        } else if (column.renderer === dictRenderer) {
            this.openDictionary(column.dataIndex, record, closeCode);
            return false;
        } else if (column.renderer === wikiStringRenderer) {
            this.showPopupStringEditor(column, record, closeCode);
            return false;
        }
        return true;
    },
    
    openDictionary: function(dataIndex, record, closeCode){
        if (!this.checkAuthor(record)) return;
        this.serverCall({
            method: "OpenDictionary",
            params: [dataIndex, closeCode]
        });
    },

    showFileChooserPanel: function(dataIndex, rec, closeCode) {
        var editAccess = this.checkAuthor(rec);
        var fileName = KS.Grid.getAnyCase(rec, dataIndex);

        this.selectCellFileBtn = KS.create({
                type: 'filefield',
                parentView: this,
                itemId: 'selectCellFileBtn'
            },
            {
                buttonConfig: {
                    tooltip : 'Загрузить файл',
                    iconCls: 'ks-icon-folder_open',
                    text: '',
                    disabled: !editAccess
                },
                multiple: false,
                buttonOnly: true,
                emptyText: "Выберите файл...",
                width: 26
            });

        this.fileChooserPanel = new Ext.panel.Panel({
            bodyPadding: '5 0 5 0',
            layout: {
                type: 'hbox',
                align: 'begin'
            },
            items: [
               {
                    xtype: 'textfield',
                    itemId: 'cellFileName',
                    value: fileName,
                    margin: '0 0 0 3',
                    readOnly: true
                },
                {
                    xtype: 'button',
                    tooltip : 'Скачать файл',
                    iconCls: 'ks-icon-save',
                    margin: '0 3 0 3',
                    scope: this,
                    handler: this.openAttachedFile
                },
                this.selectCellFileBtn,
                {
                    xtype: 'button',
                    tooltip : 'Удалить файл',
                    iconCls: 'ks-icon-delete',
                    margin: '0 3 0 3',
                    disabled: !editAccess,
                    scope: this,
                    handler: this.deleteAttachedFile
                }
            ]
        });

        var view = this;

        view.cellOptionsForFile = {
            dataIndex: dataIndex,
            record: rec,
            closeCode: closeCode
        }

        this.fileChooserWin = KS.showModal(this.fileChooserPanel, {
            title: 'Выбор файла',
            autoHeight: false,
            resizable: false,
            maximizable: false,
            width: 270,
            minWidth: 270,
            height: 110,
            minHeight: 110,
            buttonAlign: 'center',
            buttons: new Array({
                text: 'ОК',
                cls: 'dim-button',
                handler: function() {
                    view.fileChooserWin.close();
                    view.cellOptionsForFile = null;
                }
            })
        }, true);
    },

    saveFiles: function(fileKeys){
        var view = this.parentView || this;
        if (!Ext.isEmpty(fileKeys) && !Ext.isEmpty(view.cellOptionsForFile)) {
            var fileKey = fileKeys[0];
            view.serverCall({
                method: "AttachFile",
                params: [fileKey, view.cellOptionsForFile.closeCode],
                success: function(fileName){
                    if (!Ext.isEmpty(fileName)) {
                        var fileNameField = view.fileChooserPanel.getComponent('cellFileName');
                        if (fileNameField) 
                            fileNameField.setValue(fileName);                        
                        view.cellOptionsForFile.record.set(view.cellOptionsForFile.dataIndex, fileName);
                        view.touch();
                    }
                }
            });            
        }
    },

    openAttachedFile: function(){
        var view = this.parentView || this;
        var closeCode = view.cellOptionsForFile.closeCode;
        if (closeCode)
            view.serverCall({
                method: "OpenAttachedFile",
                params: [closeCode]
            });
    },

    deleteAttachedFile: function(){
        var view = this;
        view.serverCall({
            method: "DeleteAttachedFile",
            params: [this.cellOptionsForFile.closeCode],
            success: function(result){
                if (result) {
                    var fileNameField = view.fileChooserPanel.getComponent('cellFileName');
                    if (fileNameField)
                        fileNameField.setValue("");
                    view.cellOptionsForFile.record.set(view.cellOptionsForFile.dataIndex, "");
                    view.touch();
                }
            }
        });
    },

    newHandler: function() {
        var view = this.parentView || this;
        view.serverCall({
            method: "AddNewRow",
            disableFog: true,
            success: function(){
                view.mainGrid.reload();
                view.touch();
            }
        });
    },

    copyHandler: function() {
        var view = this.parentView || this;
        var checkedCodes = view.mainGrid.getCheckedCodes();
        if (Ext.isEmpty(checkedCodes)) return;
        view.serverCall({
            method: "CopyRow",
            params: [checkedCodes[0]],
            disableFog: true,
            success: function(result){
                if (result){
                    view.mainGrid.reload();
                    view.touch();
                }
            }
        });
    },

    resetView: function () {
        this.mainGrid.reload();
    },

    showPopupStringEditor: function (cfg, rec, closeCode) {
        if (!this.checkAuthor(rec)) return;
        var value = KS.Grid.getAnyCase(rec, cfg.dataIndex);
        var view = this;
        view.pseWin = KS.showModal({
            xtype: 'textarea',
            itemId: 'pseArea',
            value: value
        },{
            layout: 'fit',
            plain: true,
            frame: true,
            autoScroll: true,
            modal: true,
            maximizable: true,
            minWidth: 400,
            minHeight: 300,
            width: Math.max(400, KS.rootViewport.getWidth() / 2),
            height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
            title: cfg.text,
            buttonAlign: 'right',
            buttons: new Array({
                text: 'Применить',
                cls: 'marked-button',
                handler: function () {
                    var newValue = view.pseWin.getComponent("pseArea").getValue();
                    rec.set(cfg.dataIndex, newValue);
                    view.modifyGridCell(closeCode, cfg.dataIndex, newValue)
                    view.pseWin.close(true);
                }
            })
        }, true);

        view.pseWin.getComponent("pseArea").selectText(value.length);
    },

    beforeEditGridCell: function(e, context){
        return this.checkAuthor(context.record);
    },
    
    editGridCell: function(e, context){
        if (context.field.toLowerCase() !== "actual" &&   // в толстом колонку Актуально могут менять все (25.10.2021)
            (context.value === context.originalValue ||
            !this.checkAuthor(context.record))) {
            return false;
        }
        var closeCode = KS.Grid.getAnyCase(context.record, context.grid.closeCode);
        var dataIndex = context.field;
        var newValue = context.value;
        this.modifyGridCell(closeCode, dataIndex, newValue);
        return true;
    },
    
    modifyGridCell: function(closeCode, dataIndex, newValue){
        var view = this;
        this.serverCall({
            method: "ModifyGridCell",
            params: [closeCode, dataIndex, newValue],
            disableFog: true,
            success: function(result){
                if (result)
                    view.touch()
            }
        });
    },
    
    checkAuthor: function(record){
        var rowAuthor = KS.Grid.getAnyCase(record, "AUTHOR").toLowerCase();
        return this.data.currentUser.toLowerCase() === rowAuthor;
    },
    
    checkActualFiles: function(checkBox, newValue){
        var view = this;
        this.serverCall({
            method: "CheckActualFiles",
            params: [newValue],
            disableFog: true,
            success: function(){
                view.mainGrid.reload()
            }
        });        
    }
});

function wikiStringRenderer(value, metadata) {
    if (Ext.isString(value))
        setTooltip(metadata, value);
    return value;
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();