﻿UniDictItemSelectView = KS.extend(BaseTreeView, {
    buildContainerToolbarItemControl: function(tbarItem) {
        switch (tbarItem.code) {
        case 'QuickFilterContainer':
            this.tff = KS.create('textField',
                {
                    width: 110,
                    parentView: this,
                    enableKeyEvents: true,
                    listeners: {
                        'keyup': function(qff, e) {
                            var code = e.getKey();
                            if (code == e.ENTER) qff.parentView.applyQuickFilter();
                            return false;
                        }
                    }
                });
            return [
                {
                    iconCls: 'ks-icon-search',
                    tooltip: 'Быстрый фильтр',
                    scope: this,
                    handler: this.applyQuickFilter
                }, this.tff
            ];
        }
        return UniDictItemSelectView.superclass.buildContainerToolbarItemControl.apply(this, arguments);
    },

    applyQuickFilter: function() {
        this.serverCall({
            method: 'ApplyQuickFilter',
            params: [this.tff.getValue()],
            success: this.resetGrid
        });
    },

    getTbarClickHandler: function(tbarItem) {
        switch (tbarItem.code) {
        case 'DATABASE_REFRESH':
            return this.databaseRefresh;
        }
        return UniDictItemSelectView.superclass.getTbarClickHandler.call(this, tbarItem);
    },

    databaseRefresh: function() {
        this.parentView.serverCall({
            method: 'DatabaseRefresh',
            waitMessage: 'Очистка кэша БД ...',
            success: this.parentView.reload
        });
    },

    newHandler: function() {
        var view = this.parentView || this;
        view.getPropertyGrid(true, null);
    },
    
    editHandler: function(){
        var view = this.parentView || this;
        var checkedCodes = view.mainGrid.getCheckedCodes();
        if (!Ext.isEmpty(checkedCodes))
            view.getPropertyGrid(false, checkedCodes[0]);
    },

    getPropertyGrid: function(isNew, closeCode){
        var view = this;
        view.serverCall({
            method: 'GetPropertyGrid',
            params: [isNew, closeCode],
            success: view.showEditGridRowWin
        });
    },

    showEditGridRowWin: function(pg) {
        this.rowGrid = this.createTemplateControl(pg);
        if (this.rowGrid) {
            this.rowWin = KS.showModal({
                    height: this.rowGrid.height,
                    items: this.rowGrid
                },
                {
                    title: 'Добавление строки',
                    autoHeight: false,
                    buttonalign: 'right',
                    buttons: [
                        {
                            text: 'OK',
                            scope: this,
                            handler: this.saveRow
                        }
                    ]
                },
                true);
            this.rowWin.on('beforeclose', this.reload, this);
            this.rowWin.show();
        }
    },

    saveRow: function() {
        var values = this.rowGrid.getValues();
        values[this.data.closeCode] = this.rowGrid[this.data.closeCode];
        this.rowWin.body.mask('Отправка данных');
        this.serverCall({
            method: 'SaveRow',
            params: [values],
            success: this.saveRowCallback
        });
    },

    saveRowCallback: function(msg) {
        this.rowWin.body.unmask();
        if (KS.isEmpty(msg)) {
            this.rowWin.close();
            this.resetGrid();
        } else {
            KS.warning(msg, 'Сохранение не выполнено');
        }
    },

    getAdditionalParams: function() {
        var params = this.collectContainerItemsValues();
        if (Ext.isFunction(this.mainGrid.getSelectionModel().getPosition)){ // Есть только в selection.cellmodel
            var eventArg = [null, null, null, null, null, null, {
                "position" : this.mainGrid.getSelectionModel().getPosition()
            }];
            params["STATE_STRING"] = JSON.stringify(this.mainGrid.getControlState({}, 'celldblclick', eventArg));
        }
        return params;
    }
});

function uniDictCellRenderer(value, metadata, record) {
    var linkSetting = KS.Grid.getAnyCase(record, 'link_setting');
    if (!Ext.isEmpty(linkSetting) && linkSetting.toString() !== '79') // 79 - просто белый, перекрывает выбор ячейки
        metadata.css = ' link-setting-' + linkSetting;
    return value;
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();