﻿UniDictColumnSelectView = KS.extend(BaseTreeView, {});

(function (viewClass) {
    KS.apply(viewClass, {

        onTemplateRendered: function () {
        },
        
        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {
                case "FIND":
                    return this.changeSearchPanelVisible;
            }
            return sc.getTbarClickHandler.call(this, tbarItem);
        },
        
        resetView: function(){
            if (this.uniDictTree){
                this.uniDictTree.getRootNode().removeAll(true);
                this.uniDictTree.fullReload();
            }
            if (this.systemDictTree){
                this.systemDictTree.getRootNode().removeAll(true);
                this.systemDictTree.fullReload();
            }
            if (this.mainGrid)
                this.mainGrid.getStore().removeAll();
        },

        changeSearchPanelVisible: function() {
            var view = this.parentView || this;
            var treeId = "uniDictTree";
            if (view.data.identifier.AllowSelectSystemDiction){
                var tab = view.dictSelectPanel.getActiveTab();
                if (tab && tab.ctrlId === "systemDictPanel") {
                    treeId = "systemDictTree"
                }
            }
            var searchPanel = view["searchPanel_" + treeId];
            if (searchPanel)
                searchPanel.setHidden(!searchPanel.getHidden());
        }
    });
}(UniDictColumnSelectView.prototype));
