﻿SvodOptionsView = KS.extend(BaseSvodView, {
    constructor: function(viewId) {
        SvodOptionsView.superclass.constructor.call(this, viewId);
    }
});

// ============= NAVIGATOR TREE =======================
(function(viewClass) {
    KS.apply(viewClass, {
        navigatorTreeReset: function(selNodeId) {
            var view = this;
            var selId = view.navigatorTree.getSelNodeId();
            var nodeId = selNodeId ? selNodeId : 
                                     selId ? selId : "root";
            view.serverCall({
                method: 'SelectActiveNode',
                disableFog: true,
                params: [nodeId],
                success: function() {
                    view.navigatorTreeNodeIdToScroll = nodeId;
                    view.navigatorTree.getRootNode().removeAll(true);
                    view.navigatorTree.fullReload();
                }
            });
        },

        navigatorTreeSelect: function( treeView, record) {
            var code = KS.Grid.getAnyCase(record, "id");
            if (code === 'root') return;
            var name = KS.Grid.getAnyCase(record, "text");
            var cleanBtn = this.getToolbarItem(this.mainPanel, null, "CLEAN_OPTION");
            if (cleanBtn) cleanBtn.setVisible(true);
            var testBtn = this.getToolbarItem(this.mainPanel, null, "TEST")
            if (testBtn) testBtn.setVisible(false);
            this.serverCall({
                method: 'GetOptions',
                disableFog: true,
                params: [code, name],
                success: this.loadOptionsPanel
            });
        },
        
        navTreeExpandAll: function() {
            var view = this.parentView || this;
            view.navigatorTree.expandAll();
        },

        navTreeCollapseAll: function() {
            var view = this.parentView || this;
            view.navigatorTree.collapseAll();
        },

        navTreeSearch: function() {
            var view = this.parentView || this;
            view.navigatorFilterGrid.setVisible(this.pressed);
        },

        searchNavigatorNodes: function() {
            var view = this.parentView || this,
                seacrh = view.navFilterString.getComponent('textField').getValue();
            if (KS.isEmpty(seacrh)) return;
            view.serverCall({
                method: 'SearchNavigatorNodes',
                disableFog: true,
                params: [seacrh],
                success: view.displayFoundNavNodes
            });
        },

        displayFoundNavNodes: function(json) {
            var data = KS.safeDecode(json),
                store = this.navigatorFilterGrid.getStore();
            store.loadData(data.rows);
        },

        navFilterSelect: function(gridView, record) {
            var nodeId = "'" + record.get('id') + "'";
            this.navigatorTreeReset(nodeId);
        },

       navTreeLoad: function() {
            //Если нужно проскролить до выбранного узла после обновления дерева
            if (this.navigatorTreeNodeIdToScroll) {
                this.navigatorTree.setSelected(this.navigatorTreeNodeIdToScroll);
                this.scrollToActiveNode(this.navigatorTree);
                this.navigatorTreeNodeIdToScroll = null;
            } else {
                this.navigatorTree.selectFirstNode();
            }
        }
    });
}(SvodOptionsView.prototype));

// ============= GRID's =======================
(function(viewClass) {
    KS.apply(viewClass, {
// Копипаст из BaseDictionaryView
        getTbarClickHandler: function(tbarItem) {
            var sc = SvodOptionsView.superclass;
            switch (tbarItem.code) {
                case 'NEW':
                    return this.createNewRow;

                case 'EDIT':
                    return this.editRow;

                case 'DELETE':
                    return this.deleteRow;

                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        createNewRow: function() {
            var view = this.parentView || this,
                gridId = this.gridPropertyName,
                grid = view[gridId];
            if (grid) {
                switch(gridId) {
                    case "modesGrid":
                        view.editModesGridRow(gridId, true, null, null);
                        break;

                    case "eventGrid":
                        view.editEventGridRow(gridId, true, null, null);
                        break;

                    case "linksGrid":
                        view.createNewLinksGridRow(grid);
                        break;
                }
            }
        },        
        
        editRow: function() {
            var view = this.parentView || this,
                gridId = this.gridPropertyName,
                grid = view[gridId];
            if (grid) {
                var checkedRows = grid.getCheckedRows();
                if (Ext.isEmpty(checkedRows) || checkedRows.length === 0) return;
                var checkedRow = checkedRows[0];
                var closeCode = grid.getCloseCode(checkedRow);
                switch(gridId) {
                    case "modesGrid":
                        view.editModesGridRow(gridId, false, closeCode, checkedRow);
                        break;
                    case "eventGrid":
                        view.editEventGridRow(gridId, false, closeCode, checkedRow);
                        break;
                }
            }
        },

        editModesGridRow: function(gridId, isNew, closeCode, checkedRow) {
            var source = {
                "LINK_LOG_MODE": Ext.isEmpty(checkedRow) ? null : KS.Grid.getAnyCase(checkedRow, "LINK_LOG_MODE"),
                "LINK_SELF": Ext.isEmpty(checkedRow) ? null : KS.Grid.getAnyCase(checkedRow, "LINK_SELF"),
                "CODE": Ext.isEmpty(checkedRow) ? "" : KS.Grid.getAnyCase(checkedRow, "CODE"),
                "NAME": Ext.isEmpty(checkedRow) ? "" : KS.Grid.getAnyCase(checkedRow, "NAME")
            };
            var sourceConfig = {
                "LINK_LOG_MODE" : {
                    type: 'number',
                    displayName: 'LINK_LOG_MODE'
                },
                "LINK_SELF" : {
                    type: 'number',
                    displayName: 'LINK_SELF'
                },
                "CODE" : {
                    type: 'string',
                    displayName: 'Код'
                },
                "NAME" : {
                    type: 'string',
                    displayName: 'Наименование'
                }
            }

            this.rowByPropertGrid(source, sourceConfig, gridId, isNew, closeCode);
        },

        editEventGridRow: function(gridId, isNew, closeCode, checkedRow) {
            var source = {
                "LINK_LOG_EVENT": Ext.isEmpty(checkedRow) ? null : KS.Grid.getAnyCase(checkedRow, "LINK_LOG_EVENT"),
                "CODE": Ext.isEmpty(checkedRow) ? "" : KS.Grid.getAnyCase(checkedRow, "CODE"),
                "NAME": Ext.isEmpty(checkedRow) ? "" : KS.Grid.getAnyCase(checkedRow, "NAME")
            };
            var sourceConfig = {
                "LINK_LOG_EVENT" : {
                    type: 'number',
                    displayName: 'LINK_LOG_MODE'
                },
                "CODE" : {
                    type: 'string',
                    displayName: 'Код'
                },
                "NAME" : {
                    type: 'string',
                    displayName: 'Наименование'
                }
            }
            this.rowByPropertGrid(source, sourceConfig, gridId, isNew, closeCode);
        },

        rowByPropertGrid: function(source, sourceConfig, gridId, isNew, closeCode) {
            var view = this;
            view.editRowPropertyGrid = new Ext.grid.property.Grid({
                title: "<b>1. Общие</b>",
                source: source,
                sourceConfig: sourceConfig,
                nameColumnWidth: "50%",
                parentView: view,
                viewConfig: {
                    forceFit: true
                }
            });
            view.editRowWin = KS.showModal(view.editRowPropertyGrid, {
                title: 'Свойства',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: Math.max(400, KS.rootViewport.getWidth() / 3),
                height: Math.max(300, KS.rootViewport.getHeight() / 2),
                minHeight: 300,
                minWidth: 400,
                buttonAlign: 'left',
                buttons: ['->',
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function() {
                            view.editGridRow(view.editRowPropertyGrid.source, gridId, isNew, closeCode);
                        }
                    },
                    { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.editRowWin.close();
                        }
                    }]
            }, true);
        },

        editGridRow: function(source, gridId, isNew, closeCode) {
            var view = this;
            view.serverCall({
                method: 'EditRow',
                disableFog: true,
                params: [source, gridId, isNew, closeCode],
                success: function() {
                    view[gridId].reload();
                    view.touch();
                    view.editRowWin.close();
                }
            });
        },

        createNewLinksGridRow: function(grid) {
            var view = this.parentView || this;
            view.serverCall({
                method: "AddLinksGridRow",
                disableFog: true,
                success: function(dataRow) {
                    grid.addRecord(dataRow);
                    view.touch();
                }
            });
        },

        linkGridEdit: function (e, context) {
            if (context.value === null || context.value === context.originalValue) return false;
            var view = this;
            view.serverCall({
                method: 'ChangeLinkGridValue',
                disableFog: true,
                params: [KS.Grid.getAnyCase(context.record, "ENTITY_CLOSE_CODE"), context.field, context.value],
                success: function() {
                    view.touch();
                }
            });
            return true;
        },

        deleteRow: function() {
            var view = this.parentView || this,
                gridId = this.gridPropertyName,
                grid = view[gridId];
            if (grid) {
                var ccc = grid.getCheckedCodes(true);
                if (Ext.isEmpty(ccc)) return;
                KS.confirm('Удалить выделенные строки?', "Подтвердите удаление", function(btn) {
                        if (btn === 'yes')
                            view.deleteRowInternal(ccc, grid, gridId);
                    });
            }
        },

        deleteRowInternal: function (ccc, grid, gridId) {
            var view = this;
            view.serverCall({
                method: 'DeleteRows',
                params: [gridId, ccc],
                waitMessage: 'Удаление ...',
                success: function(deleted) {
                    if (deleted) {
                        grid.reload();
                        view.touch();
                    }
                }
            });
        }
    });
}(SvodOptionsView.prototype));

// ============= NEW OPTIONS =======================
(function(viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function () {
            var fileField = this.getToolbarItem(this.rootPanel, null, "NEW_FILE");
            if (fileField) fileField.setHidden(true); // Невидимая кнопка для загрузки файла

            if (!Ext.isEmpty(this.navigatorTree.config.ctrl.selectedNode)) 
                this.navigatorTreeNodeIdToScroll = this.navigatorTree.config.ctrl.selectedNode;
        },

        reloadCallback: function(data) {
            if (typeof (data) == 'object') this.data = data;
            this.discardChanges();
            this.optionsPanel.removeAll();
            this.navigatorTreeReset();
        },

        onSetSavedState: function(saved) {
            var applyBtn = this.getToolbarItem(this.rootPanel, 'bottom', 'APPLY');
            if (applyBtn)
                applyBtn.setDisabled(saved);
        },

        saveAndCloseSettings: function() {
            var view = this.parentView || this;
            if (view.hasChanges) 
                view.saveOptionsChanges(true);
            else
                view.close();
        },
        
        applySettings: function() {
            var view = this.parentView || this;
            view.saveOptionsChanges(false);
        },

        saveOptionsChanges: function(needClose) {
            var view = this;
            view.doSaveOptionsChanges(needClose);
        },

        doSaveOptionsChanges : function(needClose) {
            var view = this;
            view.serverCall({
                method: 'SaveOptionsChanges',
                waitMessage: "Сохранение...",
                success: function(result) {
                    if (!result.hasErrors) {
                        if (result.edsType)
                            KS.edsType = result.edsType;
                        if (result.cryptoPort)
                            KS.cryptoPort = result.cryptoPort;
                        
                        view.discardChanges();
                        if (needClose)
                            view.close();
                        else
                            view.reload();
                    }
                }
            });
        },

        cleanValueForUsers: function() {
            var view = this.parentView;
            var selProp = view.selectedPropertOption;
            if (!Ext.isEmpty(selProp.name) && !Ext.isEmpty(selProp.code) &&
                view.data.Model.userCodes && view.data.Model.userCodes.indexOf(selProp.code) !== -1) {
                KS.confirm("Очистить значение настройки '" + selProp.name + "' для всех пользователей?",
                    "Внимание", function(btn) {
                        if (btn === 'yes') {
                            view.serverCall({
                                method: 'CleanUserOption',
                                disableFog: true,
                                params: [selProp.code],
                                success: function(data) {
                                    if (data) {
                                        view.data = data;
                                        view.touch();
                                    }
                                }
                            });
                        }
                    });
            }
        },

        copyOptionPath: function() {
            var view = this.parentView;
            var path = view.getActiveNodePath(view.navigatorTree);

            if (!Ext.isEmpty(view.selectedPropertOption.name))
                path += "\\" + view.selectedPropertOption.name;

            view.writeToClipboard(path);
        },

        copyOptionName: function() {
            var view = this.parentView;
            view.copyPathToActiveNode(view.navigatorTree);
        },
        
        setOptionValueForUsers: function() {
            var view = this.parentView;
            var selProp = view.selectedPropertOption;
            if (!Ext.isEmpty(selProp.code) && !Ext.isEmpty(selProp.isUserSetting) && 
                (selProp.isUserSetting || view.data.Model.userCodes && view.data.Model.userCodes.indexOf(selProp.code) !== -1)) {
                view.serverCall({
                    method: 'GetAllUserGrid',
                    waitMessage: 'Загрузка списка пользователей...',
                    success: view.showAllUsersGrid
                });
            }
        },

        showAllUsersGrid: function(grid) {
            if (grid) {
                var view = this;
                view.allUsersGrid = view.createTemplateControl(grid);
                view.allUsersWin = KS.showModal(view.allUsersGrid, {
                    title: 'Выберите значение...',
                    autoHeight: false,
                    resizable: true,
                    autoScroll: true,
                    maximizable: true,
                    height: Math.max(500, KS.rootViewport.getHeight() / 1.5),
                    minHeight: 500,
                    width: Math.max(400, KS.rootViewport.getWidth() / 2),
                    minWidth: 400,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            parentView : view,
                            cls: 'dim-button',
                            handler: view.setValueForSelectUser
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.allUsersWin.close();
                            }
                        }]
                }, true);
            }
        },

        setValueForSelectUser: function() {
            var view = this.parentView;
            var grid = view.allUsersGrid;
            var checkedRows = grid.getCheckedRows();
            if (!Ext.isEmpty(checkedRows) && checkedRows.length > 0) {
                var selectedValues = [];
                Ext.each(checkedRows,
                    function(row) {
                        selectedValues.push(row.data);
                    });
                var code = view.selectedPropertOption.code;
                var propValue = view.selectedPropertOption.value;
                var isUser = view.selectedPropertOption.isUserSetting;
                var optionCode = view.navigatorTree.getSelNodeId();
                view.serverCall({
                    method: 'SetValueForSelectUser',
                    params: [selectedValues, code, propValue, isUser, optionCode],
                    success: function(success) {
                        if (success) 
                            view.saveOptionsChanges(false);
                    }
                });
            }
            view.allUsersWin.close();
        },

        testConnection: function() {
            var view = this.parentView;
            view.testEmailWin = KS.showModal([
            {
                xtype: 'textfield',
                itemId: 'email',
                width: '100%',
                allowBlank: false,
                inputType: 'email',
                fieldLabel: 'Адрес'
            },{
                xtype: 'textfield',
                itemId: 'theme',
                value: 'Тест',
                width: '100%',
                fieldLabel: 'Тема'
            },{
                xtype: 'textarea',
                itemId: 'message',
                value: 'Тестовое сообщение',
                width: '100%',
                fieldLabel: 'Текст'
            }],{
                layout: 'anchor',
                plain: true,
                frame: true,
                autoScroll: false,
                modal: true,
                maximizable: true,
                minWidth: 400,
                width: 400,
                minHeight: 200,
                height: 200,
                title: "Тестовая отправка письма",
                buttonAlign: 'left',
                buttons: ['->',
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        parentView: view,
                        handler:view.sendTestEmail
                    },
                    { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.testEmailWin.close();
                        }
                    }]
            }, true);
        },

        sendTestEmail: function() {
            var view = this.parentView;
            var emailEditor = view.testEmailWin.getComponent("email");
            var email = emailEditor.getValue();
            if (Ext.isEmpty(email)) {
                KS.alert("Поле 'Адрес' должно быть заполнено");
                return;
            }
            var theme = view.testEmailWin.getComponent("theme").getValue();
            var message = view.testEmailWin.getComponent("message").getValue();
            view.serverCall({
                method: 'SendTestEmail',
                params: [email, theme, message],
                waitMessage: 'Отправка письма...'
            });
            view.testEmailWin.close();
        },

        userComboChange: function(comp, newValue) {
            var view = this;
            view.serverCall({
                method: 'SetSelectedUserLink',
                disableFog: true,
                params: [newValue],
                success: function() {
                    view.navigatorTreeReset();
                    view.optionsPanel.removeAll();
                }
            });
        },

        loadOptionsPanel: function(listOptions, customChangeFunc) {
            if (listOptions) {
                var view = this;
                view.optionsPanel.removeAll();
                view.getToolbar(view.mainPanel).setHidden(false);
                view.descriptionPanel.setHidden(false);
                view.descriptionPanel.setHtml("");
                view.setToolbarBtnDisabledState(false);
                view.selectedPropertOption = {};
                if (Object.getOwnPropertyNames(listOptions).length > 0) {
                    var i = 0;
                    for (var prop in listOptions) {
                        if (listOptions.hasOwnProperty(prop)) {
                            var propertyGrid = view.getPropertyGridByOption(listOptions[prop], "propGrid" + i++, prop);
                            if (customChangeFunc && KS.isFunction(customChangeFunc))
                                propertyGrid.on("propertychange", customChangeFunc, view);
                            else
                                propertyGrid.on("propertychange", view.optionChange, view);
                            view.optionsPanel.add(propertyGrid);
                        }
                    }
                }
            }
        },

        setToolbarBtnDisabledState: function(isUserSetting) {
            var setForUsersBtn = this.getToolbarItem(this.mainPanel, null, "SET_FOR_USERS");
            if (setForUsersBtn)
                setForUsersBtn.setDisabled(!isUserSetting);
            var cleanOptionsBtn = this.getToolbarItem(this.mainPanel, null, "CLEAN_OPTION");
            if (cleanOptionsBtn)
                cleanOptionsBtn.setDisabled(!isUserSetting);
        },

        onServerLoadOptionsPanel: function(listOptions) {
            this.loadOptionsPanel(listOptions);
        },

        onServerLoadMetaOptions: function(listOptions) {
            this.loadOptionsPanel(listOptions, this.changeMetaOptions);
        },            
        
        onServerLoadEmailOptions: function(listOptions) {
            var cleanBtn = this.getToolbarItem(this.mainPanel, null, "CLEAN_OPTION");
            if (cleanBtn) cleanBtn.setVisible(false);
            var testBtn = this.getToolbarItem(this.mainPanel, null, "TEST")
            if (testBtn) testBtn.setVisible(true);
            this.loadOptionsPanel(listOptions, "имя кастомной функции");
        },            
        
        onServerLoadUnidictOptions: function(listOptions) {
            this.loadOptionsPanel(listOptions, this.changeUnidictOptions);
        },  

        onServerLoadEDSOptions: function(listOptions) {
            this.loadOptionsPanel(listOptions, "имя кастомной функции");
        },
        
        onServerLoadSystemJournalPanel: function(panel) {
            if (panel) {
                var view = this;
                view.optionsPanel.removeAll();
                view.getToolbar(view.mainPanel).setHidden(true);
                view.descriptionPanel.setHidden(true);
                view.systemJournalPanel = KS.create(panel);
                view.addPanelItems(panel, view.systemJournalPanel);
                if (view.systemJournalPanel)
                    view.optionsPanel.add(view.systemJournalPanel);
            }
        },

        onServerLoadSystemJournalSettings: function(tree) {
            if (tree) {
                var view = this;
                view.optionsPanel.removeAll();
                view.getToolbar(view.mainPanel).setHidden(true);
                view.descriptionPanel.setHidden(true);
                view.systemJournalTree = view.createTemplateControl(tree, "systemJournalTree");
                view.correctTreeNode(view.systemJournalTree.getRootNode());
                if (view.systemJournalTree)
                    view.optionsPanel.add(view.systemJournalTree);
            }
        },

        onServerLoadCalcServicePanel: function(panel) {
            if (panel) {
                var view = this;
                view.optionsPanel.removeAll();
                view.getToolbar(view.mainPanel).setHidden(true);
                view.descriptionPanel.setHidden(true);
                view.calcServicePanel = KS.create(panel);
                view.addPanelItems(panel, view.calcServicePanel);
                if (view.calcServicePanel) {
                    view.optionsPanel.add(view.calcServicePanel);
                }
            }
        },

        onServerLoadGeneralWebOptions: function(listOptions) {
            this.loadOptionsPanel(listOptions, this.changeWebOptions);
        },            

        onServerLoadAdminWebOptions: function(listOptions) {
            this.loadOptionsPanel(listOptions, this.changeWebOptions);
        },            

        correctTreeNode: function(node) {
            var view = this;
            if (node.hasChildNodes()) {
                var checked = true;
                Ext.each(node.childNodes, function(childNode) {
                    view.correctTreeNode(childNode);
                    if (childNode.get('checked') !== true)
                        checked = false;
                });
                if (!node.isRoot()) {
                    node.set('checked', checked);
                    node.collapse();
                }
            }
        },

        systemJournalTreeCheckChange: function(node, checked) {
            var link = node.id;
            var view = this;
            view.serverCall({
                method: 'SystemJournalTreeCheckChange',
                disableFog: true,
                params: [link, checked],
                success: function(result) {
                    if (result) 
                        view.touch();
                }
            });
        },

        correctOptionsValue: function(value) {
            switch(Ext.typeOf(value)) {
                case "date":
                    value = Ext.util.Format.date(value, 'd.m.Y H:i:s');
                    break;
                case "number":
                    value = value.toString();
                    break;
                case "boolean":
                    value = value ? "1" : "0";
                    break;
            }
            return value;
        },

        optionChange: function(source, recordId, value, oldValue) {
            if (oldValue != null && value.toString() !== oldValue.toString()) {
                if (this.notSavePropertyChange) { // Не нужно сохранять изменения
                    this.notSavePropertyChange = false;
                    return;
                }
                value = this.correctOptionsValue(value);
                var code = recordId.split("#")[1] || "";
                this.doOptionChange(code, value);
            }
        },

        doOptionChange: function(code, value, needReselect) {
            var view = this;
            view.serverCall({
                method: 'OptionChange',
                disableFog: true,
                params: [code, value],
                success: function(result) {
                    view.afterPropValueChanged(result, value, needReselect);
                }
            });
        },

        changeMetaOptions: function(source, recordId, value, oldValue) {
            if (!Ext.isEmpty(value) && value.toString() !== oldValue.toString()) {
                value = this.correctOptionsValue(value);
                var code = recordId.split("#")[1] || "";
                this.doMetaOptionChange(code, value);
            }
        },

        doMetaOptionChange: function(code, value) {
            var view = this;
            var selOptionsId = this.navigatorTree.getSelNodeId();
            view.serverCall({
                method: 'MetaOptionChange',
                disableFog: true,
                params: [selOptionsId, code, value],
                success: function(result) {
                    view.afterPropValueChanged(result, value);
                }
            });
        },

        changeUnidictOptions: function(){//source, recordId, value, oldValue) {
            // Пока в данной настройке только настройки с цветами, значения меняются в visualSelectorSelect
        },

        changeWebOptions: function(source, recordId, value, oldValue){
            if (!Ext.isEmpty(value) && value.toString() !== oldValue.toString()) {
                var view = this;
                value = view.correctOptionsValue(value);
                var code = recordId.split("#")[1] || "";
                var groups = view.collectWebOptionsValues(code, value);
                view.serverCall({
                    method: 'ChangeWebOptions',
                    disableFog: true,
                    params: [groups],
                    success: function(result) {
                        view.afterPropValueChanged(result, value);
                    }
                });
            }
        },

        collectWebOptionsValues: function(code, value) {
            var groups = [];
            Ext.each(this.data.Groups, function(group) {
                var list = group.List;
                Ext.each(list, function(listItem) {
                    if (listItem.Key == code) {
                        switch (listItem.Type) {
                            case 2: // Boolean
                                listItem.Value = value === true || $.inArray(value, ['true', 'True', 1, '1']) >= 0;
                                break;                            
                            case 4: // DropDownList
                                Ext.each(listItem.Items, function(item, ddlIdx) {
                                    if (item == value)
                                        listItem.Value = ddlIdx;
                                });
                                break;
                            default:
                                listItem.Value = value;
                                break;
                        }
                    }
                });
                groups.push(list);
            });
            return groups;
        },

        afterPropValueChanged: function(result, newValue, needReselect) {
            if (result) {
                if (needReselect) 
                    this.reselectTreeNode();
                
                if (!Ext.isEmpty(this.selectedPropertOption) &&
                    this.selectedPropertOption.value !== newValue) {
                    this.selectedPropertOption.value = newValue;
                }
                this.touch();
            }
        },

        calcServiceGridClick: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            var column = e.position.column;
            if (column.aspType === "checkcolumn") {
                var view = this;
                var linkForm = KS.Grid.getAnyCase(record, "link_form");
                var dataIndex = column.dataIndex;
                var newValue = KS.Grid.getAnyCase(record, dataIndex);
                view.serverCall({
                    method: 'CalcServiceValueChange',
                    disableFog: true,
                    params: [linkForm, dataIndex, newValue],
                    success: function(result) {
                        if (result)
                            view.touch();
                    }
                });
            }
        },

        systemJournalTreeClick: function() {

        },

        systemJournalInvertAll: function() {
            var view = this.parentView || this;
            view.systemJournalTree.invertAll();
        },

        systemJournalUnmarkAll: function() {
            var view = this.parentView || this;
            view.systemJournalTree.uncheckAll();
        },

        systemJournalCheckChild: function() {
            var view = this.parentView || this;
            view.systemJournalTree.checkAllChildren();
        },

        systemJournalCheckChildOneLevel: function() {
            var view = this.parentView || this;
            view.systemJournalTree.checkDirectChildren();
        },

//        openStringInTextArea: function() {
//            var view = this;
//            view.stringEditorWin = KS.showModal({
//                xtype: 'textarea',
//                itemId: 'textEditorArea'
////                value: value //Значение настройки, которую редактируем
//            },{
//                layout: 'fit',
//                plain: true,
//                frame: true,
//                autoScroll: true,
//                modal: true,
//                maximizable: true,
//                minWidth: 400,
//                minHeight: 300,
//                width: Math.max(400, KS.rootViewport.getWidth() / 2),
//                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
//                title: "Редактирование...", // Должно быть имя настройки, которую редактируем
//                buttonAlign: 'right',
//                buttons: new Array({
//                    text: 'Применить',
//                    cls: 'marked-button',
//                    handler: function () {
////                        var newValue = view.stringEditorWin.getComponent("textEditorArea").getValue();
//                        view.stringEditorWin.close(true);
//                    }
//                })
//            }, true);
//        },

//        // Для option.Type =1 - поле с кнопкой, чтобы открыть редактирование в модальном окне, 
//        // чтобы удобней редактировать много текста
//        // (не работает) Проблема с inputEl
//        var textEditor = view.createTemplateControl({
//                type: "textEditor",
//                disabled: option.ReadOnly,
//                fieldCls: option.ReadOnly ? "textfield-read-only" : "",
//                fieldStyle: "font-weight: bold",
//                listeners: { selectbtn: "view.openStringInTextArea" }
//            },
//            key);
//        textEditor.resetOriginalValue = function() {
//            this.originalValue = this.getValue();
//        };
//        textEditor.isValid = function() {
//            return true;
//        };

        beforePropertyGridCellClick: function(gridView, td, cellIndex, record, tr, rowIndex) { 
            var propGrid = this;
            var sourceConfig = propGrid.sourceConfig[record.id];
            var description = sourceConfig.description;
            this.parentView.descriptionPanel.setHtml(description);
            // Не входить в режим редактирования у некоторых полей
            if (!KS.isEmpty(sourceConfig) && 
                (sourceConfig.type === "visualSelector" || sourceConfig.type === "image")) {
                propGrid.getSelectionModel().select(rowIndex);
                return false;
            } 
            return true;
        },

        propertyGridCellClick: function(gridView, td, cellIndex, record) {
            var view = this.parentView;
            var propGrid = this;
            view.unselectFieldFromOtherPropGrids(propGrid);

            var sourceConfig = propGrid.sourceConfig[record.id];
            var name = sourceConfig.baseName;
            var code = record.id.split("#")[1] || "";
            var isUserSetting = sourceConfig.isUserSetting;
            var value = propGrid.source[record.id];
            view.selectedPropertOption = {
                name : name,
                code : code,
                isUserSetting : isUserSetting,
                value : value
            };

            if (!Ext.isEmpty(isUserSetting))
                view.setToolbarBtnDisabledState(isUserSetting);
        },

        unselectFieldFromOtherPropGrids: function(propGrid) {
            Ext.each(propGrid.ownerCt.items.items, function(onePropGrid) {
                if (onePropGrid.itemId !== propGrid.itemId)
                    onePropGrid.setSelection();
            });
        },

        propertyGridDblClick: function(gridView, td, cellIndex, record, tr, rowIndex) {
            var propGrid = this;
            var view = this.parentView;
            var selectProp = propGrid.settings[rowIndex];
            var sourceConfig = propGrid.sourceConfig[record.id];
            if (!KS.isEmpty(sourceConfig)) {
                switch(sourceConfig.type) {
                    case "fieldSelector":
                        view.fieldSelectorSelect(selectProp, propGrid, record, rowIndex);
                        break;

                    case "visualSelector":
                        view.showVisualSelector(convertToHexString(selectProp.Value).substring(1), selectProp.Key);
                        break;

                    case "dictionSelect":
                        view.selectFromDiction(selectProp.Key, selectProp.DictionID);
                        break;                 
                    
                    case "image":
                        if (!selectProp.ReadOnly)
                            view.selectImage(selectProp.Key, sourceConfig.type);
                        break;   

                    case "fileSelect":
                        view.selectFile(selectProp.Key, sourceConfig.type);
                        break;

                    case "boolean":
                        view.changeBooleanByDblClick(propGrid, record, propGrid.source[record.id]);
                        break;
                }
            }
        },

        fieldSelectorSelect: function(selectProp, propGrid, record, rowIndex) {
            var view = this;
            var propId = record.id;
            view.propertySelectorGrid = KS.create(selectProp.SelectorGrid);
            if (view.propertySelectorGrid) {
                view.propertySelectorWin = KS.showModal(view.propertySelectorGrid, {
                    title: 'Выберите значение...',
                    autoHeight: false,
                    resizable: true,
                    autoScroll: true,
                    maximizable: true,
                    width: Math.max(400, KS.rootViewport.getWidth() / 2),
                    height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                    minHeight: 300,
                    minWidth: 400,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.selectFromSelectorGrid(propId, propGrid, rowIndex);
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.propertySelectorWin.close();
                            }
                        }]
                }, true);
            }
        },

        selectFromSelectorGrid: function(propId, propGrid, propIdx) {
            var value = "";
            var newPropValue = [];
            var view = this;
            var code = propId.split("#")[1] || "";
            if (code == "EDS_DELETE_STATUS"){
                this.modifyEdsDeleteStatus(propId, propGrid, propIdx);
                return;
            }
            if (code === "MAIL_SEND_STATUS") {
                view.mailSendStatusChange(propId, propGrid, propIdx);
                return;
            }
            this.propertySelectorGrid.store.each(function(record) {
                var checkValue = KS.Grid.getAnyCase(record, "CHECKED") === true ? "1" : "0";
                value += checkValue + "~" +
                    KS.Grid.getAnyCase(record, "CODE") + "~" +
                    KS.Grid.getAnyCase(record, "NAME") + ";\r\n";
                if (checkValue === "1")
                    newPropValue.push(KS.Grid.getAnyCase(record, "NAME"));
            });
            view.serverCall({
                method: 'FieldSelectorChange',
                disableFog: true,
                params: [code, value],
                success: function(grid) {
                    view.afterFieldSelectorChange(grid, newPropValue, propId, propGrid, propIdx);
                }
            });
        },

        modifyEdsDeleteStatus: function(propId, propGrid, propIdx){
            var view = this;
            var checkedRows = this.propertySelectorGrid.getCheckedRows();
            var checkedRowsData = [];
            Ext.each(checkedRows, function(row) {
                checkedRowsData.push(row.data);
            });
            view.serverCall({
                method: 'ModifyEdsDeleteStatus',
                disableFog: true,
                params: [checkedRowsData],
                success: function(result) {
                    view.afterFieldSelectorChange(result.grid, result.newPropValue, propId, propGrid, propIdx);
                }
            });
        },

        mailSendStatusChange: function(propId, propGrid, propIdx) {
            var view = this;
            var checkedRow = this.propertySelectorGrid.getCheckedRows();
            var newPropValue = [];
            var codes = [];
            Ext.each(checkedRow, function(row) {
                newPropValue.push(KS.Grid.getAnyCase(row, "name_from") + "-" + KS.Grid.getAnyCase(row, "name_to"));
                codes.push(KS.Grid.getAnyCase(row, "link_from") + "_" + KS.Grid.getAnyCase(row, "link_to"));
            });
            view.serverCall({
                method: 'MailSendStatusChange',
                disableFog: true,
                params: [codes],
                success: function(grid) {
                    view.afterFieldSelectorChange(grid, newPropValue, propId, propGrid, propIdx);
                }
            });
        },

        afterFieldSelectorChange: function(grid, newPropValue, propId, propGrid, propIdx) {
            if (grid) {
                var newValue = newPropValue.join(', ');
                this.notSavePropertyChange = true;
                propGrid.setProperty(propId, newValue);
                propGrid.settings[propIdx].SelectorGrid = grid;
                this.touch();
                this.propertySelectorWin.close();
            }
        },

        addVisualSelectorStyle: function() {
            if (!this.visualSelectorStyleAdded) {
                $("<style type='text/css'>" +
                    ".color-picker-custom-style.x-color-picker-item {" +
                        "height: 27px;" +
                        "width: 27px;" +
                    "}" +
                    ".color-picker-custom-style.x-color-picker-item-inner {" +
                        "line-height: 20px;" +
                    "}" +
                    "</style>").appendTo("head");
                this.visualSelectorStyleAdded = true;
            }
        },

        showVisualSelector: function(value, code) {
            var view = this;
            this.addVisualSelectorStyle();
            view.visualSelector = Ext.create('Ext.picker.Color',
                {
                    value: value,
                    itemCls: 'color-picker-custom-style ' + Ext.baseCSSPrefix + 'color-picker-item'
                });

            if (view.visualSelector.colors.indexOf("D2FFE9") === -1) //Дефолтные цвета
                view.visualSelector.colors.unshift("D2FFE9");          //
            if (view.visualSelector.colors.indexOf("FFC6C7") === -1)   //
                view.visualSelector.colors.unshift("FFC6C7");            //            
            if (view.visualSelector.colors.indexOf("C0C0C0") === -1)   //
                view.visualSelector.colors.unshift("C0C0C0");            //

            if (view.visualSelector.colors.indexOf(value) === -1)
                view.visualSelector.colors.unshift(value);
            view.visualSelectorWin = KS.showModal(view.visualSelector, 
            {
                title: 'Выберите цвет',
                autoHeight: false,
                resizable: false,
                autoScroll: false,
                maximizable: false,
                width: 215,
                minWidth: 215,
                height: 270,
                minHeight: 270,
                buttonAlign: 'left',
                buttons: [{ xtype: 'tbspacer', width: 8 },
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function() {
                            view.visualSelectorSelect(code);
                        }
                    },
                    '->',
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.visualSelectorWin.close();
                        }
                    },
                    { xtype: 'tbspacer', width: 8 }]
            }, true);
        },

        visualSelectorSelect: function(code) {
            var view = this;
            var newValue = view.visualSelector.getValue();
            if (Ext.isString(newValue)) 
                newValue = parseInt(newValue, 16);
            
            var newColor = newValue - 1 - 0xFFFFFF;
            var optionId = view.navigatorTree.getSelNodeId();
            view.serverCall({
                method: 'VisualSelectorChange',
                disableFog: true,
                params: [optionId, code, newColor],
                success: function(changed) {
                    if (changed) {
                        view.reselectTreeNode();
                        view.touch();
                        view.visualSelectorWin.close();
                    }
                }
            });
        },

        selectFromDiction: function(propertyId, dictionId) {
            this.serverCall({
                method: 'SelectFromDiction',
                waitMessage: "Открытие справочника...",
                params: [propertyId, dictionId]
            });
        },

        onServerSelectedFromDiction: function() {
            this.reselectTreeNode();
            this.touch();
        },

        selectImage: function(code, type) {
            this.openSelectFileWindow(code, type);
        },

        selectFile: function(code, type) {
            this.openSelectFileWindow(code, type);
        },

        openSelectFileWindow: function(code, type) {
            var selectFileBtn = Ext.getCmp("selectOptionsFileBtn");
            if (!KS.isEmpty(selectFileBtn)) {
                if (code) {
                    selectFileBtn.optionCode = code;
                    selectFileBtn.optionType = type;
                }
                var oldMultiple = selectFileBtn.fileInputEl.dom.multiple;
                selectFileBtn.fileInputEl.dom.multiple = false;
                // открываем окно выбора файла
                selectFileBtn.fileInputEl.dom.click();
                // возвращаем всё обратно
                selectFileBtn.fileInputEl.dom.multiple = oldMultiple;
            }
        },

        saveFiles: function (fileKeys,  o, filefield) {
            var selectFileBtn = Ext.getCmp("selectOptionsFileBtn");
            var view = this.parentView || this;
            if (!KS.isEmpty(selectFileBtn)) {
                if (!Ext.isEmpty(selectFileBtn.optionCode) &&
                    !Ext.isEmpty(selectFileBtn.optionType)) {
                    var code = selectFileBtn.optionCode;
                    var path = filefield.lastValue;
                    switch(selectFileBtn.optionType) {
                        case "image":
//                              Сохранить новую картинку в doMetaOptionChange
                            break;   

                        case "fileSelect":
                            view.doOptionChange(code, path, true);
                            break;
                    }
                }
            }
        },

        reselectTreeNode: function() {
            this.navigatorTreeSelect(null, this.navigatorTree.getSelNode());
        }
    });
}(SvodOptionsView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();