﻿SelectionTemplateView = KS.extend(BaseTreeView, {
    customName: 'SelectionTemplateView'
});

// ============= COMMON =======================
(function (viewClass) {
    var sc = SelectionTemplateView.superclass;

    KS.apply(viewClass, {
        onTemplateRendered: function () {
            this.setCustomComboBoxExpand(this.budgetTreePanel);
            this.budgetTree.checkedNodes = {};
        },

        getTbarClickHandler: function (tbarItem) {
            var view = this;
            switch (tbarItem.code) {
                case 'ADD':
                    return view.addBaseTreeRow;

                case 'EDIT':
                    return view.editBaseTreeRow;

                case 'DELETE':
                    return view.deleteBaseTreeRow;

                default:
                    return sc.getTbarClickHandler.call(this, tbarItem);
            }
        },

        onSetSavedState: function(saved) {
            var view = this;
            if (Ext.isEmpty(view.budgetTree)) return;
            var saveBtn = view.getToolbarItem(view.rootPanel, null, 'SAVE');
            if (saveBtn)
                saveBtn.setDisabled(saved);
        },

        resetView: function () {
            var view = this;
            view.budgetTree.checkedNodes = {};
            view.baseTree.nodeToSelect = null;
            view.reloadBaseTree();
            view.reloadBudgetTree();
            view.discardChanges();
        },

        beforeSaveChanges: function() {
            var view = this;
            view.serverCall({
                method: 'BudgetTreeSaveChanges',
                params: [view.budgetTree.checkedNodes]
            });
        },

        helpBtn: function () {
            var href = "Docs/html/index.html";
            href += '?' + '2016' + '.htm';
            window.open(href, "_blank", "status=yes,location=yes,toolbar=yes,resizable=yes,menubar=yes,scrollbars=yes");
        }
    });
}(SelectionTemplateView.prototype));

// ============= BASE TREE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        reloadBaseTree: function() {
            var view = this;
            view.baseTree.getRootNode().removeAll(true);
            view.baseTree.fullReload();
        },

        afterBaseTreeLoad: function () {
            var view = this;
            view.activateBudgetTree();
            view.discardChanges();
        },

        baseTreeNodeLoaded: function() {
            var view = this,
                nodeToSelect = view.baseTree.nodeToSelect;
            if (nodeToSelect)
                view.baseTree.setSelected(nodeToSelect.toString());
            else
                this.baseTree.selectFirstNode();
        },

        baseTreeNodeSelect: function(treeModel, selected) {
            // Если ничего не выбрано или узлы дерева организаций не загрузились
            if (Ext.isEmpty(selected) || this.budgetTree.getRootNode().childNodes.length === 0)
                return;
            this.setBudgetTreeCheckStates(selected[0].id);
        },

        addBaseTreeRow: function() {
            var view = this.parentView;
            view.getEditBaseTreePanel('NEW', null);
        },

        editBaseTreeRow: function() {
            var view = this.parentView;
            if (view.baseTree) {
                var selNodeId = view.baseTree.getSelNodeId();
                if (selNodeId === null)
                    return;
                view.getEditBaseTreePanel('EDIT', selNodeId);
            }
        },

        getEditBaseTreePanel: function(operation, templateLink) {
            var view = this;
            view.serverCall({
                method: 'GetEditBaseTreePanel',
                params: [operation, templateLink],
                success: function (settings) {
                    view.showEditBaseTreePanel(settings, operation, templateLink);
                }
            });
        },

        showEditBaseTreePanel: function(settings, operation, templateLink) {
            var view = this;
            view.propertyGrid = view.getPropertyGridByOption(settings, "propertyGrid", "Общие");
            view.editBaseTreeWin = KS.showModal(view.propertyGrid, {
                title: 'Свойства',
                autoHeight: false,
                layout: 'anchor',
                height: 400,
                minHeight: 200,
                width: 600,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'ОК',
                    cls: 'dim-button',
                    handler: function () {
                        view.doEditBaseTree(operation, templateLink);
                    }
                }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.editBaseTreeWin.close();
                        }
                    }]
            }, true);
        },

        doEditBaseTree: function(operation, templateLink) {
            var view = this;
            var newValues = view.propertyGrid.source;
            view.serverCall({
                method: 'EditBaseTree',
                params: [newValues, operation, templateLink],
                waitMessage: operation === 'NEW' ? 'Создание ...' : 'Редактрование ...',
                success: function(editRowLink) {
                    if (!Ext.isEmpty(editRowLink)) {
                        if (operation === 'NEW') {
                            view.budgetTree.checkedNodes[editRowLink] = [];
                            view.budgetTreePanel.setDisabled(false);
                        }
                        view.editBaseTreeWin.close();
                        view.touch();

                        view.baseTree.nodeToSelect = editRowLink;
                        view.reloadBaseTree();
                    }
                }
            });
        },

        deleteBaseTreeRow: function() {
            var view = this.parentView,
                links = [],
                checkedNodes = view.baseTree.getChecked();

            if (!Ext.isEmpty(checkedNodes)) {
                Ext.each(checkedNodes, function(node) {
                    links.push(node.id);
                });
            }
            else {
                var selNodeId = view.baseTree.getSelNodeId();
                if (selNodeId)
                    links.push(selNodeId);
            }

            if (links.length === 0)
                return;

            KS.confirm("Будет удалено строк: " + links.length + ". Продолжить?", "Подтвердите удаление", function (btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'DeleteBaseTreeRow',
                        params: [links],
                        success: function () {
                            Ext.each(links, function(id) {
                                delete view.budgetTree.checkedNodes[id];
                            });
                            if (view.baseTree.getStore().data.length === links.length) {
                                view.budgetTree.collapseAll();
                                view.budgetTreePanel.setDisabled(true);
                            }
                            view.touch();

                            view.baseTree.nodeToSelect = null;
                            view.reloadBaseTree();
                        }
                    });
                }
            });
        }
    });
}(SelectionTemplateView.prototype));

// ============= BUDGET TREE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        reloadBudgetTree: function() {
            this.budgetTreePanel.setDisabled(true);
            this.budgetTree.getRootNode().removeAll(true);
            this.budgetTree.fullReload();
        },

        activateBudgetTree: function(versionLink = null) {
            this.serverCall({
                method: 'ActivateBudgetTree',
                params: [versionLink],
                success: this.reloadBudgetTree
            });
        },

        budgetTreeNodeLoaded: function() {
            var view = this,
                baseTreeSelectedNodeId = view.baseTree.getSelNodeId();
            if (!baseTreeSelectedNodeId) {
                view.baseTree.selectFirstNode();
                if (view.baseTree.getSelNodeId() !== null)
                    view.budgetTreePanel.setDisabled(false);
            }
            else {
                view.budgetTreePanel.setDisabled(false);
                view.setBudgetTreeCheckStates(baseTreeSelectedNodeId);
            }
        },

        markBudgetTreeNodes: function(tbarItem) {
            var view = this.parentView,
                code = tbarItem.tbarNode.code;

            view.budgetTreeDisableFilters();

            switch(code) {
                case 'MARK_INVERT_TREE':
                case 'MARK_INVERT2_TREE':
                    view.markInvertTreeNodes();
                    break;

                case 'MARK_ALL_TREE':
                    view.markAllTreeNodes();
                    break;

                case 'MARK_CHILD':
                case 'MARK_CHILD2':
                    view.checkChildrenNodes();
                    break;

                case 'MARK_DIRECT_CHILDREN':
                    view.checkDirectChildrenNodes();
                    break;

                case 'MARK_LEAF':
                    view.checkLeafNodes();
                    break;

                case 'UNMARK_TREE':
                    view.unmarkTreeNodes();
                    break;
            }

            view.budgetTreeAfterMarkNodes();
        },

        budgetTreeAfterMarkNodes: function() {
            var view = this,
                baseTreeNodeId = view.baseTree.getSelNodeId(),
                checkedNodes = view.budgetTree.getChecked();

            view.budgetTree.checkedNodes[baseTreeNodeId] = [];
            Ext.each(checkedNodes, function (node) {
                var splittedId = node.id.split('_');
                Ext.Array.include(view.budgetTree.checkedNodes[baseTreeNodeId], splittedId[1] + '_' + splittedId[2]);
            });

            if (view.searchPanel.cachedValue) {
                view.getToolbarItem(view.searchPanel, null, "searchField").setValue(view.searchPanel.cachedValue);
                view.searchPanel.cachedValue = null;
            }

            view.touch();
        },

        expandHandler: function() {
            this.parentView.budgetTree.expandAll();
        },

        collapseHandler: function() {
            this.parentView.budgetTree.collapseAll();
        },

        getSelectedBudgetNodes: function() {
            var view = this.parentView,
                checkedBaseTreeNodes = view.baseTree.getChecked(),
                selectedNodes = [];

            if (!Ext.isEmpty(checkedBaseTreeNodes)) {
                Ext.each(checkedBaseTreeNodes, function(row) {
                    Ext.each(view.budgetTree.checkedNodes[KS.Grid.getAnyCase(row, 'id')], function(nodeId) {
                        Ext.Array.include(selectedNodes, nodeId);
                    });
                });
            }
            else {
                var budgetTreeCheckedNodes = view.budgetTree.checkedNodes[view.baseTree.getSelNodeId()];
                if (budgetTreeCheckedNodes) {
                    Ext.each(budgetTreeCheckedNodes, function (nodeId) {
                        Ext.Array.include(selectedNodes, nodeId);
                    });
                }
            }

            view.budgetTree.disable();
            view.serverCall({
                method: 'GetBudgetTreeOrganizations',
                params: [selectedNodes],
                async: true
            });
        },

        budgetTreeBeforeCheckChange: function() {
            var view = this;
            if (!view.baseTree.getSelNodeId() || !Ext.isEmpty(view.rootPanel.ctrl.toolbars.Bottom))
                return false;
        },

        budgetTreeCheckChange: function(node, checkState) {
            var view = this,
                checkedNodes = view.budgetTree.checkedNodes[view.baseTree.getSelNodeId()],
                splittedId = node.id.split('_');

            if (checkState) {
                if (!checkedNodes)
                    checkedNodes = [];
                Ext.Array.include(checkedNodes, splittedId[1] + '_' + splittedId[2]);
            }
            else
                Ext.Array.remove(checkedNodes, splittedId[1] + '_' + splittedId[2]);

            view.touch();
        },

        setBudgetTreeCheckStates: function (baseTreeNodeId) {
            var view = this,
                budgTree = view.budgetTree;

            view.budgetTreeDisableFilters();

            if (!budgTree.checkedNodes[baseTreeNodeId]) {
                view.getBudgetTreeCheckedNodes(baseTreeNodeId);
            }
            else {
                view.setBudgetTreeCheckedNodes(baseTreeNodeId);
            }

            if (view.searchPanel.cachedValue) {
                view.getToolbarItem(view.searchPanel, null, "searchField").setValue(view.searchPanel.cachedValue);
                view.searchPanel.cachedValue = null;
            }
        },

        getBudgetTreeCheckedNodes: function(baseTreeNodeId) {
            var view = this;
            view.serverCall({
                method: 'GetCheckedNodes',
                success: function(checkedNodes) {
                    if (checkedNodes)
                        view.budgetTree.checkedNodes = checkedNodes;
                    view.setBudgetTreeCheckedNodes(baseTreeNodeId);
                }
            });
        },

        setBudgetTreeCheckedNodes: function(baseTreeNodeId) {
            var view = this,
                budgTree = view.budgetTree;

            budgTree.collapseAll();
            if (budgTree.checkedNodes[baseTreeNodeId] && budgTree.checkedNodes[baseTreeNodeId].length > 0) {
                var rootNode = budgTree.getRootNode();
                view.setBudgetTreeCheckedNodesRecursive(rootNode, baseTreeNodeId);

                Ext.each(budgTree.getCheckedPaths(), function(path) {
                    budgTree.expandPath(path);
                });
            }
            else {
                view.unmarkTreeNodes();
            }
        },

        setBudgetTreeCheckedNodesRecursive: function(node, baseTreeNodeId) {
            var view = this;
            if (node.id !== 'root') {
                var splittedId = node.id.split('_');
                if (Ext.Array.contains(view.budgetTree.checkedNodes[baseTreeNodeId], splittedId[1] + '_' + splittedId[2]))
                    setChecked(node, true);
                else
                    setChecked(node, false);
            }
            Ext.each(node.childNodes, function(childNode) {
                view.setBudgetTreeCheckedNodesRecursive(childNode, baseTreeNodeId);
            });
        },

        selectBudgetTreeVersion: function(combo, newValue) {
            var view = this.parentView || this,
                selectRecord = combo.findRecord(combo.valueField, newValue);
            if (selectRecord) {
                view.activateBudgetTree(newValue);
            }
        },

        orgTreeOnlyChecked: function(component, newValue) {
            var view = this.parentView || this;
            var filters = view.budgetTree.store.getFilters();
            if (newValue)
                filters.add(view.applyFilterToNodes);
            else
                filters.remove(view.applyFilterToNodes);
        },

        applyFilterToNodes: function(node) {
            var isNodeHasCheckedChild = false;
            var hasCheckedChildNodes = function(node) {
                if (node.get('checked') === true) {
                    isNodeHasCheckedChild = true;
                } else {
                    if (node.hasChildNodes()) {
                        Ext.each(node.childNodes, function(childNode) {
                            hasCheckedChildNodes(childNode);
                        });
                    }
                }
            };
            hasCheckedChildNodes(node);
            return !!(node.get('checked') || node.isRoot() || isNodeHasCheckedChild);
        },

        // Отключение фильтров перед установкой чекбоксов, чтобы избежать подвисание
        budgetTreeDisableFilters: function () {
            var view = this,
                tbarOnlyChecked = view.getToolbarItem(view.budgetTreePanel, null, 'ONLY_CHECKED'),
                searchField = view.getToolbarItem(view.searchPanel, null, "searchField"),
                searchFieldValue = searchField.getValue();

            if (tbarOnlyChecked.checked)
                tbarOnlyChecked.setValue(false);

            if (searchFieldValue !== '' && view.budgetTree.store.getFilters().items.length !== 0) {
                view.clearSearchField();
                view.searchPanel.cachedValue = searchFieldValue;
            }
        }
    });
}(SelectionTemplateView.prototype));