﻿SavedFormsCopyView = KS.extend(BaseSvodView, {
    onInit: function () {
        this.containerPanel.setScrollable(false);// При масштабе в браузере появлялись ненужные скролы, которые перекрывали кнопку ОК
        SavedFormsCopyView.superclass.onInit.apply(this, arguments);
    },

    select: function() {
        var view = this.parentView,
            period = view.pComp.getPeriod(),
            budgNodeId = view.budgetTree.getSelNodeId(),
            delReports = view.delReports.getValue(),
            noChangeOrg = view.noChangeOrg.getValue();
        view.serverCall({
            method: 'Select',
            params: [period, budgNodeId, delReports, noChangeOrg],
            success: view.close
        });
    },

    noChangeOrgCheck: function(comp, newValue){
        var view = this.parentView || this;
        view.budgetTree.setDisabled(newValue);
    },

    periodCompChange: function(){
        var view = this;
        var period = view.pComp.getPeriod(); // так же нужен для показа дня и недели
        view.serverCall({
            method: 'ChangePeriod',
            params: [period],
            success: function(){
                view.budgetTree.getRootNode().removeAll(true);
                view.budgetTree.fullReload();
            }
        });
    }
});

if (typeof (Sys) !== 'undefined') { Sys.Application.notifyScriptLoaded(); }