﻿ReportCreateAndAutofillView = KS.extend(BaseDictionaryView, {
    onTemplateRendered: function() {
        this.getToolbarItem(this.mainGrid, 'top', 'CLEAR_FORM').setValue(false);
        this.getToolbarItem(this.mainGrid, 'top', 'CALC_TOTAL').setValue(false);
    },

    select: function () {
        var view = this.parentView || this,
            grid = view.mainGrid,
            selectRows = grid ? grid.getCheckedRows() : [],
            formsParams = [];
        if (view.data.autoSelect)
            selectRows.push({
                data: view.data.autoSelectDict
            });
        if (Ext.isEmpty(selectRows)) return;
        Ext.each(selectRows, function(row) {
            formsParams.push(row.data);
        });
        view.selectForms(formsParams);
    },

    rowDblClickHandler: function(grid, record) {
        var formsParams = [];
        formsParams.push(record.data);
        this.selectForms(formsParams);
    },

    selectForms: function(formsParams) {
        var view = this;
        if (view.data.autoSelect && !Ext.isEmpty(formsParams)) {
            var lsf = parseInt(formsParams[0]["LSF"]);
            if (lsf > 0) {
                KS.confirm("Форма уведомления ЕАЭС уже создана. Имеющиеся данные будут изменены. Заполнить повторно?",
                    "Внимание",
                    function (btn) {
                        if (btn === 'yes') {
                            view.doSelect(formsParams);
                        } else {
                            view.close();
                        }
                    });
                return;
            }
        }
        view.doSelect(formsParams)
    },

    doSelect: function(formsParams){
        var view = this;
        view.disable();
        view.serverCall({
            method: 'SelectForms',
            params: [formsParams, view.getCheckBoxState()],
            success: function(ok) {
                if (ok) {
                    view.containerPanel.hide();
                    view.destroyContainerItems();
                } else {
                    view.enable();
                }
            },
            error: view.enable
        });
    },

    getCheckBoxState: function() {
        var clearForm = this.data.autoSelect ?
                            this.data.clearForm :
                            this.getToolbarItem(this.mainGrid, 'top', 'CLEAR_FORM').getValue(),
            calcTotal = this.data.autoSelect ?
                            this.data.calcTotal :
                            this.getToolbarItem(this.mainGrid, 'top', 'CALC_TOTAL').getValue();
        return {
            CLEAR_FORM : clearForm,
            CALC_TOTAL : calcTotal
        };
    }
});

if (typeof (Sys) !== 'undefined') { Sys.Application.notifyScriptLoaded(); }