﻿// ============= VIEW =======================
NoticeListView = KS.extend(BaseTreeView, {
    customName: 'ReportTaskListView',
    deleteConfirmMsg: 'Удалить выделенные уведомления?',
    progressRefreshInterval: 5 * 1000,
    waitMessage: 'Чтение данных ',

    showWaitMessage: function () {
        this.stopWaiting();
        if (this.waitMessage.split(".").length > 3) {
            this.waitMessage = this.waitMessage.replace(/\./g, '');
        } else {
            this.waitMessage += '.';
        }
        this.pleaseWait(this.waitMessage);
    },

    onInit: function () {
        this.showWaitMessage();
        this.serverCall({
            method: 'ReadNoticeListData',
            disableFog: true,
            timeout: this.progressRefreshInterval,
            delay: this.getNoticeListData,
            success: this.renderNoticeList
        });
    },

    getNoticeListData: function () {
        this.showWaitMessage();
        this.serverCall({
            method: 'GetNoticeListData',
            disableFog: true,
            waitMessage: this.waitMessage,
            success: this.renderNoticeList
        });
    },

    renderNoticeList: function (listData) {
        if (KS.isEmpty(listData)) {
            var view = this;
            setTimeout(function() { view.getNoticeListData(); }, this.progressRefreshInterval);
        } else {
            this.stopWaiting();
            KS.apply(this, listData);
            this.renderViewTemplate();
            KS.groupViewportWrapper.collapse();
        }
    },

    openNoticeSendProtocol: function(savedFormLink) {
        this.serverCall({
            method: 'OpenNoticeSendProtocol',
            params: [savedFormLink]
        });
    }
});

// ============= RELOAD =======================
(function (viewClass) {
    KS.apply(viewClass, {
        refreshList: function () {
            this.reload();
        },

        doReload: function () {
            this.showWaitMessage();
            this.serverCall({
                method: 'Reload',
                disableFog: true,
                timeout: this.progressRefreshInterval,
                delay: this.getData,
                success: this.reloadCallback
            });
        },

        getData: function () {
            this.showWaitMessage();
            this.serverCall({
                method: 'GetData',
                disableFog: true,
                success: this.reloadCallback
            });
        },

        reloadCallback: function (data) {
            if (KS.isEmpty(data)) {
                var view = this;
                setTimeout(function () { view.getData(); }, this.progressRefreshInterval);
            } else {
                this.data = data;
                this.discardChanges();
                this.refillAllFilter();
                this.resetView();
                this.stopWaiting();
            }
        }
    });
}(NoticeListView.prototype));

// ============= TOOLBAR =======================
(function(viewClass) {
    KS.apply(viewClass, {
        buildTemplateToolbar: function(toolbar, itemId) {
            var inst = NoticeListView.superclass.buildTemplateToolbar.call(this, toolbar, itemId);
            // Переопределяем overflowHandler с 'menu' на scroller', т.к. с 'menu' не работают select у комбобоксов в выпадающем списке
            if (inst)
                inst.setLayout({
                    overflowHandler: 'scroller'
                });
            return inst;
        },
        
        buildContainerToolbarItemControl: function (tbarItem, schema) {
            switch (tbarItem.code) {
                case 'NoticePeriodFilterContainer':
                    return this.buildNoticePeriodFilterControlItem(tbarItem); // Период

                case 'NoticeProductFilterContainer':
                    return this.buildNoticeFilterControlItem(false); // Тип, статус, группа продукции
                                                                     // Для международных - Тип уведомления, Статус

                case 'NoticeExtraFilterContainer':
                    return this.buildNoticeFilterControlItem(false, true); // Страна производителя, вид недостатка, сопроводительные документы
                                                                           // Для международных - Страна изготовителя, Страна лица, у которого выявлена продукция

                case 'NoticeFilterContainer':
                    return this.buildNoticeFilterControlItem(true); // Меры к продавцу, Меры к поставщикам, Меры к производителю
                                                                    // Для международных - Дата выявления, Вид нарушения, Вид принятой меры
            }
            return NoticeListView.superclass.buildContainerToolbarItemControl.call(this, tbarItem, schema);
        },

        getTbarClickHandler: function (tbarItem) {
            switch (tbarItem.code) {
                case 'PRINT':
                case 'PRINT_NOTICE':
                    return this.printNotice;
                    
                case 'AUTOFILL':
                    return this.createAndAutofill;

                default:
                    return NoticeListView.superclass.getTbarClickHandler.call(this, tbarItem);
            }
        },

        printNotice: function () {
            var view = this.parentView || this,
                rows = view.buildChosenRows(view.mainGrid);
            view.serverCall({
                method: 'OnPrintNotice',
                params: [rows]
            });
        },

        newHandler: function () {
            var view = this.parentView || this;
            if (view.data.singleFormUser) {
                view.createNotice();
            } else {
                view.formsWin = KS.showModal(view.createTemplateControl(view.tpl.controls['formsGrid']), {
                    title: 'Выбор категории уведомления',
                    autoHeight: false,
                    height: 400
                }, true);
            }
        },

        selectNotice: function () {
            var view = this.parentView || this,
                codes = view.formsGrid.getCheckedCodes(true);
            if (Ext.isEmpty(codes)) return;
            view.formsWin.close();
            view.serverCall({
                method: 'SetFormLink',
                waitMessage: 'Сохранение ...',
                params: [codes[0]],
                success: view.createNotice
            });
        },

        createNotice: function() {
            this.tryExecuteSvodTask(0, 'NEW');
        },

        createAndAutofill: function(){
            var view = this.parentView || this,
                rows = view.buildChosenRows(view.mainGrid);
            if (!Ext.isEmpty(rows)){
                if (rows.length > 1){
                    KS.alert("Заполнение нескольких форм одновременно невозможно.\n" +
                        "Выберите одно уведомление и повторите действия.", "Внимание");
                    return;
                }
                view.serverCall({
                    method: 'CreateAndAutofill',
                    params: [rows]
                });
            }
        },

        deleteCallback: function (deleted) {
            if (deleted) this.reload();
        }
    });
}(NoticeListView.prototype));

// ============= FILTER =======================
(function(viewClass) {
    KS.apply(viewClass, {
        buildNoticePeriodFilterControlItem: function () {
            var fiters = this.data.filters || {},
                fromDate = this.buildTransformDate(fiters['FROM_DATE'] || ''),
                toDate = this.buildTransformDate(fiters['TO_DATE'] || '');
            if (Ext.isDate(toDate)) toDate.setDate(toDate.getDate() - 1);

            var filterItems = [
                { xtype: 'tbspacer', width: 10 },
                { xtype: 'label', text: 'Период:' },
                { xtype: 'tbspacer', width: 3 },
                this.fromDate = new Ext.form.DateField({
                    format: 'd.m.Y',
                    emptyText: '',
                    value: fromDate,
                    editable: false,
                    enableKeyEvents: false
                }),
                { xtype: 'tbspacer', width: 3 },
                { xtype: 'label', text: '...' },
                { xtype: 'tbspacer', width: 3 },
                this.toDate = new Ext.form.DateField({
                    format: 'd.m.Y',
                    emptyText: '',
                    value: toDate,
                    editable: false,
                    enableKeyEvents: false
                }), {
                    xtype: 'button',
                    tooltip: 'Очистить фильтр по периоду',
                    iconCls: 'ks-icon-clean',
                    scope: this,
                    handler: this.clearPeriodFilter
                }
            ];
            this.fromDate.on('change', this.periodFilterChanged, this);
            this.toDate.on('change', this.periodFilterChanged, this);
            return {
                xtype: 'container',
                layout: {            
                    type: 'hbox',
                    align: 'center'
                },
                items: filterItems
            };
        },

        periodFilterChanged: function () {
            var fromDate = this.fromDate.getValue(),
                toDate = this.toDate.getValue();
            if (Ext.isDate(toDate)) toDate.setDate(toDate.getDate() + 1);
            this.setFilterKey('FROM_DATE', Ext.isEmpty(fromDate) ? null : Ext.util.Format.date(fromDate, 'Y-m-d'));
            this.setFilterKey('TO_DATE', Ext.isEmpty(toDate) ? null : Ext.util.Format.date(toDate, 'Y-m-d'));
            this.saveSettings();
        },

        clearPeriodFilter: function () {
            this.fromDate.setValue(null);
            this.toDate.setValue(null);
            this.periodFilterChanged();
        },

        buildPeriodIdentifItem: function () {
            var fiters = this.data.filters || {},
                fromDate = this.buildTransformDate(fiters['FROM_DATE_IDENTIF'] || ''),
                toDate = this.buildTransformDate(fiters['TO_DATE_IDENTIF'] || '');
            if (Ext.isDate(toDate)) toDate.setDate(toDate.getDate() - 1);

            var filterItems = [
                { xtype: 'tbspacer', width: 10 },
                { xtype: 'label', text: 'Дата выявления:' },
                { xtype: 'tbspacer', width: 3 },
                this.fromDateIdentif = new Ext.form.DateField({
                    format: 'd.m.Y',
                    emptyText: '',
                    value: fromDate,
                    editable: false,
                    enableKeyEvents: false
                }),
                { xtype: 'tbspacer', width: 3 },
                { xtype: 'label', text: '...' },
                { xtype: 'tbspacer', width: 3 },
                this.toDateIdentif = new Ext.form.DateField({
                    format: 'd.m.Y',
                    emptyText: '',
                    value: toDate,
                    editable: false,
                    enableKeyEvents: false
                }), {
                    xtype: 'button',
                    tooltip: 'Очистить фильтр по дате выявления',
                    iconCls: 'ks-icon-clean',
                    scope: this,
                    handler: this.clearPeriodIdentifFilter
                }
            ];
            this.fromDateIdentif.on('change', this.periodIdentifFilterChanged, this);
            this.toDateIdentif.on('change', this.periodIdentifFilterChanged, this);
            this.filterComponents['FROM_DATE_IDENTIF'] = this.fromDateIdentif;
            this.filterComponents['TO_DATE_IDENTIF'] = this.toDateIdentif;
            return {
                xtype: 'container',
                layout: {
                    type: 'hbox',
                    align: 'center'
                },
                items: filterItems
            };
        },

        periodIdentifFilterChanged: function () {
            var fromDate = this.fromDateIdentif.getValue(),
                toDate = this.toDateIdentif.getValue();
            if (Ext.isDate(toDate)) toDate.setDate(toDate.getDate() + 1);
            this.setFilterKey('FROM_DATE_IDENTIF', Ext.isEmpty(fromDate) ? null : Ext.util.Format.date(fromDate, 'd.m.Y'));
            this.setFilterKey('TO_DATE_IDENTIF', Ext.isEmpty(toDate) ? null : Ext.util.Format.date(toDate, 'd.m.Y'));
            this.saveSettings();
        },

        clearPeriodIdentifFilter: function () {
            this.fromDateIdentif.setValue(null);
            this.toDateIdentif.setValue(null);
            this.periodIdentifFilterChanged();
        },

        buildNoticeFilterControlItem: function (statusOnly, isExtraFilter) {
            var filterItems = [],
                extraFilterColumns = this.data.isInternationalRPN ? 
                    ["COUNTRY_PRODUCER", "COUNTRY_FACE"] : 
                    ["TERRITORY", "KIND_OF_DEFECT", "DOCUMENT"];  

            this.filterComponents = this.filterComponents || {};
            var bandColumns = this.tpl.controls.mainGrid.gridSettings.Band[0].Column;
            for (var colIdx = 0; colIdx < bandColumns.length; colIdx++) {
                var internationalStatusesComp = ["VID_NARYSHENIA", "VID_MERI"];
                var bandColumn = bandColumns[colIdx],
                    colKey = bandColumn.dataIndex,
                    isStatus = colKey.toUpperCase().indexOf('STATUS_') === 0 ||
                                (this.data.isInternationalRPN && internationalStatusesComp.indexOf(colKey.toUpperCase()) !== -1);
                if (bandColumn.tag && (statusOnly ? isStatus : !isStatus)) {
                    var isExtraColumn = extraFilterColumns.indexOf(colKey.toUpperCase()) !== -1;
                    if ((!!isExtraFilter && !isExtraColumn) ||
                        (!isExtraFilter && isExtraColumn))
                        continue;
                    var comboCfg = {
                        emptyText: '',
                        editable: false,
                        onSelectHandler: this.columnComboFilterSelected
                    };
                    if (colKey.toUpperCase() !== "COMMENT" &&
                        colKey.toUpperCase() !== "STATUS") {
                        comboCfg.listWidth = "auto";
                    }
                    var combo = this.buildDictionaryCombo(bandColumn.tag, comboCfg);
                    combo.key = colKey;
                    this.filterComponents[colKey] = combo;
                    var label = bandColumn.header;
                    if (colKey.toUpperCase() === "TERRITORY") {
                        label = "Страна производителя";
                    }
                    filterItems.push({ xtype: 'tbspacer', width: 5 });
                    filterItems.push({ xtype: 'label', text: label + ':' });
                    filterItems.push({ xtype: 'tbspacer', width: 3 });
                    filterItems.push(combo);
                }
                if (statusOnly && colKey.toUpperCase() == "DATE_IDENTIFICATION"){
                    filterItems.unshift(this.buildPeriodIdentifItem());
                }
            }

            return {
                xtype: 'container',
                layout: {            
                    type: 'hbox',
                    align: 'center'
                },
                items: filterItems
            };         
        },
        
        columnComboFilterSelected: function (combo, row) {
            var comboValue = row[combo.displayField];
            var comboValue2 = comboValue == combo.comboData.nullText
                ? ""
                : comboValue;
            this.setFilterKey(combo.key, comboValue2);
            if (combo.displayField === 'COMMENT') {
                this.refillAllFilter(comboValue2, true);
            } else {
                this.saveSettings();
            }
        },

        setFilterKey: function (key, value) {
            var filters = this.data.filters || {}
            filters[key] = value;
            if (key === 'FROM_DATE') {
                this.needReload = true;
            }
            this.data.filters = filters;
        },

        refillProductFilter: function(commentValue) {
            this.serverCall({
                method: 'RefillProductFilter',
                params: [commentValue],
                disableFog: true,
                success: this.setProductFilter
            });
        },

        setProductFilter: function (productFilter) {
            if (!productFilter) return;
            var grCombo = this.filterComponents['GROUP_PROD'],
                grComboRows = this.prepareComboRows(productFilter);
            grCombo.getStore().loadData(grComboRows.data);
            grCombo.comboData = productFilter;
            if (!Ext.isEmpty(grComboRows.data)) {
                grCombo.setValue('0');
            } else {
                grCombo.clearValue();
            }
            this.setFilterKey('GROUP_PROD', '');
            this.saveSettings();
        },   

        refillAllFilter: function(commentFilter, isCommentFilter) {
            if (this.data.isIncEaeuRpn)
                return;

            this.serverCall({
                method: 'RefillFilters',
                params: [commentFilter || "", isCommentFilter || false],
                disableFog: true,
                success: this.setFiltersData
            });
        },

        setFiltersData: function(filtersData) {
            for (var filterKey in filtersData) {
                var filterComponent = this.filterComponents[filterKey],
                    filterComboRows = this.prepareComboRows(filtersData[filterKey]);
                    filterComponent.getStore().loadData(filterComboRows.data);
                    filterComponent.comboData = filtersData[filterKey];
                    if (!this.data.filters[filterKey] ||
                        !filterComponent.findRecord(filterKey,this.data.filters[filterKey])) {
                        filterComponent.clearValue();
                        this.setFilterKey(filterKey, '');
                }
            }
            this.saveSettings();
        },

        clearAllFilters: function() {
            var view = this.parentView || this;
            for (var filterKey in view.data.filters) {
                if (filterKey !== "FROM_DATE" &&
                    filterKey !== "TO_DATE") {
                    view.setFilterKey(filterKey, "");
                    view.clearFilterComponent(filterKey);
                }
            }
            view.saveSettings();
        },
        
        clearFilterComponent: function(filterKey){
            var filterComp = this.filterComponents[filterKey]
            if (filterComp) {
                if (Ext.isFunction(filterComp.clearValue))
                    filterComp.clearValue();
                else if (Ext.isFunction(filterComp.setValue))
                    filterComp.setValue(null);
            }
        },

        saveSettings: function () {
            this.saveProfile({
                Filters: this.data.filters,
                Layout: null
            }, true);
            if (this.needReload) {
                delete this.needReload;
                this.reload();
            } else {
                this.resetGrid();
            }
        },

        onServerOpenNoticeEAEU: function(){
            var view = this;
            KS.confirm("Перейти к списку отчетов?", "Внимание", function (btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'ActivateNoticeEAEU'
                    });
                }
            });
        }
    });
}(NoticeListView.prototype));

// ============= RENDERERS =======================
function statusRenderer_1(value, metadata, record) {
    return statusRendererInternal(value, metadata, record, 'STATUS_1', 'LINK_SAVED_FORM_STATUS_1');
}

function statusRenderer_2(value, metadata, record) {
    return statusRendererInternal(value, metadata, record, 'STATUS_2', 'LINK_SAVED_FORM_STATUS_2');
}

function statusRenderer_3(value, metadata, record) {
    return statusRendererInternal(value, metadata, record, 'STATUS_3', 'LINK_SAVED_FORM_STATUS_3');
}

function statusRenderer_4(value, metadata, record) {
    return statusRendererInternal(value, metadata, record, 'STATUS_4', 'LINK_SAVED_FORM_STATUS_4');
}

function statusRenderer_5(value, metadata, record) {
    return statusRendererInternal(value, metadata, record, 'STATUS_5', 'LINK_SAVED_FORM_STATUS_5');
}

function statusRenderer_6(value, metadata, record) {
    return statusRendererInternal(value, metadata, record, 'STATUS_6', 'LINK_SAVED_FORM_STATUS_6');
}

function statusRenderer_7(value, metadata, record) {
    return statusRendererInternal(value, metadata, record, 'STATUS_7', 'LINK_SAVED_FORM_STATUS_7');
}

function statusRenderer_8(value, metadata, record) {
    return statusRendererInternal(value, metadata, record, 'STATUS_8', 'LINK_SAVED_FORM_STATUS_8');
}

function publicationRenderer(value, metadata, record, rowIndex, colIndex, store) {
    return '<span class="like-hypertext" onclick="KS.getView(' + "'" + store.grid.parentView.viewID + "'" + ').openNoticeSendProtocol(' + KS.Grid.getAnyCase(record, "link_saved_form") + ');return false;"/>' + value + '</span>';
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();