﻿IssueView = KS.extend(KS.Ext.ClientView, {
    constructor: function(viewId) {
        IssueView.superclass.constructor.call(this, viewId);
    },

    issueStates: [['0', 'Новая'], ['1', 'Назначена'], ['2', 'Решена']],

    onInit: function() {
        var view = this,
            issue = view.data.issue,
            stamp = Ext.decode(issue['stamp'].substring(1, issue['stamp'].length - 1)),
            stampFormat = Ext.util.Format.date(stamp, 'Y-m-d H:i:s'),
            hasMessage = !(Ext.isEmpty(issue.message)),
            hasDetails = !(Ext.isEmpty(issue.details)),
            issueItems = new Array({
                xtype: 'textfield',
                cls: 'textfield-read-only',
                fieldLabel: 'Пользователь',
                value: issue.user
            }, {
                xtype: 'textfield',
                cls: 'textfield-read-only',
                fieldLabel: 'Время',
                value: stampFormat
            });

        if (hasMessage) {
            issueItems.push({
                title: 'Описание',
                anchor: '99% ' + ((hasDetails) ? '30%' : '60%'),
                bodyCssClass: 'textfield-read-only',
                html: issue.message.replace(/\r\n/g, '</br>')
            });
        }

        if (hasDetails) {
            issueItems.push({
                title: 'Подробности',
                anchor: '99% ' + ((hasMessage) ? '30%' : '60%'),
                bodyCssClass: 'textfield-read-only',
                html: issue.details.replace(/\r\n/g, '</br>')
            });
        }

        issueItems.push({
            title: 'График',
            anchor: '99% 30%',
            html: 'В разработке'
        });

        view.renderToParent({
            tbar: new Array({
                iconCls: 'ks-icon-refresh',
                tooltip: 'Обновить',
                scope: view,
                handler: view.refresh
            }, '-', {
                iconCls: 'ks-icon-search',
                tooltip: 'Открыть скриншот',
                hidden: !view.data.hasScreenShot,
                scope: view,
                handler: view.openScreenShot
            }, '-', {
                xtype: 'label',
                text: 'Статус: '
            }, ' ', view.stateCombo = new Ext.form.ComboBox({
                store: new Ext.data.ArrayStore({
                    fields: ['state', 'text'],
                    data: view.issueStates
                }),
                valueField: 'state',
                displayField: 'text',
                typeAhead: true,
                mode: 'local',
                triggerAction: 'all',
                editable: false,
                emptyText: 'Выберите статус ...',
                width: 100,
                value: view.data.issue.state,
                listeners: {
                    'select': function(c, rec) {
                        view.setState(rec.data.state);
                    }
                }
            }), '-', {
                xtype: 'label',
                text: 'Ссылка: '
            }, ' ', view.bugUri = new Ext.form.TextField({
                width: 200,
                value: view.data.issue.buglink
            }), {
                iconCls: 'ks-icon-save',
                tooltip: 'Установить',
                scope: view,
                handler: view.setBuglink
            }),
            layout: 'form',
            defaults: {
                xtype: 'panel',
                padding: 5,
                autoScroll: true
            },
            items: issueItems
        });
    },

    setValues: function(data) {
        if (!data) return;
        this.data = data;
        this.stateCombo.setValue(this.data.issue.state);
        this.bugUri.setValue(this.data.issue.buglink);
    },

    refresh: function() {
        this.serverCall({
            method: 'Reload',
            waitMessage: 'Обновление ...',
            success: this.setValues
        });
    },

    setBuglink: function() {
        this.serverCall({
            method: 'SetBugTrackerUri',
            waitMessage: 'Установка ...',
            params: [this.bugUri.getValue()],
            success: this.setValues
        });
    },

    setState: function (newState) {
        this.serverCall({
            method: 'SetState',
            waitMessage: 'Установка ...',
            params: [newState],
            success: function() {
                this.data.issue.state = newState;
            }
        });
    },

    openScreenShot: function() {
        this.serverCall({
            method: 'GetScreenShot',
            success: this.openUrl
        });
//        window.open('PlatformHandler.axd?issuescr=2');
//        var iframetag = '<iframe id="issuescr" src="PlatformHandler.axd?issuescr=2" ' +
//            'width="95%" height="95%" marginwidth="10" marginheight="10" ' +
//            'frameborder="1" scrolling="yes" ' +
//            'style="position: absolute; left: 10px; top: 10px;">' +
//            '</iframe>';
//        $(iframetag).appendTo("body");
        //$('#issuescr').remove();
    }
});

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();