﻿EdsSchemaView = KS.extend(BaseSvodView, {});

// ============= COMMON =======================
(function (viewClass) {
    KS.apply(viewClass, {
        
        onTemplateRendered: function () {
            if (!this.data.isNewSchema)
                this.discardChanges();
            this.childViews = [];
            if (!KS.isEmpty(this.deferredAddChildViews)) {
                for (var idx = 0; idx < this.deferredAddChildViews.length; idx++) {
                    this.addChildView(this.deferredAddChildViews[idx]);
                }
                delete this.deferredAddChildViews;
            }

            this.needSaveBudgetTree = false;
        },
        
        closeChildViews: function(){
            if (!Ext.isEmpty(this.childViews)) {
                Ext.each(this.childViews,
                    function(childView) {
                        childView.close();
                    });
            }
            this.childViews = [];
        },

        onSetSavedState: function(saved) {
            var saveBtn = this.getToolbarItem(this.rootPanel, null, 'SAVE');
            if (saveBtn)
                saveBtn.setDisabled(saved);
        },

        saveChanges: function(close) {
            var view = this.parentView || this;
            var options = view.schemaProperties.source;

            var checkedForms = view.formsGrid.getCheckedCodes();

            var budgetCheckedNodes = [];
            if (view.needSaveBudgetTree){
                var budgetTree = view.getBudgetTree();
                if (budgetTree){
                    var checekdNodes = budgetTree.getChecked();
                    Ext.each(checekdNodes, function(node){
                        budgetCheckedNodes.push(node.getId());
                    });
                }
            }

            view.serverCall({
                method: 'SaveSchemaChanges',
                params: [options, checkedForms, view.needSaveBudgetTree, budgetCheckedNodes],
                waitMessage: 'Сохранение...',
                success: function(hasSaveErrors) {
                    if (hasSaveErrors === true) {
                        KS.alert('Схема не сохранена!');
                        return;
                    }
                    view.discardChanges();
                    view.needSaveBudgetTree = false;
                    if (close === true) {
                        view.close();
                    } else {
                        view.reload();
                    }
                }
            });
        },

        resetView: function () {
            this.containerPanel.setTitle(this.data.caption);

            this.levelsGrid.reload();
            this.selectedLevelsGrid.reload();
            this.formsGrid.reload();

            this.refreshBudgetTree();
        },

        loadSchemaProperties: function() { // afterrender schemaPropertiesPanel
            this.serverCall({
                method: 'GetSchemaProperties',
                success: this.addSchemaProperties
            });
        },

        addSchemaProperties: function(settings) {
            if (settings) {
                this.schemaPropertiesPanel.removeAll();
                this.schemaProperties = this.getPropertyGridByOption(settings, "schemaProperties", "Свойства");
                this.schemaProperties.on("propertychange", this.schemaPropertiesChange, this);
                this.schemaPropertiesPanel.add(this.schemaProperties);
            }
        },

        schemaPropertiesChange: function() {
            this.touch();
        },

        schemaTabChange: function(tabPanel, newCard) {
            if (newCard.ctrlId === "budgetTreePanel" &&
                !newCard.budgetTreeLoaded) {
                newCard.budgetTreeLoaded = true;
                this.loadBudgetTree();
            }
        }
    });
}(EdsSchemaView.prototype));

// ============= LEVELS =======================
(function (viewClass) {
    KS.apply(viewClass, {

        levelAdd: function() {
            var view = this.parentView || this;
            var checkedCodes = view.levelsGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                view.serverCall({
                    method: 'LevelAdd',
                    params: [checkedCodes],
                    disableFog: true,
                    success: function(rows) {
                        if (rows) {
                            Ext.each(rows, function(row) {
                                view.selectedLevelsGrid.addRecord(row);
                            });
                            view.touch();
                        }
                    }
                });
            }
        },

        levelDelete: function() {
            var view = this.parentView || this;
            var checkedCodes = view.selectedLevelsGrid.getCheckedCodes();
            var checkedRows = view.selectedLevelsGrid.getCheckedRows();
            if (!Ext.isEmpty(checkedCodes)) {
                view.serverCall({
                    method: 'LevelDelete',
                    params: [checkedCodes],
                    disableFog: true,
                    success: function() {
                        view.selectedLevelsGrid.reload();
                        view.touch();
                    }
                });
            }
        },
        
        editSelectedLevel: function(plugin, context){
            if (context.value == context.originalValue) return false;
            var dataIndex = context.field;
            var closeCode = KS.Grid.getAnyCase(context.record, context.grid.closeCode);
            var view = this;
            this.serverCall({
                method: "EditSelectedLevel",
                disableFog: true,
                params: [context.value, dataIndex, closeCode],
                success: function(){
                    view.touch();
                }
            });
            return true;
        }
    });
}(EdsSchemaView.prototype));

// ============= BUDGET_TREE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        getBudgetTreeView: function(){
            var childView = null;
            Ext.each(this.childViews,
                function(view) {
                    if (view.containerPanel.classInstance.indexOf("BudgetHierarchyView") !== -1)
                        childView = view;
                });
            return childView;
        },

        getBudgetTree: function(){
            var budgetTreeView = this.getBudgetTreeView(); 
            return budgetTreeView ? budgetTreeView.budgetTree : null; 
        },
        
        loadBudgetTree: function(msg) {
            var view = this;
            view.budgetTreePanel.mask(msg || "Загрузка Дерева организаций и бюджетов...");
            view.serverCall({
                method: 'LoadBudgetTree',
                disableFog: true,
                success: function() {
                    view.budgetTreePanel.unmask();
                }
            });
        },

        refreshBudgetTree: function() {
            var activeTab = this.schemaTabPanel.getActiveTab();
            if (activeTab.ctrlId === "budgetTreePanel"){
                // т.к. обновление как в толстом не работает (budgetHierarchyPresenter в презенторе не сохраняется), то
                // делаем полное закрытие дерева и открываем его заново
                this.closeChildViews();
                this.needReloadBudgetHierarchy = true;
            } else {
                activeTab.budgetTreeLoaded = false;
            }            
        },

        budgetHierarchyClosed: function() { // вызывается из BudgetHierarchyView.js onAfterClose
            if (this.needReloadBudgetHierarchy) {
                this.loadBudgetTree('Обновление Дерева организаций и бюджетов...');
                this.needReloadBudgetHierarchy = false;
            }
        },

        checkBudgetTreeNode: function(node, checked) {
            // Если выбрали узлы через кнопки тулбара, то обрабатываем их состояние при сохранении схемы         
            // Если просто один клик, то сразу, без перебора всех узлов
            // Но если всё равно нужно будет перебирать, то нет смысла продолжать обрабатывать по одному
            if (node && !this.needSaveBudgetTree) {
                var nodeId = node.getId();
                var view = this;
                this.serverCall({
                    method: 'CheckBudgetTreeNode',
                    params: [nodeId, checked],
                    disableFog: true,
                    success: function() {
                        view.touch();
                     }
                });
            } else {
                this.touch();
                this.needSaveBudgetTree = true;
            }
        },

        // Добавление вьюшки с деревом
        addChildView: function (panel) {
            if (!this.schemaTabPanel) {
                // Parent view is not ready, render child later
                if (!this.deferredAddChildViews) {
                    this.deferredAddChildViews = [];
                }
                this.deferredAddChildViews.push(panel);
                return true;
            }

            var budgetTree = this.budgetTreePanel;
            //panel.tbar = false;
            panel.header = false;
            if (budgetTree) {
                budgetTree.removeAll();
                budgetTree.add(panel);
                var childView = eval(panel.classInstance);
                if (childView) {
                    this.childViews.push(childView);
                    childView.parentView = this;
                }
                KS.updateLayout(budgetTree);

                return true;
            }

            return false;
        },
        
        onDependentChanged: function () {
            if (KS.isEmpty(this.dependentViews)) return;
            KS.updateLayout(this.containerPanel);
        }
    });
}(EdsSchemaView.prototype));

// ============= FORMS_GRID =======================
(function (viewClass) {
    KS.apply(viewClass, {        
        
        formsCellClick: function() {
            this.touch();
        }
    });
}(EdsSchemaView.prototype));

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();