﻿DictionaryReorganizationView = KS.extend(BaseTreeView, {});

//----MAIN-------
(function (viewClass) {
    KS.apply(viewClass, {
        onSetSavedState: function(saved) {
            var saveBtn = this.getToolbarItem(this.rootPanel, null, 'SAVE');
            if (saveBtn)
                saveBtn.setDisabled(saved);
        },
        
        resetView: function(){
            this.treeGrid.reload();
            this.discardChanges();
        },

        onValuesSelected: function (args) {
            if (Ext.isEmpty(args) || Ext.isEmpty(args[0])) return;
            this.nodesOldGrid.reload();
            this.nodesNewGrid.reload();
            this.touch();
        }
    });
}(DictionaryReorganizationView.prototype));

//----TREE_GRID-------
(function (viewClass) {
    KS.apply(viewClass, {
        
        selectFirstReorganization: function(){
            this.treeGrid.getSelectionModel().select(0);
        },

        selectReorganization: function(elModel, selected){
            if (selected && selected[0]) {
                var view = this;
                var linkReorg = KS.Grid.getAnyCase(selected[0], "LINK_REORGANIZATION");
                view.serverCall({
                    method: 'SelectReorganization',
                    params: [linkReorg],
                    success: function() {
                        view.nodesOldGrid.reload();
                        view.nodesNewGrid.reload();
                    }
                });
            }
        },
        
        deleteHandler: function() {
            var view = this.parentView || this;
            var ccc = view.treeGrid.getCheckedCodes();
            if (Ext.isEmpty(ccc)) return;
            KS.confirm("Будет удалено строк: " + ccc.length + ". Продолжить?", "Подтвердите удаление", function (btn) {
                if (btn === 'yes')
                    view.deleteHandlerInternal(ccc);
            });
        },

        deleteHandlerInternal: function (ccc) {
            var view = this;
            this.serverCall({
                method: 'DeleteReorganization',
                params: [ccc],
                waitMessage: 'Удаление ...',
                success: function(deleted) {
                    if (deleted){
                        view.treeGrid.reload();
                        view.touch();
                    }
                }
            });
        },
        
        newHandler: function(){
            var view = this.parentView || this;
            view.getEditVersionPanel(true, null);
        },
        
        editHandler: function(){
            var view = this.parentView || this;
            var checkedRows = view.treeGrid.getCheckedRows();
            if (!Ext.isEmpty(checkedRows)) {
                var activeRow = checkedRows[0];
                var reorgLink = KS.Grid.getAnyCase(activeRow, view.treeGrid.closeCode);
                view.getEditVersionPanel(false, reorgLink);
            }
        },

        getEditVersionPanel: function(isNew, reorgLink) {
            var view = this;
            view.serverCall({
                method: 'GetEditReorgPanel',
                params: [isNew, reorgLink],
                success: function(settings) {
                    view.showEditReorgPanel(settings, isNew, reorgLink);
                }
            });
        },

        showEditReorgPanel: function(settings, isNew, reorgLink) {
            if (Ext.isEmpty(settings)) return;
            this.propertyGrid = this.getPropertyGridByOption(settings, "propertyGrid", "1. Общие");
            var view = this;
            this.editReorgWin = KS.showModal(this.propertyGrid, {
                title: 'Свойства ' + (isNew ? "новой " : "") + "организации",
                autoHeight: false,
                layout: 'anchor',
                height: 400,
                minHeight: 200,
                width: 600,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->', 
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            if (view.propertyGrid.validate()) {
                                view.doEditReorg(isNew, reorgLink);
                            }
                        }
                    }, 
                    { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.rejectReorgChange(isNew, reorgLink);
                        }
                    }]
            }, true);
        },

        doEditReorg: function(isNew, reorgLink){
            var view = this;
            var newValues = this.propertyGrid.source;
            view.editReorgWin.close();
            view.serverCall({
                method: 'EditReorg',
                params: [newValues, isNew, reorgLink],
                waitMessage: isNew ? 'Создание ...' : 'Редактирование ...',
                success: function () {
                    view.touch();
                    view.treeGrid.reload();
                }
            });
        },

        rejectReorgChange: function(isNew, reorgLink){
            this.editReorgWin.close();
            this.serverCall({
                method: 'RejectReorg',
                params: [isNew, reorgLink],
                waitMessage: 'Отмена...'
            });
        },

        reorgDblClick: function(gridView, record){
            var reorgLink = KS.Grid.getAnyCase(record, gridView.grid.closeCode);
            this.getEditVersionPanel(false, reorgLink);
        },
        
        copyHandler: function(){
            var view = this.parentView || this;
            var checkedRows = view.treeGrid.getCheckedRows();
            if (!Ext.isEmpty(checkedRows)) {
                KS.confirm("Копировать запись?", "Внимание", function (btn) {
                    if (btn === 'yes') {
                        var activeRow = checkedRows[0];
                        var reorgLink = KS.Grid.getAnyCase(activeRow, view.treeGrid.closeCode);
                        view.serverCall({
                            method: 'CopyReorg',
                            params: [reorgLink],
                            success: function () {
                                view.touch();
                                view.treeGrid.reload();
                            }
                        });
                    }
                });                
            }            
        }
    });
}(DictionaryReorganizationView.prototype));

//----NODES_OLD_GRID/NODES_NEW_GRID-------
(function (viewClass) {
    KS.apply(viewClass, {
        
        addOrganization: function(){
            var view = this.parentView || this;
            var checkedCodes = view.treeGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)){
                var type = this.tbarNode.code.indexOf("Old") !== -1 ? 0 : 1;
                view.serverCall({
                    method: 'AddOrganization',
                    params: [checkedCodes[0], type]
                });
            }
        },
        
        deleteOrganization: function(){
            var view = this.parentView || this;
            var type = this.tbarNode.code.indexOf("Old") !== -1 ? 0 : 1;
            
            var checkedCodes = view.treeGrid.getCheckedCodes();
            if (Ext.isEmpty(checkedCodes)) return;
            var treeLink = checkedCodes[0];
            
            var nodesGrid = type === 1 ? view.nodesNewGrid : view.nodesOldGrid;
            if (Ext.isEmpty(nodesGrid)) return;
            var checkedRows = nodesGrid.getCheckedRows();
            if (Ext.isEmpty(checkedRows)) return;
            
            KS.confirm('Исключить выбранные организации?', 'Внимание', function(btn) {
                if (btn === 'yes'){
                    var rowsData = [];
                    Ext.each(checkedRows, function(row){
                        rowsData.push({
                            "LINK_ORGANIZATION" : KS.Grid.getAnyCase(row, "LINK_ORGANIZATION"),
                            "LINK_BUDGET" : KS.Grid.getAnyCase(row, "LINK_BUDGET")
                        });
                    })
                    
                    view.serverCall({
                        method: 'DeleteOrganization',
                        params: [rowsData, treeLink, type],
                        success: function(){
                            nodesGrid.reload();
                            view.touch();
                        }
                    });
                }
            });          
        },
    });
}(DictionaryReorganizationView.prototype));