﻿BudgetsDictionaryView = KS.extend(BaseDictionaryView,
    {
        newHandler: function() {
            var view = this.parentView;
            view.getBudgetGridData("NEW", 0);
        },
        
        editHandler: function() {
            var view = this.parentView;
            var ccc = view.mainGrid.getCheckedCodes(true);
            if (Ext.isEmpty(ccc)) return;
            if (ccc[0]) {
                view.getBudgetGridData("EDIT", ccc[0]);
            }
        },

        getBudgetGridData: function(mode, budgetId) {
            var view = this;
            view.serverCall({
                method: 'GetBudgetGridData',
                waitMessage: 'Открывается ...',
                params: [mode, budgetId],
                success: function(settings) {
                    view.showCreateNewBudget(settings, mode === "EDIT", budgetId);
                }
            });
        },

        showCreateNewBudget: function(settings, isEdit, budgetId) {
            this.propertyGrid = this.getPropertyGridByOption(settings, "propertyGrid", "Общие");
            var view = this;
            this.budgetPanelWin =  KS.showModal(this.propertyGrid, {
                title: 'Свойства',
                autoHeight: false,    
                layout: "anchor",
                height: 400, 
                minHeight: 200,
                width: 600,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.doEditBudget(isEdit, budgetId);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.rejectBudget(isEdit, budgetId);
                        }
                    }]
            }, true);
        },
        
        doEditBudget: function(isEdit, budgetId) {
            var view = this;
            var newValues = this.propertyGrid.source;
            view.budgetPanelWin.mask('Пожалуйста, подождите...');
            view.serverCall({
                method: 'EditBudget',
                params: [newValues, isEdit, budgetId],
                waitMessage: isEdit ? 'Редактрование ...' : 'Создание ...',
                success: function(result) {
                    view.budgetPanelWin.unmask();
                    if (result === true) {
                        view.budgetPanelWin.close();
                        view.mainGrid.reload();
                    }
                }
            });
        },

        rejectBudget: function(isEdit, budgetId) {
            var view = this;
            view.serverCall({
                method: 'RejectBudget',
                params: [isEdit, budgetId],
                waitMessage: 'Отмена...',
                success: function() {
                    view.budgetPanelWin.close();
                }
            });
        },

        propertyGridDblClick: function(gridView, td, cellIndex, record) {
            var propGrid = this;
            var view = this.parentView;
            var sourceConfig = propGrid.sourceConfig[record.id];
            if (!KS.isEmpty(sourceConfig)) {
                switch(sourceConfig.type) {
                    case "boolean":
                        if (!sourceConfig.editor.disabled) {
                            var oldValue = propGrid.source[record.id];
                            var newValue = !oldValue;
                            propGrid.setProperty(record.id, newValue);
                            propGrid.getCellEditor(record, 1).completeEdit();
                        }
                        break;

                    case "dictionSelect":
                        view.budgetTypeEdit(record.id);
                        break;
                }
            }
        },

        budgetTypeEdit: function(propId) {
            var view = this;
            this.serverCall({
                method: 'GetSelectBudgetTypeGrid',
                success: function(selectBudgetTypeGrid) {
                    view.showSelectBudgetType(selectBudgetTypeGrid, propId);
                }
            });
        },

        showSelectBudgetType: function(selectBudgetTypeGrid, propId) {
            if (Ext.isEmpty(selectBudgetTypeGrid)) return;
            var view = this;
            view.selectBudgetTypeGrid = this.createTemplateControl(selectBudgetTypeGrid, "selectBudgetTypeGrid");
            view.selectBudgetTypeWin = KS.showModal(view.selectBudgetTypeGrid, {
                title: 'Выберите значение...',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: Math.max(300, KS.rootViewport.getWidth() / 3),
                height: Math.max(400, KS.rootViewport.getHeight() / 2),
                minHeight: 300,
                minWidth: 400,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.selectBudgetType(propId);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.selectBudgetTypeWin.close();
                        }
                    }]
            }, true);
        },

        selectBudgetType: function(propId) {
            var checkedRows = this.selectBudgetTypeGrid.getCheckedRows();
            if (!Ext.isEmpty(checkedRows)) {
                this.selectBudgetTypeWin.close();
                var newBudgetName = KS.Grid.getAnyCase(checkedRows[0], "CODE");
                this.propertyGrid.setProperty(propId, newBudgetName);
                var linkBudgetType = KS.Grid.getAnyCase(checkedRows[0], "LINK_BUDGET_TYPE");
                this.propertyGrid.source[propId] = linkBudgetType + "_link";
            }
        }
    });

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();