﻿AttributesDictionaryView = KS.extend(BaseDictionaryView,
    {
        newHandler: function() {
            var view = this.parentView;
            view.getAttrEditPanel(true, null);
        },
        
        editHandler: function() {
            var view = this.parentView;
            var ccc = view.mainGrid.getCheckedCodes();
            if (Ext.isEmpty(ccc)) return;
            if (ccc[0]) {
                view.getAttrEditPanel(false, ccc[0]);
            }
        },

        getAttrEditPanel: function(isNew, attrId) {
            var view = this;
            view.serverCall({
                method: 'GetAttrEditPanel',
                waitMessage: 'Открывается ...',
                params: [isNew, attrId],
                success: function(panel) {
                    view.showAttrEditPanel(panel, isNew, attrId);
                }
            });
        },

        onServerTryEditAttribute: function(panel, attrId) {
            this.showAttrEditPanel(panel, false, attrId);
        },

        showAttrEditPanel: function(panel, isNew, attrId) {
            if (Ext.isEmpty(panel)) return;
            this.attrPanel = this.createTemplateControl(panel, "attrPanel");
            this.addPanelItems(panel, this.attrPanel);
            var view = this;
            this.editableAttrId = attrId;
            this.attrPanelWin =  KS.showModal(this.attrPanel, {
                title: 'Редактирование атрибута',
                autoHeight: false,  
                maximizable: false,
                layout: "anchor",
                height: 365, 
                minHeight: 200,
                width: 600,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.doEditAttr(isNew, attrId);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.rejectAttrChanges(isNew, attrId);
                        }
                    }]
            }, true);
        },

        doEditAttr: function(isNew, attrId) {
            var newValues = this.collectAttrEditValue();
            var view = this;
            this.attrPanelWin.mask("Пожалуйста, подождите...");
            this.serverCall({
                method: 'DoEditAttr',
                waitMessage: 'Сохранение ...',
                params: [newValues, isNew, attrId],
                success: function(hasError) {
                    view.attrPanelWin.unmask();
                    if (!hasError) {
                        view.attrPanelWin.close();
                        view.resetGrid();
                    }
                },
                error: view.attrPanelWin.unmask
            });
        },

        collectAttrEditValue: function() {
            return {
                "CODE": this.attrCode.getValue(),
                "NAME_SHORT": this.attrShortName.getValue(),
                "NAME": this.attrName.getValue(),
                "ATTR_TYPE": this.attrType.getValue().attrType,
                "NUMERIC_VALUE": this.attrNumberValue.getValue(),
                "STRING_VALUE": this.attrStringValue.getValue(),
                "LENGTH": this.attrLength.getValue(),
                "TEXT_CHECK": this.textCheckEditor.getValue(),
                "UNI_DICT_ROW": this.attrDictRow.getValue(),
                "LINK_DICTION": this.attrDictName.textField.linkDiction, // UniDictName.Tag
                "DICTION_COL_ORDER": this.attrDictColName.textField.dictionColOrder, // UniDictCol.Tag
                "LINK_DICTION_ROW": this.attrDictRow.textField.linkDictionRow  // UniDictName.Tag
            }
        },

        rejectAttrChanges: function(isNew, attrId) {
            this.attrPanelWin.close();
            this.serverCall({
                method: 'RejectAttrChanges',
                params: [isNew, attrId],
                disableFog: true
            });
        },

        openDictionary: function() {
            var view = this.parentView;
            var attrId = view.editableAttrId;
            var relationId = this.ownerCt.textField.relationId;
            view.serverCall({
                method: 'OpenDictionary',
                params: [relationId, attrId]
            });
        },

        onValuesSelected: function(arg) {
            var values = arg[0][0];
            switch (values["CLOSE_CODE"]) {
                case "LINK_DICTION":
                    this.attrDictName.setValue(values["NAME_SHORT"]);
                    this.attrDictName.textField.linkDiction = values["LINK_DICTION"];

                    this.attrDictColName.setValue("");
                    this.attrDictColName.textField.dictionColOrder = null;

                    this.attrDictRow.setValue("");
                    this.attrDictRow.textField.linkDictionRow = null;
                    break;
                
                case "LINK_DICTION_ROW":
                    this.attrDictColName.setValue(values["ACTIVE_CELL_NAME"]);
                    this.attrDictColName.textField.dictionColOrder = values["DICTION_COL_ORDER"];

                    this.attrDictRow.setValue(values["ACTIVE_CELL_VALUE"]);
                    this.attrDictRow.textField.linkDictionRow = values["LINK_DICTION_ROW"];
                    break;
            }
        }
    });

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();