﻿AssignColumnsView = KS.extend(BaseDictionaryView, {});

(function (viewClass) {
    KS.apply(viewClass, {
        openColumnsDictionary: function () {
            var view = this.parentView,
                checkedCodes = this.colLinks;
            view.colWin = KS.showModal(view.createTemplateControl(view.tpl.controls['colGrid']),
                {
                    title: 'Выбор колонок',
                    autoHeight: false,
                    height: 400,
                    buttonalign: 'right',
                    buttons: new Array({
                        text: 'Выбрать',
                        parentView: view,
                        textField: this,
                        handler: view.setSelectedColumns
                    })
                },
                true);
            view.colGrid.getStore().each(function (rec) {
                var linkCol = rec.get('LINK_COL'),
                    check = checkedCodes.indexOf(linkCol) !== -1;
                view.colGrid.checkRecord(rec, check, true);
            });
        },

        setSelectedColumns: function () {
            var view = this.parentView,
                rows = view.colGrid.getCheckedRows(false),
                colLinks = [],
                text = '';
            Ext.each(rows, function(row) { 
                colLinks.push(view.colGrid.getCloseCode(row));
                text += view.colGrid.getAnyCase(row, 'name') + '; ';
            });
            this.textField.colLinks = colLinks;
            this.textField.setValue(text);
            view.colWin.close(true);
        },

        selected: function () {
            var view = this.parentView || this,
                assignedColumns = {},
                skipTrimColumns = [];
            view.columnsPanel.items.each(function (columnPanel) {
                var dataIndex = columnPanel.ctrlId;
                var editor = columnPanel.getComponent(0);
                var tf = editor.textField;
                assignedColumns[dataIndex] = tf.colLinks.join(',');

                var skipTrimComp = columnPanel.getComponent(1);
                if (skipTrimComp && skipTrimComp.getValue()) {
                    skipTrimColumns.push(dataIndex);
                }
            });
            view.serverCall({
                method: 'Selected',
                params: [assignedColumns, skipTrimColumns]
            });
        }
    });
}(AssignColumnsView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();