function InitFormSign(p) {
    var me = this,
        _signer = me.signer = p.signer,
        _server = me.server = p.server,
        _gui = me.gui = p.gui,
        _fs = me.fs = {};
    
    _fs = {
        loadMask: null,
        progress: null,
        _log: function (msg) {
            console.log(msg);
        },

        checkIsMobileDevice: function () {
            var deviceType = Ext.os.deviceType;
            return deviceType === "Phone" || deviceType === "Tablet";
        },

        checkOS: function () {
            return Ext.isWindows || Ext.isLinux;
        },

        progressBarInit: function (msg, maskTargetId) {
            if (maskTargetId) {
                _fs.closeProgress();
                _fs.loadMask = new ShowLoadMask(msg, maskTargetId);
                _fs.progress = new Ext.ProgressBar({ renderTo: maskTargetId });
            }
        },

        updProgress: function (msg, perc) {
            if (_fs.progress) {
                _fs.progress.updateProgress(perc, Math.round(100 * perc) + "% " + msg);
            }
        },

        updMessage: function (msg) {
            if (_fs.loadMask && msg) {
                _fs.loadMask.msgTextEl.setText(msg);
            }
        },

        closeProgress: function () {
            if (_fs.loadMask) {
                _fs.loadMask.destroy();
                _fs.loadMask = null;
            }
            if (_fs.progress) {
                _fs.progress.destroy();
                _fs.progress = null;
            }
        },

        onError: function (err) {
            if (!err) return;
            ExtUtils.ShowWindow({
                title: "Ошибка подписи документа",
                iconCls: "ks-icon-document_error",
                width: "auto",
                height: "auto",
                html: err
            });
        },

        onSuccess: function (res) {
            ExtUtils.ShowProtocol(res);
        },

        getErrorHandler: function (onError) {
            return function errorHandler(txt) {
                return function (err) { // TODO: тут msg стал приходить сложным объектом, нужно чтото с этим делать
                    _signer.DeleteArchive();
                    _fs.closeProgress();

                    try {
                        if (err && err.hasOwnProperty("IsInformative")) {
                            ShowError(err);
                        } else if (!onError || onError && !onError.call) {
                            onError(txt + ": " + err);
                        }

                        onError && onError.call && onError(err);

                    } catch (e) {
                        console.log(e);
                    }
                };
            };
        },

        FormSign_SignStart: function (p) {
            var signer = new me.Sign(p);
            signer.subscribe();
        },
        convertBlobData: function (blobs, KeyId) {
            return blobs.map(function (blob) {
                return {
                    KeyId: KeyId,
                    Data: blob,
                    IsBinary: true
                };
            });
        },

        //серия запросов на сервер, после каждого запроса вызывается и удаляется функция по порядку
        //в this хранятся параметры
        startSignDocs: function () {
            this.series = [
                _fs.getData,
                _fs.showDataForSign,
                _fs.signData,
                _fs.saveData,
                _fs.showSavedProtocol,
                this.config.onSuccess
            ];
            _fs.getSettings.call(this);
        },

        startSignLocalPrimaryImageBlob: function () {
            this.series = [
                _fs.getData,
                _fs.showDataForSign,
                _fs.signData,
                _fs.saveData,
                this.config.onSuccess
            ];
            _fs.getSettings.call(this);
        },
        
        startSignExportedDocs: function () {
            this.series = [
                _fs.signData.bind(this, this.config.dataForSign),
                _fs.saveData,
                this.config.onSuccess
            ];

            _fs.getSettings.call(this);
        },

        getCertsList: function () {
            this.series = [
                _fs.getData,
                _fs.showDataForSign,
                _fs.signData,
                _fs.saveData,
                this.config.onSuccess
            ];
            _fs.getSettings.call(this);
        },

        getCallback: function (series) {
            return series.splice(0, 1)[0];
        },

        getSettings: function () {
            if (_fs.checkIsMobileDevice()) {
                return ExtAlert("#err#<div style=\"margin-bottom: 4px;\">ЭЦП для Вашей операционной системы не поддерживается.</div> <div><b>OS:</b> " + Ext.os.name + "<br/> <b>Device type:</b> " + Ext.os.deviceType + "</div>");
            }

            if (!_fs.checkOS()) {
                return ExtAlert("#err#<div style=\"margin-bottom: 4px;\">ЭЦП для Вашей операционной системы не поддерживается.</div> <div><b>OS:</b> " + Ext.os.name + "<br/></div>");
            }
            
            var p = this.config,
                callback = _fs.getCallback(this.series),
                errorHandler = _fs.getErrorHandler(p.onError),
                cb = function (ss) {
                    p.settings = ss;
                    callback.call(this);
                };
            _server.GetSettings({
                shadowObjId: p.contId,
                objcode: p.objcode,
                links: p.links,
                objectParameters: p.objectParameters,
                objectParametersForGetData: p.objectParametersForGetData,
                onSuccess: cb.bind(this),
                onError: errorHandler("Ошибка получения настроек")
            });
        },

        getData: function (ss) {
            var p = this.config,
                callback = _fs.getCallback(this.series),
                errorHandler = _fs.getErrorHandler(p.onError);

            if (!p.hideProgress) {
                _fs.progressBarInit("Получение данных для подписи.");
            }

            _server.GetDataForSign({
                shadowObjId: p.contId,
                settings: p.settings,
                onSuccess: callback.bind(this),
                onError: errorHandler("Ошибка получения данных для подписи")
            });
        },

        showDataForSign: function (dataForSign) {
            var p = this.config,
                callback = _fs.getCallback(this.series),
                errorHandler = _fs.getErrorHandler(p.onError);

            _fs.closeProgress();

            if (dataForSign.length > 1) {
                new CryptoModule.DataForSignView({
                    signData: dataForSign,
                    nameField: 'DocNote',
                    textField: 'ViewData',
                    onConfirm: callback.bind(this),
                    onCancel: errorHandler("Отменено пользователем")
                });
                
            } else {
                callback.call(this, dataForSign);
            }
        },

        signData: function (dataForSign) {
            var p = this.config,
                callback = _fs.getCallback(this.series),
                errorHandler = _fs.getErrorHandler(p.onError);

            if (p.isImageSign) {
                var keyId = dataForSign[0].KeyId;
                dataForSign = _fs.convertBlobData(p.blobs, keyId);
            }

            if (p.isGetCertList) {
                dataForSign = [{
                    KeyId: "",
                    Link: "-1",
                    Data: btoa(p.settings.ObjCode)
                }];
            }

            if (!p.hideProgress) {
                _fs.loadMask ? _fs.updMessage("Подпись данных.") : _fs.progressBarInit("Подпись данных.");
            }

            if (p.CertSN) {
                dataForSign.forEach(function(data) {
                    data.KeyId = p.CertSN;
                });
            }

            _fs.FormSign_SignStart({
                settings: p.settings,
                dataForSign: dataForSign,
                isImageSign: p.isImageSign,
                i: 0,
                lastKeyId: "UnknownCert",
                cert: null,
                dataForSave: [],
                onSuccess: callback.bind(this),
                onError: errorHandler("Ошибка подписи данных")
            });
        },

        saveData: function (dataForSave) {
            var p = this.config,
                callback = _fs.getCallback(this.series);

            if (p.isImageSign || p.isGetCertList) {
                _signer.DeleteArchive();
                _fs.closeProgress();
                callback.call(this, p.isGetCertList ? dataForSave[0] : dataForSave);
            } else {
                if (!p.hideProgress) {
                    _fs.updMessage("Сохранение подписей.");
                }
                var errorHandler = _fs.getErrorHandler(p.onError);
                _server.FormSign_SignSave({
                    shadowObjId: p.contId,
                    settings: p.settings,
                    dataForSave: dataForSave,
                    onSuccess: callback.bind(this),
                    onError: errorHandler("Ошибка сохранения подписей")
                });
            }
        },

        showSavedProtocol: function (res) {
            var callback = _fs.getCallback(this.series);
            // Удалим архив сертификатов
            _signer.DeleteArchive();
            _fs.closeProgress();
            if (res && res.error) return;
            callback(res);
        }
        
    };

    me.Sign = function (params) {
        var sign = this,
            _config = sign.config = {},
            errorHandler = _fs.getErrorHandler(params.onError);

        Object.assign(_config, params);

        sign = {
            subscribe: function () {
                var settings = _config.settings,
                    dataForSign = _config.dataForSign,
                    i = _config.i,
                    lastKeyId = _config.lastKeyId,
                    cert = _config.cert,
                    dataForSave = _config.dataForSave,
                    onSuccess = _config.onSuccess || _fs.onSuccess;

                _fs.updProgress("", (1.0 * i) / dataForSign.length);

                if (i < dataForSign.length) {
                    if (dataForSign[i].KeyId != lastKeyId) {
                        _config.lastKeyId = dataForSign[i].KeyId || "";
                        _signer.SelectCertificates({
                            keyId: dataForSign[i].KeyId,
                            filterOid: settings.FilterOid,
                            secretKeyValidity: settings.SecretKeyValidity,
                            issuerFilter: settings.IssuerFilter,
                            numDaysWarnBeforeCertEnd: settings.NumDaysWarnBeforeCertEnd,
                            onSuccess: sign.showSelectCertWindow.bind(sign, dataForSign[i], errorHandler),
                            onError: errorHandler("Ошибка запроса списка сертификатов")
                        });
                    } else {
                        sign.startSignData(dataForSign[i], cert);
                    }
                } else {
                    onSuccess(dataForSave);
                }
            },
            showSelectCertWindow: function (dataForSign, errorHandler, certs, filter) {
                _gui
                    .ShowSelectCertWindowPromise({
                        certs: certs,
                        filterDesc: filter
                    })
                    .then(function (selectedCert) {
                        sign.startSignData(dataForSign, selectedCert);
                    })
                    .catch(function () {
                        _fs.closeProgress();
                        errorHandler("Ошибка отображения списка сертификатов");
                    });
            },
            setSignConfig: function (params) {
                if (!params) {
                    return fs._log("Нет входных параметров для начала подписи документа");
                }
                Object.assign(_config, params);
                return _config;
            },
            doSignData: function () {
                if (_config.data.SignedInfo) {
                    sign.signXml();
                } else if (_config.data.TypeDoc === "IMAGES") {
                    sign.signImage();
                } else if (_config.data.IsBinary) {
                    sign.signBinary();
                } else {
                    sign.signBase64();
                }
            },
            getCurrentSignData: function () {
                var currentSign = _config.dataForSave[_config.i];

                if (!currentSign) {
                    currentSign = {};
                    _config.dataForSave.push(currentSign);
                }

                return currentSign;
            },
            setSignData: function (data) {
                var currentSignData = sign.getCurrentSignData();
                Object.assign(currentSignData, data);
            },
            setSignCertData: function (data) {
                var signData = _config.data,
                    cert = _config.cert,
                    currentSign = sign.getCurrentSignData();

                Object.assign(signData, {
                    Serial: cert.serial,
                    SubjectX500: cert.subjectx500,
                    NotBefore: cert.notbefore,
                    NotAfter: cert.notafter,
                    Certificate: {
                        SubjectID: cert.subjectid,
                        Serial: cert.serial
                    },
                    CertData: cert
                });

                Object.assign(currentSign, signData);

                return data;
            },
            startSignData: function (data, cert) {
                sign.initSign(data, cert);
                if (data.TypeDoc === "IMAGES" && _config.i === 0) {
                    sign.getHash();
                } else {
                    sign.doSignData();
                }
            },
            initSign: function (data, cert) {
                sign.setSignConfig({
                    data: data || {},
                    cert: cert
                });
                sign.setSignCertData();
            },
            getHash: function () {
                _signer.GetHashAlgByCert({
                    certSubj: _config.cert.serial,
                    onSuccess: function (hashAlgOid) {
                        _server.GetDownloadedHash({
                            shadowObjId: ObjX.idContainer,
                            settings: _config.settings,
                            dataForSign: _config.dataForSign,
                            hashAlgOid: hashAlgOid,
                            onSuccess: function (dataForSignHash) {
                                _config.dataForSign = dataForSignHash;
                                _config.data = dataForSignHash[_config.i];
                                sign.doSignData();
                            },
                            onError: errorHandler("Ошибка получения хэша файла")
                        });
                    },
                    onError: errorHandler("Ошибка получения хэша файла")
                });
            },
            onSignEnd: function (signature) {
                if (_config.data.TypeDoc === "IMAGES") {
                    sign.setSignData({
                        Data: ""
                    });
                }
                
                sign.setSignData({
                    signature: signature
                });

                _config.i++;
    
                sign.subscribe();
            },
            signXml: function () {
                _signer.SignXml({
                    xml: _config.data.Data,
                    signedInfo: _config.data.SignedInfo,
                    certSubj: _config.cert.serial,
                    onSuccess: function (resJson) {
                        var res = JSON.parse(resJson);
                        _config.data.Cert = res.cert;
                        _config.data.Hash = res.hash;
    
                        switch (res.cert.signaturealgoid) {
                        case "1.2.643.7.1.1.3.2":
                            _config.data.SignedInfoType =  _config.data.SignedInfoType & 1 | 2;
                            break;
                        case "1.2.643.7.1.1.3.3":
                            _config.data.SignedInfoType =  _config.data.SignedInfoType & 1 | 6;
                            break;
                        default:
                            _config.data.SignedInfoType =  _config.data.SignedInfoType & 1 | 0;
                            break;
                        }
    
                        sign.onSignEnd(res.signature);
                    },
                    onError: errorHandler("Ошибка SignXml")
                });
            },
            signImage: function () {
                _signer.SignHash.B64Data.Sign({
                    data: _config.data.Data,
                    certSubj: _config.cert.serial,
                    onSuccess: sign.onSignEnd,
                    onError: errorHandler("Ошибка SignHash.B64Data.Sign")
                });
            },
            signBinary: function () {
                _signer.Detached.Data.SignBinary({
                    data: _config.data.Data,
                    certSubj: _config.cert.serial,
                    onSuccess: sign.onSignEnd,
                    onError: errorHandler("Ошибка SignHash.B64Data.Sign")
                });
            },
            signBase64: function () {
                _signer.Detached.B64Data.Sign({
                    data: _config.data.Data,
                    certSubj: _config.cert.serial,
                    onSuccess: sign.onSignEnd,
                    onError: errorHandler("Ошибка SignHash.B64Data.Sign")
                });
            },
        };

        return sign;
    };

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Starts PROMISES functions and theirs supports
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    function getAndFilterCertificates(keyId, certFilters) {
        if (certFilters) {
            return _signer.SelectCertificatesPromise({
                keyId: keyId,
                filterOid: certFilters.FilterOid,
                secretKeyValidity: certFilters.SecretKeyValidity,
                issuerFilter: certFilters.IssuerFilter,
                numDaysWarnBeforeCertEnd: certFilters.NumDaysWarnBeforeCertEnd
            });
        } else {
            return _signer.SelectCertificatesPromise({
                keyId: keyId
            });
        }
    }

    function showWindowForUserSelectCertificate(r) {
        return GetSignerGuiMethods().ShowSelectCertWindowPromise({
            certs: r.certs,
            filterDesc: r.filter
        });
    }

    function hashBase64DataArrayBySelectedCert(dataArray, cert) {
        var promises = dataArray.map(function (item, i, arr) {
            return _signer.HashPromise({
                data: item.Data,
                algoid: cert.hashalgoid
            });
        });

        return Promise.all(promises)
            .then(function (hashes) {
                var resultDataset = dataArray.map(function (item, i, arr) {
                    item.Hash = hashes[i];
                    item.Certificate = {
                        Serial: cert.serial,
                        SignatureAlgOid: cert.signaturealgoid,
                        BytesB64: cert.bytesb64
                    };
                    item.Cert = cert.bytesb64;
                    item.Serial = cert.serial;
                    item.SubjectX500 = cert.subjectx500;
                    item.NotBefore = cert.notbefore;
                    item.NotAfter = cert.notafter;
                    return item;
                });

                return resultDataset;
            });
    }

    function signBase64DataArrayBySelectedCert(dataArray, cert) {
        return Promise.resolve(dataArray)
            .then(function (data) {
                var dataImages = data.filter(function (item) {
                    return item.IsOD;
                });

                if (dataImages.length > 0) {
                    // если есть первичка, запросим по ней хэш для подписи
                    return _server.GetDownloadedHash({
                        data: dataImages,
                        hashAlgOid: cert.hashalgoid
                    })
                        .then(function (dataImages) {
                            // чтобы не апдейтить записи, отберем не первичку
                            var dataNotImages = data.filter(function (item) {
                                return !item.IsOD;
                            });

                            // и затем соединим первичку с непервичкой
                            dataImages.forEach(function (item) {
                                dataNotImages.push(item);
                            });

                            // вернем соединенный массив
                            return dataNotImages;
                        });
                } else {
                    // иначе просто пробросим данные дальше
                    return data;
                }
            })
            .then(function (data) {
                var promises = data.map(function (item, i, arr) {
                    if (item.IsOD) {
                        // если картинка, то подпишем хэш в бейс64
                        return _signer.SignHashPromise({
                            data: item.Data,
                            certserial: cert.serial
                        });
                    } else {
                        // если не картинка, то подпишем данные в бейс64
                        return _signer.SignPromise({
                            data: item.Data,
                            certserial: cert.serial
                        });
                    }
                });

                return Promise.all(promises)
                    .then(function (signs) {
                        _signer.DeleteArchive();
                        var resultDataset = data.map(function (item, i, arr) {
                            if (item.IsOD) {
                                item.Data = "";
                            }
                            item.Signature = signs[i];
                            item.Certificate = {
                                Serial: cert.serial,
                                SignatureAlgOid: cert.signaturealgoid
                            };
                            item.Serial = cert.serial;
                            item.SubjectX500 = cert.subjectx500;
                            item.NotBefore = cert.notbefore;
                            item.NotAfter = cert.notafter;
                            return item;
                        });

                        return resultDataset;
                    });
            });
    }

    function signSimpleBase64DataArrayBySelectedCert(dataArray, serial) {
        var promises = dataArray.map(function (item, i, arr) {
            return _signer.SignSimplePromise({
                data: item.Data,
                certserial: serial
            });
        });

        return Promise.all(promises)
            .then(function (signs) {
                _signer.DeleteArchive();
                var resultDataset = dataArray.map(function (item, i, arr) {
                    item.Signature = signs[i];
                    return item;
                });

                return resultDataset;
            });
    }

    function signArrayByCert(array, serial) {
        var promises = array.map(function (item, i, arr) {
            return _signer.SignPromise({
                data: item,
                certserial: serial
            });
        });

        return Promise.all(promises)
            .then(function (signatures) {
                _signer.DeleteArchive();
                return signatures;
            });
    }
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    var Promises = {
        ShowDataForSignAndSign: function (data, certFilters) {
            var arrKeyId = [];
            data.forEach(function(e, i) {
                if (arrKeyId.indexOf(e.KeyId) < 0) {
                    arrKeyId.push(e.KeyId);
                }
            });

            // HACK: используется только первый идентификатор (пока из базы приходит только один)
            return getAndFilterCertificates(arrKeyId[0], certFilters)
                .then(showWindowForUserSelectCertificate)
                .then(function (selectedCert) {
                    // здесь надо скачать хэши картинок если они есть среди подписываемых документов
                    return signBase64DataArrayBySelectedCert(data, selectedCert);
                })
                .then(function (dataForSign) {
                    return {
                        data: dataForSign,
                        objParamsForSave: {
                            //edsSchema: 5
                        }
                    };
                });
        },

        ShowDataForSignAndHash: function (data, certFilters) {
            var arrKeyId = [];
            data.forEach(function(e, i) {
                if (arrKeyId.indexOf(e.KeyId) < 0) {
                    arrKeyId.push(e.KeyId);
                }
            });

            // HACK: используется только первый идентификатор (пока из базы приходит только один)
            return getAndFilterCertificates(arrKeyId[0], certFilters)
                .then(showWindowForUserSelectCertificate)
                .then(function (selectedCert) {
                    return hashBase64DataArrayBySelectedCert(data, selectedCert);
                })
                .then(function (dataForSign) {
                    return {
                        data: dataForSign
                    };
                });
        },

        SignSimple: function (data) {
            var serial;
            data.forEach(function(item, i, arr) {
                if (item.Certificate.Serial && !serial) {
                    serial = item.Certificate.Serial;
                }
            });

            return signSimpleBase64DataArrayBySelectedCert(data, serial)
                .then(function (data) {
                    return {
                        data: data
                    };
                });
        },

        SignUfebsZk: function (base64Xml, serialZk) {
            return signArrayByCert(base64Xml, serialZk)
                .then(function (signatures) {
                    return {
                        signatures: signatures
                    };
                });
        },

        SignUfebsKa: function (base64Xml, serialKa) {
            return signArrayByCert([base64Xml], serialKa)
                .then(function (signatures) {
                    return {
                        xml: base64Xml,
                        signature: signatures[0]
                    };
                });
        }
    };
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    function pingPong(p) {
        /*
         Хранилище параметров и результатов. Все результаты выполнения серверных и клиентских методов склыдываются сюда.
         Для вызова клиентского метода, сначала узнаются названия его параметров и набираются данные из хранилища по названиям параметров.
         После выполнения метода, результат складывается по названиям в хранилище. Тут, если название уже есть, то старое значение затирается.
         Аналогично для серверного (кроме первого) метода, набираются данные для параметров (nextParamNames) метода из хранилища.
         Так же после выполнениня метода, его результат (params) кладется в хранилище.
         */
        var storage = {};

        function args(f) {
            return f.toString().replace(/[\r\n\s]+/g, ' ').
                match(/(?:function\s*\w*)?\s*(?:\((.*?)\)|([^\s]+))/).
                slice(1, 3).
                join('').
                split(/\s*,\s*/);
        }

        function iterate(itPar) {
            itPar.shadowObjId = ObjX.idContainer;

            // вызываем серверный метод
            return _server.CallServerMethod(itPar)
                .then(function (serverResult) {
                    // смотрим что просит вызвать сервер на клиенте
                    var method = Promises[serverResult.method];

                    // если метод на клиенте есть
                    if (typeof method === "function") {
                        // положим результат сервера в хранилище
                        for (var k in serverResult.params) {
                            storage[k] = serverResult.params[k];
                        }

                        // возьмем значения параметров клиентского метода из хранилища
                        var methodParams = args(method).map(function (item) {
                            return storage[item];
                        });

                        // вызовем клиентский метод
                        return method.apply(this, methodParams)
                            .then(function (clientResult) { // клиентский метод отработал, смотрим ...
                                if (serverResult.next) { // есть что вызвать на сервере?
                                    // положим результат клиентского метода в хранилище
                                    for (var k in clientResult) {
                                        storage[k] = clientResult[k];
                                    }

                                    // возьмем значения параметров серверного метода из хранилища
                                    var nextParams = {};
                                    serverResult.nextParamNames.forEach(function (item) {
                                        nextParams[item] = storage[item];
                                    });

                                    return iterate({ // если есть что вызвать на сервере, вызываем и в качестве параметров передаем клиентский результат
                                        method: serverResult.next,
                                        params: nextParams
                                    });
                                } else { // если клиентский метод последний, возвращаем его результат вызывателю
                                    return clientResult;
                                }
                            });
                    } else if (serverResult.method) { // если метод указан, но неизвестен - ругаемся
                        throw "pingpong: unknown method [" + serverResult.method + "]";
                    } else { // если метод не указан, то серверный метод последний, возвращаем его результат вызывателю
                        return serverResult;
                    }
                });
        }

        for (var k in p.params) {
            storage[k] = p.params[k];
        }

        return iterate({
            method: p.method,
            params: p.params
        });
    }

    return {

        SignExportedFiles: function (p) {
            this.config = {
                objcode: p.objCode || ObjX.objCode,
                contId: p.idContainerMain || ObjX.idContainer,
                links: "-1",
                dataForSign: p.dataForSign,
                onSuccess: p.onSuccess ? p.onSuccess.bind(this) : _fs.onSuccess.bind(this),
                onError: p.onError
            };

            _fs.startSignExportedDocs.call(this);
        },

        CancelProgress: function () {
            _fs.closeProgress();
        },

        SignDocs: function (p) {
            this.config = {
                objcode: (p.objcode) ? p.objcode : null,
                contId: ObjX.idContainer,
                CertSN: p.CertSN,
                links: (p.links) ? p.links : null,
                objectParameters: (p.objectParameters) ? p.objectParameters : null,
                objectParametersForGetData: (p.objectParametersForGetData) ? p.objectParametersForGetData : null,
                onSuccess: p.onSuccess ? p.onSuccess.bind(this) : _fs.onSuccess.bind(this),
                onError: p.onError,
                settings: null
            };
            _fs.startSignDocs.call(this);
        },

        SignLocalPrimaryImageBlob: function (p) {
            this.config = {
                blobs: p.blobs || null,
                objcode: "DOCUMENT_MODE_PRIMARY_IMAGE",
                links: "-1",
                onSuccess: p.onSuccess ? p.onSuccess : _fs.onSuccess,
                onError: p.onError,
                contId: ObjX.idContainer,
                isImageSign: true
            };
            _fs.startSignLocalPrimaryImageBlob.call(this);
        },

        SignDocsDel: function (settings) {
            _server.FormSign_Delete(settings);
        },

        GetCertsList: function (p) {
            this.config = {
                objcode: p.objCode || ObjX.objCode,
                contId: p.idContainerMain || ObjX.idContainer,
                links: "-1",
                edsSchema: null,
                hideProgress: true,
                onSuccess: p.onSuccess ? p.onSuccess.bind(this) : _fs.onSuccess.bind(this),
                onError: p.onError,
                isGetCertList: true,
                settings: null
            };

            _fs.getCertsList.call(this);
        },

        StartSign: function (p) {
            return pingPong({
                method: "/Sign/Start",
                params: p
            });
        },

        StartUfebs: function (p) {
            return pingPong({
                method: "/EOD/GetDataForSignZK",
                params: p
            });
        }

    };
}