Ext.define('CryptoModule.DataForSignView', {

    extend: 'Ext.window.Window',

    xtype: 'cm-dataforsignview',

    closeAction: 'destroy',

    title: 'Подписываемые документы',

    height: 680,

    width: 710,

    border: 0,

    modal: true,

    autoShow: true,

    listeners: {
        close: 'onWindowClose',
        beforeshow: 'onWindowBeforeShow'
    },

    buttons: [{
        text: 'ОК',
        handler: 'onOkBtnClick'
    },{
        text: 'Отмена',
        handler: 'onCancelBtnClick'
    }],

    config: {
        signData: null
    },

    controller: {
        onOkBtnClick: function () {
            var result = [],
                view = this.view,
                store = this.getViewModel().getStore('forSign');

            store.each(function (rec) {
                if (rec.get('checked')) {
                    result.push(rec.get('original'));
                }
            });

            view.onCancel = Ext.emptyFn;

            view.onConfirm(result);

            view.close();
        },
        onCancelBtnClick: function () {
            this.view.close();
        },
        onWindowClose: function () {
            this.view.onCancel();
        },
        onWindowBeforeShow: function (view) {
            var count = this.getViewModel().get('forSign').getCount();

            if (!count) {

                view.onCancel = Ext.emptyFn;

                view.onConfirm(view.getSignData());

                view.close();

                return false;
            }
        }
    },

    viewModel: {
        stores: {
            forSign: {
                data: []
            }
        },

        data: {
            selection: null,
        }
    },

    layout: {
        type: 'hbox',
        align: 'stretch'
    },

    defaults: {
        margin: 2,
        border: 1
    },

    items: [{
        xtype: 'grid',
        title: 'Документы',
        hideHeaders: true,
        flex: 1,
        header: {
            padding: '3',
            baseCls: 'x-form-item-label-default',
            style: {
                borderBottom: '1px solid #cecece',
                borderBottomWidth: '1px!important'
            }
        },
        viewConfig: {
            markDirty: false,
            stripeRows: false
        },
        columns: [{
            xtype: 'checkcolumn',
            dataIndex: 'checked',
            cls: 'check-button',
            sortable: false,
            draggable: false,
            autoLock: true,
            lockable: false,
            resizable: false,
            hideable: false,
            menuDisabled: true,
            ignoreExport: true,
            headerWrap: false,
            width: 32,
        }, {
            text: 'Документ',
            dataIndex: 'name',
            flex: 1
        }],
        bind: {
            store: '{forSign}',
            selection: '{selection}'
        }
    }, {
        xtype: 'panel',
        title: 'Данные документа',
        scrollable: true,
        flex: 2,
        bodyPadding: 4,
        header: {
            padding: '3',
            baseCls: 'x-form-item-label-default',
            style: {
                borderBottom: '1px solid black'
            }
        },
        bind: {
            html: '{selection.text}'
        }
    }],

    updateSignData: function (data) {
        var me = this,
            formattedData,
            vm = me.lookupViewModel() || me.viewModel,
            store;

        if (vm && data) {
            formattedData = me.ConvertDataForView(data);

            store = vm.getStore('forSign');
    
            store.setData(formattedData);
    
            vm.set('selection', store.first());
        }

        return data;
    },
    

    onConfirm: Ext.emptyFn,

    onCancel: Ext.emptyFn,

    nameField: '',

    textField: '',

    ConvertDataForView: function (data) {
        var me = this,
            nameField = me.nameField || 'DocNote',
            textField = me.textField || 'ViewData',
            result = [],
            item,
            len = data.length,
            i;

        for (i = 0; i < len; i++) {
            item = data[i];

            if (item[nameField]) {
                result.push({
                    checked: true,
                    name: item[nameField],
                    text: '<pre style="white-space: pre-wrap;">' + Ext.String.htmlEncode(item[textField]) + '</pre>',
                    original: item
                });
            }
            
        }

        return result;
    }

});
