﻿// Страница и методы логина
// Требует System.ConnectManager
// Название проекта читается с web.config, логотип - просто заменяется файл на сервере.
//-----------------------------------------------------------------------------------------------------//
/* eslint white:1, browser:1, devel:1, eqeqeq:0 */
Ext.define("LoginManager", {
    singleton: true,
    formAuth: "/Login/FormAuth",
    certAuth: "/Login/CertAuth",
    esiaAuth: "/Login/EsiaAuth",
    getEsiaOrgInfo: "/Login/GetEsiaOrgInfo",
    checkConnectionOptionName: 'kso_supressShowNoSecureConnectionPage',
    showCert: false,
    showLogin: false,
    //---------- Сохраненные параметры. Чтобы быстро менять куку на ЛС или что другое --------------//
    GetConfig: function(key) {
        return localStorage.getItem(key);
    },
    SetConfig: function(key, value) {
        return localStorage.setItem(key, value);
    },
    LoginByGetQuery: function () {
        var params = {
                dbName: RequestGet("d"),
                dbServer: RequestGet("s"),
                dbType: RequestGet("t") || 0,
                login: RequestGet("u"),
                password: RequestGet("p") || "",
                profile: "",
                rsa: Connection.rsa
            },
            errCount = 0,
            allowEmpty = ["dbType", "password", "profile"];
            
        for (var key in params) {
            if ((allowEmpty.includes(key) && (params[key] === undefined || params[key] === null)) || !allowEmpty.includes(key) && !params[key]) {
                errCount++;
            }
        }

        if (errCount > 0) return this.Launch();

        var panel = Ext.create("Ext.panel.Panel", {
            width: "100%",
            height: "100%",
            renderTo: Ext.getBody()
        });

        AjaxRequest({
            url: "/Login/FormAdminLogin",
            mask: {
                text:"Авторизация",
                id: panel
            },
            params: params,
            success: function (res) {
                panel.destroy();
                LoginManager.ProcessLoginRequest(res);
            }
        });
    },

    setCulture: function (cb, culture) {
        KS.setCookie('culture', culture, new Date().addDays(30));
        window.location.reload();
    },

    PanelLogin: function() {
        //var data = this.parentView.data;
        let view = this.parentView,
            data = view.data;
        return Ext.form.Panel(
            {
                xtype: "form",
                reference: "formLogin",
                itemId: "panelLogin",
                layout: "anchor",
                title: KS.L10n.loginPasswordLabel, //"Логин / пароль",
                border: false,
                referenceHolder: true,
                defaultFocus: "textfield",
                defaultButton: data.useAuthenticationService ? "okButtonOidc" : "okButton",
                defaults:
                    {
                        labelWidth: 88,
                        height: 38,
                        comboboxWidth: 15,
                        anchor: "-22",
                        cls: "login-field",
                        labelSeparator: ""
                    },
                items: [
                    {
                        xtype: "textfield",
                        name: "login",
                        height: 15,
                        allowBlank: false,
                        emptyText: KS.L10n.enterLogin,//"Введите логин",
                        value: this.GetConfig("LoginName"),
                        fieldLabel: KS.L10n.loginLabel, //"Логин",
                        disabled: data.useAuthenticationService
                        //padding: "0px 0px 5px 0px"
                    },
                    {
                        xtype: "textfield",
                        name: "password",
                        height: 15,
                        itemId: "password",
                        emptyText: KS.L10n.enterPassword, //"Введите пароль",
                        inputType: "password",
                        triggers: {
                            forgot: {
                                cls: "ks-forgot" + (data.currentLanguage ? (" ks-forgot-" + data.currentLanguage.culture.substring(0,2).toLowerCase()) : ''),
                                hidden: true,
                                handler: this.RecoveryPassword.bind(this)
                            }
                        },
                        fieldLabel: KS.L10n.passwordLabel, //"Пароль"
                        disabled: data.useAuthenticationService
                    },
                    {
                        xtype: "checkbox",
                        name: "remember-login",
                        hideEmptyLabel: false,
                        boxLabel: KS.L10n.rememberLabel,//"Запомнить меня"
                        disabled: data.useAuthenticationService
                    },
                    {
                        border: false,
                        layout: {
                            type: 'hbox',
                            align: 'middle'
                        },
                        defaults: {
                            border: false,
                            flex: 1
                        },
                        items: [getLangsCombo (data.availableLanguages, data.currentLanguage.culture, view.setCulture, view),
                            {flex: 0.5},
                            {
                                xtype: "button",
                                reference: "okButton",
                                ui: "main-button-ks",
                                formBind: !data.useAuthenticationService,
                                scale: "large",
                                flex: (!data.availableLanguages || data.availableLanguages.length < 2) ? 0.33 : 1,
                                text: KS.L10n.signInLabel, //"Войти",
                                anchor: 0,
                                icon: Connection.rsa + "/images/enter.png",
                                handler: this.LoginForm.bind(this),
                                disabled: data.useAuthenticationService
                            },
                            {
                                xtype: 'button',
                                reference: "okButtonOidc",
                                ui: 'main-button-ks',
                                scale: 'large',
                                margin: '0 0 0 5',
                                width: 38,
                                maxWidth: 93,
                                tooltip: 'Войти через сервис аутентификации',
                                icon: Connection.rsa + "/images/access_set.png",
                                hidden: !data.useAuthenticationService,
                                handler: this.loginOidc.bind(this)
                            }
                        ]
                }],
                listeners: {
                    activate: function() {
                        var lof = this.getForm().findField("login");
                        if (Ext.isEmpty(lof.getValue()))
                            lof.focus();
                        else
                            this.getForm().findField("password").focus();
                    }
                }
            });
    },
    PanelCert: function() {
        return Ext.form.Panel({
            xtype: "form",
            itemId: "panelCert",
            layout: "anchor",
            title: "Сертификат",
            items: [
                {
                    xtype: "combohtml",
                    name: "certs",
                    allowBlank: false,
                    //emptyText: 'Выберите сертификат для входа ---------------->',
                    editable: false,
                    queryMode: "local",
                    displayField: "html",
                    valueField: "serial",
                    multiSelect: false,

                    // typeAhead: true,
                    height: 102,
                    anchor: "0 100%",
                    tpl: Ext.create("Ext.XTemplate",
                        "<ul class=\"x-list-plain\"><tpl for=\".\">",
                        "<li role=\"option\" class=\"x-boundlist-item\"><table><td><img src=\"" + Connection.rsa +  "/images/sertificate32.png\"></img></td><td><b>{subject}</b><br>{serial}<br>Действителен с {notbefore:date(\"d.m.Y\")} по {notafter:date(\"d.m.Y\")}</td></table></li>",
                        "</tpl></ul>"
                    ),
                    // Пока асинхронно грузим
                    value: "Получение списка сертификатов",
                    readOnly: true
                },
                {
                    xtype: "checkbox",
                    name: "remember-cert",
                    boxLabel: "Запомнить выбор сертификата"
                },
                {
                    xtype: "button",
                    formBind: true,
                    scale: "large",
                    text: "Войти",
                    ui: "main-button-ks",
                    handler: this.LoginCert.bind(this, null)
                }
            ]
        });
    },
    PanelEsia: function() {
        return Ext.form.Panel({
            itemId: "panelEsia",
            layout: "fit",
            title: "ЕСИА",
            iconCls: "ks-esia",
            iconAlign: "right",
            html: "Вход ЕСИА",
            listeners: {
                beforeactivate: this.EsiaRedirect.bind(this)
            }
        });
    },
    //---- Восстановление пароля (кнопка)
    RecoveryPassword: function() {
        var login = this.FormLogin.findField("login").getValue();
        if (!login) {
            return ExtAlert("#err#Не указан логин!");
        }
        AjaxRequest({
            url: "/Login/SendPasswordRecoveryMessage",
            success: ExtAlert.bind(null,
                "#msg#На ваш почтовый адрес отправлено письмо с инструкцией по восстановлению пароля"),
            params: {
                login: login,
                rsa: Connection.rsa
            }
        });
    },
    RecoveryPasswordDo: function(uid, aid) {
        AjaxRequest({
            url: "/Login/CheckPasswordRecoveryRequest",
            mlt: "Проверка корректности ссылки",
            success: this.RecoveryPasswordProcess.bind(this),
            params: { uid: uid, aid: aid }
        });
    },
    RecoveryPasswordProcess: function(res, p) {
        if (res.Result != 0)
            return ExtAlert(res.Message);
        res.uid = p.uid;
        res.aid = p.aid;
        this.ChangePassword("link", res, this.Login);
    },
    RecoveryPasswordChangeSuccess: function(login, pass) {
        var _this = this;
        Ext.create("Ext.window.Window", {
            title: KS.L10n.passwordChanged, //"Изменен пароль",
            autoShow: true,
            bodyPadding: 8,
            html: KS.L10n.passwordChngSuccess ,//"Пароль успешно изменен. Можно работать.",
            buttonAlign: "center",
            buttons: [{
                text: KS.L10n.signInLabel , //"Вход в комплекс",
                scale: "medium",
                handler: function(me) {
                    me.up("window").close();
                    _this.Login.call(_this, login, pass);
                }
            }],
            closable: false
        });
    },
    //-------------- Смена пароля --------------------------------------------//
    ChangePassword: function(mode, params, callback) {

        var buttons = [
            {
                xtype: "button",
                reference: "okButton",
                scale: "medium",
                formBind: true,
                width: 120,
                text: "Сменить пароль",
                //anchor: 0,
                handler: this.ChangePasswordDo.bind(this, mode, params, callback)
            }
        ];
            // При восстановлении по гиперссылке, некуда жать отмена
        if (mode !== "link")
            buttons.push({
                xtype: "button",
                width: 61,
                scale: "medium",
                text: "Отмена",
                handler: function() {
                    this.up("window").close();
                }
            });

        var panel = new Ext.form.Panel({
            layout: "anchor",
            border: false,
            referenceHolder: true,
            defaultFocus: "textfield",
            defaultButton: "okButton",
            bodyPadding: "5 10",
            items: [
                {
                    xtype: "panel",
                    border: 0,
                    padding: 0,
                    margin: "0 0 22 0",
                    defaultType: "label",
                    layout: {
                        type: "vbox",
                        align: "stretch"
                    },
                    items: [
                        {
                            html: params.Message || (mode === "login" ? "Необходимо сменить пароль для входа в комплекс" : "Смена пароля")
                        },
                        {
                            hidden: !params.minChars,
                            html: "Пароль должен быть не короче " + params.minChars + " символов"
                        }
                    ]
                },
                {
                    xtype: "panel",
                    border: 0,
                    defaults: {
                        height: 24,
                        margin: "5 0",
                        anchor: "0",
                        labelWidth: 110,
                        minLength: params.minChars,
                        allowBlank: false
                    },
                    layout: {
                        type: "vbox",
                        align: "stretch"
                    },
                    defaultType: "passwordfield",
                    items: [
                        {
                            fieldLabel: KS.L10n.passwordOld, //"Старый пароль",
                            allowBlank: true,
                            hidden: mode !== "user",
                            minLength: 0,
                            itemId: "passOld"
                        }, {
                            fieldLabel: KS.L10n.passwordNew, //"Новый пароль",
                            itemId: "pass1"
                        }, {
                            fieldLabel: KS.L10n.confirm, //"Подтверждение",
                            itemId: "pass2"
                        }
                    ]
                }
            ],
            buttons: buttons
        });
        Ext.create("Ext.window.Window", {
            autoShow: true,
            modal:true,
            closable: mode !== "link",
            resizeable: false,
            layout: "fit",
            title: KS.L10n.passwordChng, //"Смена пароля",
            width: 400,
            items: panel
        });
    },
    ChangePasswordDo: function(mode, params, callback, me) {
        var _this = this;

        var pass1 = me.up("form").down("#pass1").getValue();
        var pass2 = me.up("form").down("#pass2").getValue();
        if (pass1 !== pass2)
            return ExtAlert("#msg#Пароли не совпадают!");

        if (mode === "link") {
            return AjaxRequest({
                url: "/Login/SavePasswordRecovery",
                success: function(res) {
                    if (res.Result < 0)
                        return ExtAlert(res.Message);
                    me.up("window").close();
                    _this.RecoveryPasswordChangeSuccess(params.login, pass1);
                },
                params: {
                    uid: params.uid,
                    aid: params.aid,
                    login: params.login,
                    pass: pass1
                }
            });                
        }

        var login = "", password = "";
            
        if (mode === "login") {
            login = this.FormLogin.findField("login").getValue();
            password = this.FormLogin.findField("password").getValue();
        }

        if (mode === "user") {
            password = me.up("form").down("#passOld").getValue();
        }

        AjaxRequest({
            url: "/Login/ChangePassword",
            success: function(res) {
                me.up("window").close();
                _this.ChangePasswordProcess.call(_this, callback, login, pass1, mode, res);
            },
            params: {
                login: login,
                newPass: pass1,
                oldPass: password,
                mode: mode
            }
        });
    },
    ChangePasswordProcess: function(callback, login, password, mode, res) {
        if (res.Result == 0) {
            if (mode === "user")
                ExtAlert("#msg#Пароль успешно изменен!");
            if (callback)
                return callback.call(this, login, password);
            return;
        }
        ExtAlert(res.Message);
    },
    //----------------- 1. Вход по имени и паролю ----------------------------//
    LoginForm: function () {
        if (arguments[1] && arguments[1].target.name == "login") {
            this.FormLogin.findField("password").focus();
            return false;
        }
        var login = this.FormLogin.findField("login").getValue();
        var password = this.FormLogin.findField("password").getValue();
        var rem = this.FormLogin.findField("remember-login").getValue();
        if (rem) {
            this.SetConfig("LoginName", login);
        }
        this.SetConfig("LoginType", "form");
        this.Login(login, password);
    },
    Login: function(login, password) {
        var p = {
            url: this.formAuth,
            success: this.ProcessLoginRequest.bind(this),
            params: {
                login: login,
                password: password,
                rsa: Connection.rsa
            }
        };
        if (this.LoginHolder)
            p.mask = { text: KS.L10n.authMsg, id: this.LoginHolder };
        else
            p.mlt = KS.L10n.authMsg;

        AjaxRequest(p);
    },
    //---------------------- 2.Сертификаты -----------------------------------//
    // Получение списка
    BindCert: function() {
        var _this = this;
        Signer.SelectCertificates({
            onSuccess: function(certs) {
                if (!_this.FormCert || _this.FormCert.destroyed) {
                    //delete _this;
                    return;
                }
                var cmb = _this.FormCert.findField("certs");
                if (certs == null) return;
                certs.forEach(function(el) {
                    el.html = Ext.String.format(
                        "<table width=\"100%\"><td width=\"47px\" valign=\"top\" style=\"padding-top: 5px;\"><img src=\"" + Connection.rsa +  "/images/sertificate32.png\"></img></td><td><b>{0}</b><br>{1}<br>Действителен с {2:date(\"d.m.Y\")} по {3:date(\"d.m.Y\")}<br>{4}</td></table>",
                        el.subjectx500.FIO,
                        el.serial,
                        el.notbefore,
                        el.notafter,
                        el.subjectx500.O);
                });

                var store = Ext.create("Ext.data.Store",
                    {
                        data: certs
                    });
                cmb.setStore(store);
                cmb.setReadOnly(false);
                // Взять из локала
                var certId = _this.GetConfig("LoginCert");
                cmb.setValue(certId);
            },
            onError: function(err) {
                console.error(err);
                ExtAlert("#err#Ошибка Signer.SelectCertificate. "+err);
            }
        });
    },
    // Вход по серийнику
    LoginCert: function(cert) {
        cert = cert || this.FormCert.findField("certs").getValue();
        //var password = this.FormCert.findField("password").getValue();
        var rem = this.FormCert.findField("remember-cert").getValue();
        if (rem) {
            this.SetConfig("LoginCert", cert);
        }
        this.SetConfig("LoginType", "cert");
        if (cert.indexOf("#") !== 0)
            cert = "#" + cert;

        Signer.Detached.Data.Sign({
            data: "login",
            certSubj: cert,
            onSuccess: this.LoginCertBin.bind(this),
            onError: function(err) {
                console.error(err);
                ExtAlert("#err#Ошибка SignHash.Data.Sign. Вероятно отсутствует носитель или неверный пароль.");
            }
        });
    },
    // Вход по подписанной строке
    LoginCertBin: function(hash) {
        AjaxRequest({
            url: this.certAuth,
            mask: {text: KS.L10n.authMsg, id: this.LoginHolder},
            success: this.ProcessLoginRequest.bind(this),
            params: {
                hash: hash,
                rsa: Connection.rsa
            }
        });
    },
    //---------------------- 3. ЕСИА ----------------------------------------//
    GetEsiaOrgInfo: function (requestId) {
        AjaxRequest({
            url: this.getEsiaOrgInfo,
            mlt: "Запрос информации об организациях пользователя",
            scope: this,
            success: function (url) {
                if (!url) {
                    this.LoginEsia.call(this, requestId);
                }
                else {
                    document.location = url;
                }
            },
            params: {
                requestId: requestId,
                rsa: Connection.rsa
            }
        });
    },
    LoginEsia: function (requestId) {
        AjaxRequest({
            url: this.esiaAuth,
            mlt: "Вход в прикладной комплекс",
            success: this.ProcessLoginEsia.bind(this),
            params: {
                requestId: requestId,
                rsa: Connection.rsa
            }
        });
    },
    ProcessLoginEsia: function(info) {
        if (!info || !info.key || !info.data) {
            return ExtAlert("#crit#Не удалось получить инофрмацию о пользователе. Возможно ошибка конфигурации сервера.");
        }
        // Глобальный объект
        window.EsiaInfo = info;

        this.ProcessLoginRequest.call(this, info.data.loginResult);
    },
    EsiaRedirect: function() {
        if (!window.PageParams) return;
            
        if (PageParams.modal)
            return ExtAlert(
                "#crit#Невозможна контекстная авторизация в ЕСИА. Необходимо заново зайти в комплекс.");
        var esiaUrl =  Connection.Info.EsiaAuthURL;
        if (!esiaUrl)
            return ExtAlert(
                "#crit#Ошибка перехода в ЕСИА. Текущий адрес не предоставлен!\r\nВозможные причины - Не указан или не доступен сервис авторизации");

        if (esiaUrl.Result) {
            ExtAlert(Ext.String.format(
                "#{0}#Ошибка перехода в ЕСИА. Сервис авторизации вернул ошибочные данные: <br><br>{1}",
                Connection.Info.AuthorizationType == 5
                    ? "err"
                    : "crit",
                esiaUrl.Message));
            return false;
        }
            
        document.location = esiaUrl;
        return false;
    },

    //---------------------- OpenIdConnect --------------------------------------//
    loginOidc() {
        window.location.replace(_all.rsa + '/OpenIdConnect/SignIn');
    },

    // ---------------------- Комплексы --------------------------------------//
    GetAvailableComplex: function() {
        // Получение сведений о доступных комплексах
        AjaxRequest({
            url: "/Login/GetAvailableComplex",
            mlt: this.LoginHolder ? null : "Проверка доступных комплексов",
            mask: this.LoginHolder ? { text: "Проверка доступных комплексов", id: this.LoginHolder } : null,
            success: this.ProcessComplexRequest.bind(this)
        });
    },
    ProcessComplexRequest: function (complex) {
        if (complex.Mask && complex.RememberSelection) {
            return this.ProcessComplexLogin(complex.Mask, true);
        }
        // Если комплекс до этого не выбирался, но он один
        if (complex.Items.length === 1) {
            var exp = complex.Items[0].Id;
            complex.Mask = Math.pow(2, exp);
            return this.ProcessComplexLogin(complex.Mask, true);
        }
        if (complex.Items.length === 0)
            return ExtAlert("Нет доступных комплексов для работы данного пользователя!");

        // Рисуем окно выбора
        var store = Ext.create("Ext.data.Store", { data: complex.Items });
        var grid = Ext.create("Ext.grid.Panel", {
            flex: 1,
            itemId: "grid",
            hideHeaders: true,
            store: store,
            columns: {
                items: [
                    { xtype: "checkcolumn", width: 30, dataIndex: "Allow" },
                    {
                        text: "Комплекс",
                        dataIndex: "Name",
                        flex: 1
                    }
                ],
                defaults: {
                    sortable: false,
                    hideable: false,
                    menuDisabled: true
                }
            }
        });
        var buttons = Ext.clone(_formBTSave2);
            
        var w = Ext.create("Ext.window.Window",
            {
                //layout: 'fit',
                width: 350,
                title: "Выбор комплексов",
                modal: true,
                autoShow: true,
                bodyPadding: "6 7",
                referenceHolder: true,
                defaultFocus: 0,
                defaultButton: "SaveButton",
                items: [
                    grid,
                    {
                        xtype: "checkbox",
                        id: "rememberComplex",
                        boxLabel: "Более не показывать при входе",
                        value: complex.RememberSelection
                    }
                ],
                buttons: buttons
            });

        grid.Save = this.SaveComplexSelected.bind(this, w, grid);
    },
    SaveComplexSelected: function(w, grid) {
        var remember = w.child("#rememberComplex").getValue();
        var store = grid.getStore();
        var mask = 0;
        store.each(function(rec) {
            var exp = rec.get("Id");
            mask += Math.pow(2, exp);
        });

        w.destroy();
        this.ProcessComplexLogin(mask, remember);
    },
    ProcessComplexLogin: function(mask, remember) {
        AjaxRequest({
            url: "/Login/LicenseConnect",
            params: {
                mask: mask,
                remember: remember
            },
            success: this.FinishAuthorization.bind(this)
        });
    },
    // ---------------------- Завершение ---------------------------------------//
    // Первичная обработка результата авторизации
    ProcessLoginRequest: function(res) {
        if (res.Result < 0) {
            return ExtAlert(res.Message);
        }
        if (res.Result == 1) {
            // Необходимо сменить пароль
            this.ChangePassword("login", { minChars: res.Code, Message: res.Message }, this.Login);
            return;
        }
        this.GetAvailableComplex();
    },
    // Все успешно. Обработка
    FinishAuthorization: function(res) {
        if (!res) {
            return ExtAlert("Неизвестная ошибка авторизации.");
        }
        if (res.Result < 0) {
            return ExtAlert(res.Message);
        }
        var win = this.win,
            idbInit = function () {
                win && win.close && !win.destroyed && win.close();
                
                WebProject.Cache = {};
                // Версия IDB равна версии патча сервера. В результате у нас идет автоудаление баз, если накатили патч
                var dbPatchVersion = WebProject.Info.DBVersion.split(".").pop();
                IDB.SetDBVersion(dbPatchVersion);
                // Сюда перейдем с очисткой стека
                setTimeout(WebProject.Show.bind(WebProject), 0);
            
            };

        // Инициализация. Там можно прописать различные ветвления на разные скины и комлексы
        WebProject = new WebProjectInit(idbInit);
    },
    // ---------------------- -------------------------------------------------//
    GetNews: function() {
        AjaxRequest({
            url: "/Login/GetNews",
            success: this.ShowNews.bind(this)
        });
    },
    ShowNews: function(res) {
        if (!this.win || !this.win.down || this.win.destroyed)
            return;
        var p = this.win.down("#news");
        if (!p) return;
        p.removeAll();
        if (!res || res.length === 0) {
            p.add({
                html: "Новостей нет."
            });
            return;
        }
        res.forEach(function(msg) {
            var html = Ext.String.format("<span class=\"login-news-date\">{0:date(\"d.m.Y H:i:s\")}</span>{1}", msg.Date, "");
            if (msg.State == 2)
                html += "<span class='login-news-important'>ВАЖНО</span>";
            html += "<br>";
            if (!Ext.isEmpty(msg.Theme)) {
                html += "<b>" + msg.Theme + "</b><br>";
            }
            html += msg.Body;
            p.insert(0,
                {
                    html: html
                });
                
        });

    },
    GetLogoPanel: function() {
        return  Ext.create("Ext.panel.Panel", {
            layout: {
                type: "absolute"
            },
            height: 93,
            width: "100%",
            cls: "login-logo",
            items: [
                {
                    xtype: "label",
                    x: 78,
                    y: 55,
                    cls: "login-version",
                    text: Connection.Info.Version
                }
            ]
        });
    },

    CheckProtocol: function () {
        var location = window.location,
            protocol = location.protocol,
            hostname = location.hostname;

        return protocol === 'http:' && hostname !== 'localhost';
    },

    ShowNoSecureConnectionPage: function (params) {
        var me = this;

        Ext.create('Core.NoSecureConnectPage', {
            renderTo: Ext.getBody(),
            width: '100%',
            height: '100%',
            onContinueLinkClick: function () {
                params.supressProtocolCheck = true;

                me.Launch(params);

                this.destroy();
            },
            onBackBtnClick: function () {
                history.back();
            },
            onRemeneberCheckboxChange: function (el, value) {
                localStorage.setItem(me.checkConnectionOptionName, value);
            }
        });
    },

    // Функция строящая форму в зависимости от данных в Connection.AuthorizationType
    Launch: function(params) {
        if (!params)
            params = {};
        window.PageParams = params;
        
        if (localStorage.getItem(this.checkConnectionOptionName) !== 'true' && !params.supressProtocolCheck) {
            var isNoSecure = this.CheckProtocol();
    
            if (isNoSecure) {
                return this.ShowNoSecureConnectionPage(params);
            }
        }

        var protocol = window.location.protocol;
        if (protocol === "http:" && window.location.hostname !== 'localhost') {
            // Выдать предупреждение
            //TODO #bug 117929
        }
        // Лого
        this.LogoPanel = this.GetLogoPanel();
        var requestId;
        // Получили информацию по пользователю
        if (params.mode === "AuthEsiaSaml") {
            requestId = RequestGet("esia_saml_request");
            history.pushState(null, null, Connection.rsa);
            return this.LoginEsia.call(this, requestId);
        }
        if (params.mode === "AuthEsiaOpenIdUser") {
            requestId = RequestGet("esia_token_request");
            if (!requestId)
            {
                requestId = RequestGet("esia_code_request");
                if (requestId)
                {
                    history.pushState(null, null, Connection.rsa);
                    return this.LoginEsia.call(this, requestId);
                }
            }
            history.pushState(null, null, Connection.rsa);
            return this.GetEsiaOrgInfo.call(this, requestId);
        }
        //  Получили информацию по организациям
        if (params.mode === "AuthEsiaOpenIdOrgs") {
            requestId = RequestGet("esia_token_request");
            history.pushState(null, null, Connection.rsa);
            return this.LoginEsia.call(this, requestId);
        }

        // Восстановление пароля
        // http://localhost:63208?pg=recoverypassword&uid=890920998&aid=eot7n97hyuxj61r4aow9ygj5zo
        if (params.mode === "recoverypassword") {
            var uid = RequestGet("uid");
            var aid = RequestGet("aid");
            history.pushState(null, null, Connection.rsa);
            return this.RecoveryPasswordDo(uid, aid);
        }
        // Админский режим
        if (params.mode === "admin") {
            return Ext.create("Admin.LoginAdmin");
        }

        if (params.mode === "login") {
            return this.LoginByGetQuery();
        }

        // Массив панелей
        var logins = [],
            info = Connection.Info;
    
        if (info.hasLoginBtn) {
            this.showLogin = true;
            logins.push(this.PanelLogin());
        }

        if (info.hasCertBtn) {
            this.showCert = true;
            logins.push(this.PanelCert());
        }

        if (info.hasEsiaBtn) {
            this.showEsia = true;
            logins.push(this.PanelEsia());
        }

        // Вход по сертификату без подтверждения
        // if (authorizationType == "2") {
        //     var certId = this.GetConfig("LoginCert");
        //     if (certId)
        //         return this.LoginCert(certId);
        //     // Иначе вывести
        // }
        
        var items = [];

        // Квадрат логина
        var LoginContainer = {
            itemId: "LoginHolder",
            layout: "vbox",
            width: 425,
            height: 360,
            border: 0,
            cls: "login-box",
            defaults: {
                bodyPadding: "22 21",
                border: false
            },
            items: [
                this.LogoPanel,
                {
                    xtype: "tabpanel",
                    ui: "login-tabs-ks",
                    width: "100%",
                    tabBar: {
                        height: 47,
                        border: false
                    },
                    defaults: {
                        border: false
                    },
                    items: logins
                }
            ]
        };
        items.push(LoginContainer);
        // Остальное
        if (!params.modal) {
            items.push({
                border: false,
                width: 425,
                cls: "login-footer",
                html: KS.L10n.developedBy + new Date().getFullYear() + KS.L10n.rightsReserved
            });
            // Уведомления
            if (Connection.Info.LoginInfoTxt) {
                var stickers = [];

                var msgs = Ext.decode(Connection.Info.LoginInfoTxt, true);
                if (!msgs)
                    msgs = [Connection.Info.LoginInfoTxt];

                msgs.forEach(function(msg) {
                    stickers.push({
                        cls: "login-message " +
                            (msg.type ? "login-message-" + msg.type : "login-message-warning"),
                        html: msg.html ? msg.html : msg
                    });
                });

                items.push({
                    xtype: "panel",
                    border: false,
                    scrollable: true,
                    anchor: "0 -10",
                    width: 425,
                    defaults: {
                        margin: "0 0 8 0"
                    },
                    items: stickers
                });

            }
        }
        var panels = items;
        if (Connection.Info.LoginNewsShow) {
            this.GetNews();
            panels = {
                xtype: "panel",
                border: false,
                layout: "hbox",
                defaults: {
                    border: false,
                    margin: 30
                },
                items: [
                    {
                        flex: 1,
                        layout: "vbox",
                        items: items
                    },
                    {
                        layout: "vbox",
                        width: 570,
                        maxHeight: window.innerHeight - 150,
                        defaults: {
                            border: false,
                            width: "100%"
                        },
                        items: [
                            {
                                html: "Новости",
                                bodyCls: "login-news-title",
                                margin: "0 0 0 0"
                            },
                            {
                                itemId: "news",
                                layout: "vbox",
                                defaults: {
                                    bodyCls: "login-news",
                                    width: "100%",
                                    border: false,
                                    margin: "14 0"
                                },
                                items: [
                                    {
                                        html: "Загрузка новостей..."
                                    }]
                            }
                        ]
                    }]
            };
        }

        this.win = Ext.create("Ext.window.Window",
            {
                layout: "anchor",
                flex: 1,
                cls: "shadow-window",
                y: Connection.Info.LoginNewsShow ? 75 : void 0,
                shrinkWrapDock: true,
                autoShow: true,
                header: false,
                closable: false,
                resizable: false,
                border: false,
                shadow: false,
                frame: false,
                modal: params.modal,
                items: panels
            });
        if (this.win.y < 0)
            this.win.setY(75);

        this.LoginHolder = this.win.down("#LoginHolder");

        if (this.showCert) {
            this.BindCert.call(this);
            this.FormCert = this.win.down("#panelCert").getForm();
        }

        if (this.showLogin) {
            this.FormLogin = this.win.down("#panelLogin").getForm();
            if (Connection.Info.AllowRecoveryPassword) {
                var field = this.FormLogin.findField("password");
                field.getTrigger("forgot").show();
            }
        }

        var lt = this.GetConfig("LoginType");
        var tp = this.win.down("tabpanel");
        if (lt === "form" && this.showLogin)
            tp.setActiveTab(tp.child("#panelLogin"));
        if (lt === "cert" && this.showCert)
            tp.setActiveTab(tp.child("#panelCert"));
    }
});