﻿//---------------------------------------------------------------------------------------------
// constructor
MessageGroupView = function(viewID) {
    Ext.QuickTips.init();
    MessageGroupView.superclass.constructor.call(this, viewID);
};

//---------------------------------------------------------------------------------------------
//
KS.extend(MessageGroupView, KS.Ext.ClientView, {
    onInit: function() {
        var me = this;

        var toolbar = new Ext.Toolbar({
            enableOverflow: true,
            items: [{
                iconCls: 'ks-icon-message_new',
                text: KS.L10n.create,
                tooltip: KS.L10n.newMail,
                handler: function(s, e) {
                }
            }, {
                iconCls: 'ks-icon-refresh',
                text: KS.L10n.checkMail,
                tooltip: KS.L10n.checkMail,
                handler: function(s, e) {
                    me.serverCall.apply(me, [{
                        method: 'RefreshMessages',
                        success: function(data) { me.updateFolderProps(data); }
                    }]);
                }
            }]
        });

        me.folders = new Ext.tree.TreePanel({
            border: false,
            autoScroll: true,
            header: false,
            collapsible: false,
            collapsed: false,
            rootVisible: false,
            tbar: toolbar,
            root: new Ext.tree.TreeNode({ expanded: true })
        });

        me.folders.root.appendChild(
            new Ext.tree.TreeNode({
                id: 'Inbox',
                text: KS.L10n.inbox,
                leaf: true,
                iconCls: 'ks-icon-inbox',
                listeners: {
                    'click': function () {
                        me.serverCall.apply(me, [{
                            method: 'OpenMessageList',
                            params: ['Inbox']
                        }]);
                    }
                }
            })
        );
        me.folders.root.appendChild(
            new Ext.tree.TreeNode({
                id: 'Outbox',
                text: KS.L10n.sentMessages,
                leaf: true,
                iconCls: 'ks-icon-outbox',
                listeners: {
                    'click': function () {
                        me.serverCall.apply(me, [{
                            method: 'OpenMessageList',
                            params: ['Outbox']
                        }]);
                    }
                }
            })
        );
        me.folders.root.appendChild(
            new Ext.tree.TreeNode({
                id: 'Drafts',
                text: KS.L10n.drafts,
                leaf: true,
                iconCls: 'ks-icon-drafts',
                listeners: {
                    'click': function () {
                        me.serverCall.apply(me, [{
                            method: 'OpenMessageList',
                            params: ['Drafts']
                        }]);
                    }
                }
            })
        );

        me.renderToParent(me.folders);
        me.updateFolderProps(me.data);
    }, // onInit

    updateFolderProps: function(props) {
        var node;

        node = this.folders.getNodeById('Inbox');
        if (props.Inbox > 0)
            node.setText('<b>Входящие&nbsp;<font color="Blue">(' + props.Inbox + ')</font></b>');
        else
            node.setText(KS.L10n.inbox);

        node = this.folders.getNodeById('Outbox');
        if (props.Outbox > 0)
            node.setText('<b>Отправленные&nbsp;<font color="Blue">(' + props.Outbox + ')</font></b>');
        else
            node.setText(KS.L10n.sentMessages);
    },

    onReloadData: function() {
    }
});
// Ext.extend
