﻿(function() {
    Ext.define('KS.Ext.RichEditFrame', {
        extend: 'Ext.panel.Panel',
        alias: 'richedit.frame',
        loadMask: 'Загрузка...',
        richedit: null,
        iframeHtml: null,
        parentView: null,
        listeners: {
            documentloaded: 'onDocumentLoaded',
            documentchanged: 'onDocumentChanged'
        },

        constructor: function(cfg, ctrl) {
            var richEditFrame = this;

            richEditFrame.ksObjs = {};
            KS.apply(richEditFrame,
                KS.apply(cfg || {}, ctrl ? ctrl.json : null),
                {
                    isTpl: true,
                    plugins: []
                });

            if (richEditFrame.layout === 'box') {
                richEditFrame.layout = {
                    type: 'box',
                    pack: 'center',
                    align: 'center'
                };
            }

            if (ctrl && ctrl.ui) {
                richEditFrame.ui = ctrl.ui;
            }

            KS.Ext.RichEditFrame.superclass.constructor.call(richEditFrame);
        },

        controller: {
            onDocumentLoaded: function (s, e) {
                var me = this.view;
                if (me.parentView && me.parentView.onRichEditDocumentLoaded) {
                    me.parentView.onRichEditDocumentLoaded(me.isFirstDocumentLoad);
                }
                if (!me.isFirstDocumentLoad) {
                    me.documentHasChanges = true;
                }
                me.isFirstDocumentLoad = false;
            },

            onDocumentChanged: function (s, e) {
                var me = this.view;
                me.documentHasChanges = true;
                if (!me.isFirstDocumentLoad && me.parentView && me.parentView.onRichEditDocumentChanged)
                    me.parentView.onRichEditDocumentChanged(s, e);
            }
        },

        initRichEdit: function (richEdit, parentView) {
            this.richEdit = richEdit;
            this.parentView = parentView;
            this.iframeHtml = document.getElementById(`richedit_frame_${parentView.viewID}`);
            this.isFirstDocumentLoad = true;
        },

        hasChanges: function () {
            return this.documentHasChanges !== undefined ? this.documentHasChanges : false;
        },

        discardChanges: function() {
            this.documentHasChanges = false;
        },

        setFrameProperties: function (html) {
            var id = html.split('id="')[1].split('"')[0];
            var src = html.split('src="')[1].split('"')[0];

            this.iframeHtml.id = id;
            this.iframeHtml.src = src;
        },

        reloadFrame: function () {
            if (this.iframeHtml) {
                this.isFirstDocumentLoad = true;
                this.iframeHtml.contentWindow.location.reload(true);
            }
        },

        exportToBase64: function () {
            var base64Value = this;
            this.richEdit.exportToBase64(function (base64) {
                base64Value = base64;
            });
            return base64Value;
        }
    });

    function createRichEditFrame(ctrl, cfg) {
        KS.apply(cfg,
            {
                ctrl: ctrl
            });
        var richEditFrame = new KS.Svod.RichEditFrame(ctrl, cfg);
        KS.Ext.setTemplateListeners(richEditFrame, ctrl.listeners, ctrl.parentView);
        return richEditFrame;
    }

    KS.Ext.registerControlRenderer('richEditFrame', createRichEditFrame);
})();