////////////////////////////////////////////////////////////////////////////////
// Viewport tools
KS.apply(KS, {
    dialogViewport: {},
    groupViewport: [],
    tabViewport: [],
    rootViewport: null,
    ajaxResultQueue: [],

    processDialogPanel: function(/*panelId*/) {
    },
    processTabPanel: function(/*panelId*/) {
    },
    processGroupPanel: function(/*panelId*/) {
    },
    processHostPanel: function(/*panelId*/) {
    },

    pageLoadedEventHandler: function(sender, args) {
        var updatedPanels = args.get_panelsUpdated();

        var r = 'Received panels content: ';
        var delim = '';
        for (var d = 0; d < updatedPanels.length; d++) {
            r += delim + updatedPanels[d].id;
            delim = ', ';
        }
        KS.log(r, 'update');

        for (var index = 0; index < updatedPanels.length; index++) {
            var panelId = updatedPanels[index].id;
            KS._syncPanel(panelId);
        }

        KS.stopWaiting.apply(KS);
        KS.queueExecuteActions(null);
    },

    _syncPanel: function(panelId) {
        var removePanelUpdate = function(container, slot) {
            for (var n = 0; n < KS.ajaxResultQueue.length; n++) {
                var task = KS.ajaxResultQueue[n];
                if (task.action != 2) continue;
                if (task.container != container || task.slot != slot) continue;
                KS.ajaxResultQueue.splice(n, 1);
            }
        };

        var s;
        if (panelId.indexOf("tab_panel_") == 0) {
            s = parseInt(panelId.substring(10), 10);
            removePanelUpdate(1, s);
            KS.processTabPanel(panelId);
        } else if (panelId.indexOf("group_panel_") == 0) {
            s = parseInt(panelId.substring(12), 10);
            removePanelUpdate(2, s);
            KS.processGroupPanel(panelId);
        } else if (panelId.indexOf("dialog_panel_") == 0) {
            s = parseInt(panelId.substring(13), 10);
            removePanelUpdate(3, s);
            KS.processDialogPanel(panelId);
        } else {
            for (var a = 0; a < KS.ajaxResultQueue.length; a++) {
                var t = KS.ajaxResultQueue[a];
                if (t.action != 2 && t.container != 6) continue;
                if (!('params' in t) || t.params[0] != panelId) continue;
                KS.ajaxResultQueue.splice(a, 1);
            }
            KS.processHostPanel(panelId);
        }
    }
});