////////////////////////////////////////////////////////////////////////////////
// Cookies
KS.apply(KS, {
    // Свойства кук:
    // NAME=VALUE - NAME-имя cookie, VALUE - значение.
    // expires=DATE - время хранения cookie, дата в формате "expires=Monday, DD-Mon-YYYY HH:MM:SS GMT", 
    //      после которой истекает время хранения cookie. Если этот атрибут не указан, то cookie хранится 
    //      в течение одного сеанса, до закрытия броузера.
    // domain=DOMAIN_NAME - домен, для которого значение cookie действительно. Например, "domain=javascript.ru". 
    //      В этом случае значение cookie будет действительно и для домена javascript.ru, и для www.javascript.ru.
    //      Если этот атрибут опущен, то по умолчанию используется доменное имя сервера, на котором было 
    //      задано значение cookie.
    // path=PATH - этот атрибут устанавливает подмножество документов, для которых действительно значение cookie.
    //      Для того, чтобы cookie отсылались при каждом запросе к серверу, необходимо указать корневой каталог 
    //      сервера, например, "path=/". Если этот атрибут не указан, то значение cookie распространяется только 
    //      на документы в той же директории, что и документ, в котором было установлено значение cookie.
    // secure - если стоит этот маркер, то информация cookie пересылается только через HTTPS (HTTP с 
    //      использованием SSL - Secure Socket Level), в защищенном режиме. Если этот маркер не указан, то 
    //      информация пересылается обычным способом.

    setCookie: function(name, value, expires, path, domain, secure) {
        if (typeof(name) === 'undefined' || typeof(value) === 'undefined')
            throw KS.L10n.reqNameValue;

        var str = name + '=' + encodeURIComponent(value);
        if (typeof(expires) !== 'undefined') str += '; expires=' + expires.toGMTString();
        if (typeof(path) !== 'undefined') str += '; path=' + path;
        if (typeof(domain) !== 'undefined') str += '; domain=' + domain;
        if (typeof(secure) !== 'undefined') str += '; secure';
        document.cookie = str;
    },

    getCookie: function(name, defaultValue) {
        var pattern = "(?:; )?" + name + "=([^;]*);?";
        var regexp = new RegExp(pattern);
        if (regexp.test(document.cookie))
            return decodeURIComponent(RegExp["$1"]);
        return defaultValue;
    },

    deleteCookie: function(name, path, domain) {
        KS.setCookie(name, null, new Date(0), path, domain);
    }
});
