﻿(function($) {

	$.alerts = {

		verticalOffset: -75,                // vertical offset of the dialog from center screen, in pixels
		horizontalOffset: 0,                // horizontal offset of the dialog from center screen, in pixels/
		repositionOnResize: true,           // re-centers the dialog on window resize
		overlayOpacity: 0.36,                // transparency level of overlay
		overlayColor: '#aaa',               // base color of overlay
		draggable: true,                    // make the dialogs draggable (requires UI Draggables plugin)
		okButton: '&nbsp;OK&nbsp;',         // text for the OK button
		cancelButton: '&nbsp;Cancel&nbsp;', // text for the Cancel button
		dialogClass: null,                  // if specified, this class will be applied to all dialogs

		//-----------------------------------------------------------------------------------------------------
		//Доступные извне методы
		alert: function(message, title, callback) {
			if (title == null) title = 'Alert';
			$.alerts._show(title, message, null, 'alert', function(result) { if (callback) callback(result); });
		},

		confirm: function(message, title, callback) {
			if (title == null) title = 'Confirm';
			$.alerts._show(title, message, null, 'confirm', function(result) { if (callback) callback(result); });
		},

		prompt: function(message, value, title, callback) {
			if (title == null) title = 'Prompt';
			$.alerts._show(title, message, value, 'prompt', function(result) { if (callback) callback(result); });
		},

		//модальное окно
		//title - заголовок
		//messageHTML - содержимое окна (текст сообщения)
		//buttonsHTML - содержимое кнопкок (текст сообщения)
		//showClock - с часиками
		modalpopup: function(title, messageHTML, buttonsHTML, showClock) {
			if (title == null) title = 'Модальное окно';
			$.alerts._show(title, messageHTML, null, 'modalpopup', null, buttonsHTML, showClock);
		},

		//закрыть модальное окно
		closeModalPopup: function() {
			$.alerts._hide();
		},

		//-----------------------------------------------------------------------------------------------------
		//НУТРО :)
		_show: function(title, msg, value, type, callback, buttonsHTML, showClock) {

			$.alerts._hide();
			$.alerts._overlay('show');

			$("BODY").append(
			  '<div id="jks_popup_container">' +
			    '<h1 id="jks_popup_title"></h1>' +
			    '<div id="jks_popup_content">' +
			      '<div id="jks_popup_message"></div>' +
				'</div>' +
			  '</div>');

			if ($.alerts.dialogClass) $("#jks_popup_container").addClass($.alerts.dialogClass);

			$("#jks_popup_container").css({
				position: "absolute",
				zIndex: 99999,
				padding: 0,
				margin: 0
			});

			$("#jks_popup_title").text(title);
			$("#jks_popup_content").addClass(type);
			$("#jks_popup_message").text(msg);
			$("#jks_popup_message").html($("#jks_popup_message").text().replace(/\n/g, '<br />'));

			$("#jks_popup_container").css({
				minWidth: $("#jks_popup_container").outerWidth(),
				maxWidth: $("#jks_popup_container").outerWidth()
			});

			$.alerts._reposition();
			$.alerts._maintainPosition(true);

			switch (type) {
				case 'alert':
					$("#jks_popup_message").after('<div id="jks_popup_panel"><input type="button" value="' + $.alerts.okButton + '" id="jks_popup_ok" /></div>');
					$("#jks_popup_ok").click(function() {
						$.alerts._hide();
						callback(true);
					});
					$("#jks_popup_ok").focus().keypress(function(e) {
						if (e.keyCode == 13 || e.keyCode == 27) $("#jks_popup_ok").trigger('click');
					});
					break;

				case 'modalpopup':
					if (showClock) $("#jks_popup_message").after('<div id="jks_popupclock"><img src="images/loading.gif"/></div>');
					$("#jks_popup_message").css({ "paddingLeft": "0px", "paddingRight": "0px", "textAlign": "center" });
					if (buttonsHTML) {
						btnsHTML = ('<div id="jks_popupbuttons">' + buttonsHTML + '</div>');
						if (showClock) $("#jks_popupclock").after(btnsHTML);
						if (!showClock) $("#jks_popup_message").after(btnsHTML);
					}
					break;

				case 'confirm':
					$("#jks_popup_message").after('<div id="jks_popup_panel"><input type="button" value="' + $.alerts.okButton + '" id="jks_popup_ok" /> <input type="button" value="' + $.alerts.cancelButton + '" id="jks_popup_cancel" /></div>');
					$("#jks_popup_ok").click(function() {
						$.alerts._hide();
						if (callback) callback(true);
					});
					$("#jks_popup_cancel").click(function() {
						$.alerts._hide();
						if (callback) callback(false);
					});
					$("#jks_popup_ok").focus();
					$("#jks_popup_ok, #jks_popup_cancel").keypress(function(e) {
						if (e.keyCode == 13) $("#jks_popup_ok").trigger('click');
						if (e.keyCode == 27) $("#jks_popup_cancel").trigger('click');
					});
					break;
				case 'prompt':
					$("#jks_popup_message").append('<br /><input type="text" size="30" id="jks_popup_prompt" />').after('<div id="jks_popup_panel"><input type="button" value="' + $.alerts.okButton + '" id="jks_popup_ok" /> <input type="button" value="' + $.alerts.cancelButton + '" id="jks_popup_cancel" /></div>');
					$("#jks_popup_prompt").width($("#jks_popup_message").width());
					$("#jks_popup_ok").click(function() {
						var val = $("#jks_popup_prompt").val();
						$.alerts._hide();
						if (callback) callback(val);
					});
					$("#jks_popup_cancel").click(function() {
						$.alerts._hide();
						if (callback) callback(null);
					});
					$("#jks_popup_prompt, #jks_popup_ok, #jks_popup_cancel").keypress(function(e) {
						if (e.keyCode == 13) $("#jks_popup_ok").trigger('click');
						if (e.keyCode == 27) $("#jks_popup_cancel").trigger('click');
					});
					if (value) $("#jks_popup_prompt").val(value);
					$("#jks_popup_prompt").focus().select();
					break;
			}

			// Make draggable
			if ($.alerts.draggable) {
				try {
					$("#jks_popup_container").draggable({ handle: $("#jks_popup_title") });
					$("#jks_popup_title").css({ cursor: 'move' });
				} catch (e) { /* requires jQuery UI draggables */ }
			}
		},

		_hide: function() {
			$("#jks_popup_container").remove();
			$.alerts._overlay('hide');
			$.alerts._maintainPosition(false);
		},

		_overlay: function(status) {
			switch (status) {
				case 'show':
					$.alerts._overlay('hide');
					$("BODY").append('<div id="jks_popup_overlay"></div>');
					$("#jks_popup_overlay").css({
						position: 'absolute',
						zIndex: 99998,
						top: '0px',
						left: '0px',
						width: '100%',
						height: $(document).height(),
						background: $.alerts.overlayColor,
						opacity: $.alerts.overlayOpacity
					});
					break;
				case 'hide':
					$("#jks_popup_overlay").remove();
					break;
			}
		},

		_reposition: function() {

			//установка размеров основного окна
			var popupMessage = $("#jks_popup_message");
			var height = popupMessage.outerHeight();
			height = (height > 300) ? 300 : height;
			height = (height < 20) ? 20 : height;
			popupMessage.height(height);
			popupMessage.width('600');

			var top = (($(window).height() / 2) - ($("#jks_popup_container").outerHeight() / 2)) + $.alerts.verticalOffset;
			var left = (($(window).width() / 2) - ($("#jks_popup_container").outerWidth() / 2)) + $.alerts.horizontalOffset;
			if (top < 0) top = 0;
			if (left < 0) left = 0;

			$("#jks_popup_container").css({
				top: top + 'px',
				left: left + 'px'
			});
			$("#jks_popup_overlay").height($(document).height());
			$("#jks_popup_overlay").width($(document).width());
		},

		_maintainPosition: function(status) {
			if ($.alerts.repositionOnResize) {
				switch (status) {
					case true:
						$(window).bind('resize', $.alerts._reposition);
						break;
					case false:
						$(window).unbind('resize', $.alerts._reposition);
						break;
				}
			}
		}

	}

	jAlert = function(message, title, callback) {
		$.alerts.alert(message, title, callback);
	}

	jConfirm = function(message, title, callback) {
		$.alerts.confirm(message, title, callback);
	};

	jPrompt = function(message, value, title, callback) {
		$.alerts.prompt(message, value, title, callback);
	};

	jModalPopup = function(title, messageHTML, buttonsHTML, withClock) {
		$.alerts.modalpopup(title, messageHTML, buttonsHTML, withClock);
	}

	CloseModalPopup = function() {
		$.alerts.closeModalPopup();
	}

	jCloseModalPopup = function() {
		$.alerts.closeModalPopup();
	}

})(jQuery);