#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2023, ООО "Кейсистемс"
###

# === Определяем каталог выполнения текущего скрипта ==================================
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
versoft="6.0.9"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -p|--ws_port)
        ws_port="$2"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${show_help}" ]; then

echo -e "
 параметры                по умолчанию   описание
 ----------------------   ------------   ------------------------------------------------------
 -p  | --ws_port                         рабочий порт\\id экземпляра, если не указан,
                                         то обновляются все установленные экземпляры
"
exit 1;
fi;

ws_port_title=${ws_port}
if [ -z "${ws_port}" ] ; then
  ws_port_title="<все>"
fi;

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~ Обновление управляющих файлов WEB-Сервер-КС        "
echo "           ~           порт\\id : ${ws_port_title}              "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"

bash ${dks_bashfile_dir}/sh/dks_upgrade.sh "${ws_port}"

exit 0;
