#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2023, ООО "Кейсистемс"
###

# === Определяем каталог выполнения текущего скрипта ==================================
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
versoft="6.0.9"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -p|--ws_port)
        ws_port="$2"
        ;;
      -all)
        all="all"
        ;;
      -q|--quiet)
        quiet="1"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -p  | --ws_port        443            рабочий порт http сервера или идентификатор установки
 -all                   нет            удалить рабочий каталог
 -q  | --quiet                         выполнение операции удаления без подтверждения
"
exit 1;
fi;

if [ -z "${ws_port}" ] ; then
  ws_port="443"
fi;

WarnColor='\033[0;33m'
NoColor='\033[0m'
uQY="[ ${WarnColor}Запрос${NoColor} ] "
emptE="           "

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~  Удаление контейнера WEB-Сервер-КС                 "
echo "           ~           порт\\id : ${ws_port}                     "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"


if [ -z "${quiet}" ]; then
  echo ""
  echo -n -e "${uQY}Вы действительно хотите удалить http сервер по порту\\id \"${ws_port}\"?
           ([да;y]/[N;нет;n]): "

  read item
  case "$item" in
    y|Y|да)
        ;;
    n|N|нет|"") echo -e "${emptE}Операция удаления прервана."; echo "";
        exit;
        ;;
    *) echo -e "${emptE}Операция удаления прервана."; echo "";
        exit;
        ;;
  esac
fi;

bash ${dks_bashfile_dir}/sh/dks_remove.sh "${ws_port}" ${all}

exit 0;
