{
  "Kestrel": {
    "EndPoints": {
      "Http": {
        "Url": "http://0.0.0.0:@kestrel_port@"
      }
    }
  },

  "Serilog": {
    "MinimumLevel": {
      "Default": "Information"
    },
    "WriteTo": [
      {
        "Name": "File",
        "Args": {
          "path": "./logs/log-.txt",
          "rollingInterval": "Day"
        }
      }
    ]
  },

  "ServiceSettings": {

    "PathBase": "/@virt_catalog@",

    "ApiUrl_comment": "RabbitMQ Management HTTP API Url",
    "ApiUrl": "http://127.0.0.1:15672/api",
    "ApiUserName": "admin",
    "ApiPassword": "1",

    "WatcherPeriod_comment": "Период проверки неиспользуемых очередей, в часах",
    "WatcherPeriod": "2",

    "QueueLifeTime_comment": "Время жизни неиспользуемых очередей, в часах",
    "QueueLifeTime": "1",


    "QueueSettings_comment": {
        "QueueName": "Имя очереди",
        "QueueDescription": "Описание",
        "IsIdle": "Отключение обработки сообщений очереди (true/false)",
        "MaxConsumers": "Максимальное число обработчиков очереди",
        "Timeout": "Максимальное время обработки сообщения, в минутах (по умолчанию 0 - нет ограничений)"
     },
    "QueueSettings": [
      {
        "QueueName": "mail",
        "QueueDescription": "Запросы почтовых сообщений",
        "IsIdle": "false",
        "MaxConsumers": 4,
        "Timeout": 5
      },
      {
        "QueueName": "sys_table_delete",
        "QueueDescription": "Очистка временных таблиц",
        "IsIdle": "false",
        "MaxConsumers": 5
      },
      {
        "QueueName": "reports",
        "SubQueuePostfix": "q1",
        "QueueDescription": "Сервис отчетов",
        "IsIdle": "false",
        "MaxConsumers": 3,
        "Timeout": 180
      },
      {
        "QueueName": "eod",
        "SubQueuePostfix": "q1",
        "QueueDescription": "Сервис ЭОД",
        "IsIdle": "true",
        "MaxConsumers": 3,
        "Timeout": 180
      }

    ]
  },

  "SqlClient": {
    "UserName_comment": "Имя пользователя для подключения к рабочей БД",
    "UserName": "@dbuser@",

    "Password_comment": "Пароль пользователя для подключения к рабочей БД",
    "Password": "@dbpwd@"
  },

  "MessageBroker": {
    "Enabled": true,
    "Traced": false,
    "Address": "@mqconn@"
  },


  "SystemSettings": {

    // Строка соединения со служебной БД
    // "SqlCache": "Data Source Type=PostgreSQL; Host=127.0.0.1; Port=5434; Database=rmq_cache; User ID=dbo; Password=dbo; Application Name=cache",
    "SqlCache": "Data Source Type=SQLite; Data Source=/var/www/html/wsks_@kestrel_port@/temp/db/wrk.db3",

  },
  "AllowedHosts": "*"
}
