{
  "Kestrel": {
    "EndPoints": {
      "Http": {
        "Url": "http://0.0.0.0:@kestrel_port@"
      }
    }
  },
  "Logging": {
    "LogLevel": {
      "Default": "Debug",
      "System": "Information",
      "Microsoft": "Information"
    }
  },

  "AllowedHosts": "*",
  "ConnectionStrings": {
    "DefaultConnection": "Server=@servername@;Port=@serverport@;Database=@dbname@; User Id=@dbuser@;Password=@dbpwd@"
  },

  "ServiceSettings": {
    "BackupPath": "@data_catalog@",
    "NotificationPeriod": "1440",
    "DefaultQuota": "107374182400",
    "PathBase": "/@virt_catalog@"
  },

  "Serilog": {
    "Using": [ "Serilog.Sinks.PostgreSQL.Configuration" ],
    "MinimumLevel": "Debug",
    "Enrich": [ "WithMachineName" ],
    "WriteTo": [
      { "Name": "Console" },
      {
        "Name": "File",
        "Args": { "path": "Logs/log.txt" }
      },
      {
        "Name": "PostgreSQL",
        "Args": {
          "connectionString": "DefaultConnection",
          "tableName": "ServerLogs",
          "needAutoCreateTable": true
        }
      }
    ]
  },
  "Columns": {
    "message": "RenderedMessageColumnWriter",
    "message_template": "MessageTemplateColumnWriter",
    "level": {
      "Name": "LevelColumnWriter",
      "Args": {
        "renderAsText": true,
        "dbType": "Varchar"
      }
    },
    "raise_date": "TimestampColumnWriter",
    "exception": "ExceptionColumnWriter",
    "properties": "LogEventSerializedColumnWriter",
    "props_test": {
      "Name": "PropertiesColumnWriter",
      "Args": { "dbType": "Json" }
    },
    "machine_name": {
      "Name": "SinglePropertyColumnWriter",
      "Args": {
        "propertyName": "MachineName",
        "writeMethod": "Raw"
      }
    }
  }


}

