{
  "Kestrel": {
    "EndPoints": {
      "Http": {
        "Url": "http://0.0.0.0:@kestrel_port@"
      }
    },
    "Limits": {
      "MaxRequestBodySize": 104857600
    }
  },

  "Serilog": {
    "MinimumLevel": {
      "Default": "Warning",
      "Override": {
        "Microsoft": "Warning",
        "Microsoft.Hosting.Lifetime": "Warning",
        "Microsoft.EntityFrameworkCore.Database.Command": "Warning"
      }
    },
    "WriteTo": [
      {
        "Name": "File",
        "Args": {
          "path": "./logs/log-.txt",
          "rollingInterval": "Day"
        }
      }
    ]
  },

  "SqlClient": {

    "DataSourceType": "@servertype@",
    "Server": "@servername@",
    "DataBase": "@dbname@",
    "UserName": "@dbuser@",
    "Password": "@dbpwd@"
  },

  "ServiceSettings": {
    "PathBase": "/@virt_catalog@"
  },

  "SystemSettings": {

    // Строка соединения со служебной БД кеша данных
    // "SqlCache": "Data Source Type=PostgreSQL; Host=127.0.0.1; Port=5434; Database=web_cache1; User ID=user1; Password=user1_pass; Application Name=cache; Maximum Pool Size=550; App Pool Size=500; CommandTimeout=600",
    "SqlCache": "Data Source Type=SQLite; Data Source=/var/www/html/wsks_@kestrel_port@/temp/db/wrk.db3",

    //  "NoSqlCache": "redis: 127.0.0.1:6379, user=admin, password=1",
    //  "NoSqlCache": "tarantool: admin:1@127.0.0.0:3301",
    "NoSqlCache": "memory",

    // "SessionStorage": "nosql"
    "SessionStorage" : "sql"

  },

  "OpenIdConnect": {
    "Authority": "https://you_organization.ru:443/oauth/",
    "ClientSecret": "ksidm_client_secret",
    "Prompt": "login",
    "Scope": [ "openid", "profile", "offline_access" ]
  },


  "IdmService" : {
    // Использовать IDM сервис. Необходим рестарт
    "Enabled": "true",
    // Период опроса очереди на наличие новых сообщений (в минутах)
    "IterationInterval": "1",
    // Период сброса статуса (в минутах)
    "Deadline" : "1",
    // Количество повторов неудачного запроса
    "RepeatAttempts" : "1",
    // Количиство запросов, обрабатываемых за раз
    "EventPoolBatchLimit" : "1",
    "MailSettings" :{
       "login" : "mail_login",
       "Password" : "***",
       "Host" : "mail.organization.ru",
       "Port" : "25",
       "Authenticate" : "false",
       // None, Auto, SslOnConnect, StartTls, StartTlsWhenAvailable
       "SecureSocketOptions" : "Auto",
       // Использовать прокси для отправки писем
       "UseProxy" : "false"
    }
  },

  "Scim": {
    "Enabled": true,
    "AuthBasic": "asd:qwe"
  }
}