###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###
### Версия @ws_ver@
###

 Данная инструкция описывает пример работы с экземпляром контейнера по порту http сервера 443.

 ВНИМАНИЕ! Для выполнения каких-либо команд, описанных ниже, необходимы права суперпользователя.



 После создания экземпляра контейнера с помощью платформы WEB-Сервер-КС Докер получаем следующее:

 1) Контейнер с именем wsks-@ws_ver@_443
    (посмотреть можно командой # docker ps -a)
     где,
      - wsks   -> web server keysystems
      - @ws_ver@ -> версия <>.<>.<>
      - 443    -> порт http сервера

 2) Каталог управления /opt/wsks-@ws_ver@_443/*.*

   Структура каталога управления:

    /opt/wsks-@ws_ver@_443
            |-- /conf.ks                                 # каталог конфигурационных файлов для http сервера
                   |-- /vhost.ks
                   |--  apache2.conf
                   |--  ports_ks.conf
                   |--  sslks.conf
                   |--  vhost_ks.conf

            |-- /ctl                                     # каталог с файлами управления .NET Core приложениями
                   |-- /app                              # каталог модулей запуска .NET Core приложений
                   |-- /sys                              # каталог системных модулей
                   |-- /tar_files                        # каталог для архивов исходного кода для разворачивания .NET Core приложений
                   |--  app_start.sh                     # bash скрипт запуска .NET Core приложений
                   |--  app_stop.sh                      # bash скрипт остановки .NET Core приложений
                   |--  readme.txt                       # текущий файл описания
                   |--  ws_*.sh                          # bash скрипты управления

            |-- /log                                     # каталог логирования работы http сервера
                   |-- *.log

            |-- /ssl                                     # Самоподписанные демо сертификаты для ssl соединения
                   |--  wsks-19.08_demo.crt
                   |--  wsks-19.08_demo.key

            |-- /template                                # каталог шаблонов файлов конфигурации и управления .NET Core приложениями
                   |-- 5xxx_app.sh.t
                   |-- 5xxx_ks.conf.t
                   |-- *appsettings.Production.json.t


            |-- /www                                     # каталог для развертывания рабочих каталогов .NET Core приложений
                   |-- /html
                       |-- index.html

            |-- COPYRIGHT                                # файл лицензии
            |-- dks_version                              # файл версии установочного пакета

   Структура каталога данных:

    /var/lib/wsks-@ws_ver@_443                         # каталог для хранения каких-либо изменяемых данных приложений
                                                          (например, прикрепляемых файлов приложения "Сервис ОД и ЭЦП")


 3) Файл в структуре systemd, который обеспечивает автоматический запуск контейнера и приложений, после перезапуска хоста.
      /lib/systemd/system/wsks-@ws_ver@_443.service



 Основные команды развертывания и удаления .NET Core приложений в экземпляре контейнера WEB-Сервер-КС.

 1) Развертывание нового .NET Core приложения.

    Последовательность действий:

      - поместить архив исходных файлов *.tar.gz в каталог /opt/wsks-@ws_ver@_443/ctl/tar_files.

          Существуют определенные правила по формированию архива приложения - внутри архива на
        первом уровне должна присутствовать только одна единственная корневая папка с произвольным 
        именем, а уже внутри нее исходные файлы.
        Например, архив можно сформировать следующей командой: tar -cvzf <имя архива>.tar.gz <имя каталога>


      - запустить развертывание приложения, выполнив команду:
        [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_addapp.sh -t <тип приложения> -a <имя файла архива> и т.д. используя по необходимости те или иные параметры,
        где,
@ws_showhelp@

       Практические примеры:

         a) Задача - развернуть .NET Core приложение "Бюджет-NEXT" на базе архива /opt/wsks-@ws_ver@_443/ctl/tar_files/wBKS_20.1.1.tar.gz
            для работы с СУБД MSSQL с именем сервера "SRVDB_DEMO\SQL" и базы данных "bks_2021", обращению к сайту обеспечить через
            виртуальный каталог "web".

           выполняем команду:

           "sBKS"   - Сервис Бюджет-NEXT
           -----------------------------------------------------------------------------------------------------

           [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_addapp.sh -t  "wBKS" \
                                                                      -a  "wBKS_20.1.1.tar.gz" \
                                                                      -vc "web"
                                                                      -st "0" \
                                                                      -sn "SRVDB_DEMO\SQL" \
                                                                      -dn "bks_2021"

           Информация о ходе выполнения:
           =========================================================================================================================

                      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                      ~          Создание приложения WEB-Сервер-КС           ~
                      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

           [   OK   ] Проверка доступности порта 54430 для устанавливаемого приложения.
           [   OK   ] Проверка виртуального каталога "web".
           [   OK   ] Проверка\Создание пользователя www-data.
                      useradd: пользователь «www-data» уже существует
           [   OK   ] Создание каталога приложения /opt/wsks-@ws_ver@_443/www/html/wsks_54430.
           [   OK   ] Создание файла запуска приложения /opt/wsks-@ws_ver@_443/ctl/app/54430_app.sh.
                      Приложение будет доступно по адресу - https://<host_ip>:443/web.
           [   OK   ] Создание файла конфигурации для приложения /opt/wsks-@ws_ver@_443/conf.ks/vhost.ks/54430_ks.conf.
           [   OK   ] Создание файла настроек для приложения /opt/wsks-@ws_ver@_443/www/html/wsks_54430/appsettings.Production.json.
           [   OK   ] Остановка сервиса wsks-@ws_ver@_443.service.
           [   OK   ] Запуск сервиса wsks-@ws_ver@_443.service.


           =========================================================================================================================

             Если установка выполнена успешно, то при запуске стартовой страницы в браузере: https://<host_ip>:443/web должна появиться форма
           для ввода логина и пароля. Порт для внутреннего web сервера Kestrel 54430 был назначен автоматически. Если Вы хотите использовать
           определенный порт, например, 55555, то необходимо в вызов добавить параметр с указанием вашего порта:  -p "55555".

           Примечание: Если вдруг в архиве приложения при запуске используется нестандартная стартующая dll, то ее наименование необходимо передать
                       в первом параметре типа после двоеточия ("wBKS:web_core.dll"), например:
                       [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_addapp.sh -t "wBKS:web_core.dll" -a "wBKS_20.1.1.tar.gz" -vc "web" -st "0" -sn "KSDB_DEMO\SQL" -dn "bks_192"
                       Таким образом стандартная стартующая dll будет переопределена.



           Аналогично разворачивается и все остальные приложения и сервисы, разница только в указании необходимых дополнительных параметрах.

           -----------------------------------------------------------------------------------------------------

           "sBKS"   - Сервис Бюджет-СМАРТ
           [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_addapp.sh -t "sBKS" -a "sBKS_1902.tar.gz" -vc "bks"

           -----------------------------------------------------------------------------------------------------

           "wSA"    - Сервис авторизации
           [root@demosrv]#  bash /opt/wsks-@ws_ver@_443/ctl/ws_addapp.sh  -t "wSA" \
                                                                        -a "wSAuth_3.3.tar.gz" \
                                                                        -vc "sa" \
                                                                        -st "3" \
                                                                        -sn "192.158.0.209:5434" \
                                                                        -dn "sa_database" \
                                                                        -du "sa_admin" \
                                                                        -dpwd "sa12345" \
                                                                        -wu "admin" \
                                                                        -wpwd "12345" \
                                                                        -crtk "abcd1234"


           -----------------------------------------------------------------------------------------------------

           "wSWrk"  - Сервис воркеров
           [root@demosrv]#  bash /opt/wsks-@ws_ver@_443/ctl/ws_addapp.sh  -t "wSWrk" \
                                                                        -a "wSWrk_1.0.tar.gz" \
                                                                        -vc "wrk" \
                                                                        -du "dbo" \
                                                                        -dpwd "dbo_password" \
                                                                        -mq "amqp://admin:1@192.158.1.237:5672"


           -----------------------------------------------------------------------------------------------------

           "sUPDS"   - Сервис обновлений
           [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_addapp.sh -t "sUPDS" \
                                                                      -a "sUPDS_3.3.1.tar.gz" \
                                                                      -vc "upd"

           -----------------------------------------------------------------------------------------------------


           "sSiUp"  - Сервис ОД и ЭЦП
            -- для провайдера крипто-про
           [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_addapp.sh -t "sSiUp" -a "sSiUp_3.3.7901.tar.gz" -vc "ecp" -crtv "cpro"

            -- для провайдера vipnet
           [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_addapp.sh -t "sSiUp" -a "sSiUp_3.3.7901.tar.gz" -vc "ecp" -crtv "cpro"

            -- для работы сервиса без поддержки ЭЦП
           [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_addapp.sh -t "sSiUp" -a "sSiUp_3.3.7901.tar.gz" -vc "ecp" -crtv "nocheck"


           Примечание: Перед установкой .NET Core приложения "Сервис ОД и ЭЦП" с поддержкой ЭЦП, необходимо чтобы провайдер ЭЦП был установлен на хосте
                       до установки экземпляра (контейнера докера). Если же провайдер устанавливался после создания контейнера, то необходимо выполнить коррекцию
                       его установки (см. пункт ВАЖНО ниже).

            ВАЖНО !!!

               - В одном экземпляре (контейнере докера) допускается установка только одного приложения "Сервис ОД и ЭЦП".
                 При установке двух и более, абсолютно точно НЕ ГАРАНТИРУЕТСЯ стабильная работа сервисов.
               - При установке приложений "Сервис ОД и ЭЦП" в разных экземплярах (контейнерах докера), необходимо указать
                 различные значения портов (по умолчанию порт 9090) в параметре "WinCrypto.CryptoModule.Address" 
                 в конфигурационном файле uploadservice.config, например:

                 <add key="WinCrypto.CryptoModule.Address" value="http://localhost:9091" />

               - Если установка провайдера ЭЦП осуществляется после разворачивания сервиса или экземпляра (контейнера докера),
                 то в этом случае для корректной работы сервиса необходимо скорректировать установку провайдера внутри контейнера экземпляра.
                 Для это необходимо выполнить следующую команду:

                [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_seteds.sh -crtv "cpro"
                 или
                [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_seteds.sh -crtv "vnet"

               - Для предотвращения потери данных при случайном удалении приложения "Сервис ОД и ЭЦП", файловое хранилище создается на
                 хосте по пути "/var/lib/<экземпляр контейнера>/wsks_<kestrel_port>/UPLOADS", который прописывается в параметре Storage.Location
                 во время установки в файле конфигурации uploadservice.config, например:

                 <add key="Storage.Location" value="/var/lib/wsks-@ws_ver@_443/wsks_5434" />

                 (подкаталог "/UPLOADS" не указывается, т.к. добавляется автоматически)

           -----------------------------------------------------------------------------------------------------

           -----------------------------------------------------------------------------------------------------

           "wLs"  - Сервис лицензирования
           [root@demosrv]#  bash /opt/wsks-@ws_ver@_443/ctl/ws_addapp.sh  -t "wLs" \
                                                                        -a "wLs_1.0.tar.gz" \
                                                                        -vc "lic" \
                                                                        -du "dbo" \
                                                                        -dpwd "dbo_password" \
                                                                        -wu "admin" \
                                                                        -wpwd "12345"


           -----------------------------------------------------------------------------------------------------

           "wCs"  - Сервис конфигураций
           [root@demosrv]#  bash /opt/wsks-@ws_ver@_443/ctl/ws_addapp.sh  -t "wCs" \
                                                                        -a "wCs_1.0.tar.gz" \
                                                                        -vc "conf" \
                                                                        -wu "admin" \
                                                                        -wpwd "12345"


           -----------------------------------------------------------------------------------------------------

           "wSREG"    - Сервис регистрации
           [root@demosrv]#  bash /opt/wsks-@ws_ver@_443/ctl/ws_addapp.sh  -t "wSREG" \
                                                                        -a "wSREG_3.3.tar.gz" \
                                                                        -vc "lk" \
                                                                        -st "3" \
                                                                        -sn "192.158.0.209:5434" \
                                                                        -dn "sa_database" \
                                                                        -du "sa_admin" \
                                                                        -dpwd "sa12345"

           -----------------------------------------------------------------------------------------------------



        Общая информация:

        Реализована поддержка автоматической закачки архива приложения для установки с интернет-ресурса. Для этого необходимо указать параметр -s, например:

        [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_addapp.sh -t "sBKS" \
                                                                   -a  "sBKS_19.3.1.2347.tar.gz" \
                                                                   -vc "bks" \
                                                                   -s  "https://keysystems.ru/files/smart/INSTALL/BUDGET_SMART/19.3"

        Таким образом, во время установки производится закачивание файла с сайта источника и дальнейшее его разворачивание, без какого-либо
        локального копирования файла архива в каталог ../tar_files.



        После успешного развертывания приложения в структуре каталогов управления экземпляром контейнера
        дополнительно создаются:

        /opt/wsks-@ws_ver@_443/ctl/app
                    |-- <Kestrel порт>_app.sh      - основной файл запуска .NET Core приложения
                    |-- <Kestrel порт>_app.err     - файл ошибок запуска   .NET Core приложения

        /opt/wsks-@ws_ver@_443/conf.ks/vhost.ks
                    |-- <Kestrel порт>_ks.conf     - конфигурационный файл виртуального хоста для http сервера

        /opt/wsks-@ws_ver@_443/www/html
                    |-- /wsks_<Kestrel порт>       - целевой каталог файлов приложения
                             |-- *.*


        Дополнительно, для хранения файлов первичных документов, создается рабочий каталог вне папки /opt
        /var/lib/wsks-@ws_ver@_443/wsks_xxxxx/UPLOADS



  2) Удаление существующего развернутого .NET Core приложения

    Для удаления необходимо запустить:
    [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_delapp.sh -p <Kestrel порт>

    Например, для удаления .NET Core приложения по порту Kestrel 54430 выполняем команду:
    [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_delapp.sh -p 54430

    Информация о ходе выполнения:
    =========================================================================================================================

           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
           ~           Удаление приложения WEB-Сервер-КС
           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
           ~
           ~    Порт кестрел : 54430
           ~    Тип          : wBKS - Бюджет-СМАРТ
           ~    Вирт.каталог : bks
           ~
           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    [ Запрос ] Вы действительно хотите удалить приложение по Kestrel порту "54430"?
               ([да;y]/[нет;n]): y

    [   OK   ] Удаление каталога приложения: /opt/wsks-@ws_ver@_443/www/html/wsks_54430.
    [   OK   ] Удаление файла запуска приложения: /opt/wsks-@ws_ver@_443/ctl/app/54430_app.sh.
    [   OK   ] Остановка сервиса wsks-@ws_ver@_443.service.
    [  Инфо  ] Запуск сервиса wsks-@ws_ver@_443.service отменен.
               Отсутствуют установленные приложения.
               Для установки приложений используйте скрипт ws_addapp.sh.
               См. инструкцию по развертыванию /opt/wsks-@ws_ver@_443/ctl/readme.txt

    =========================================================================================================================

    Общая информация:

     При удалении приложения, физически удаляются:
      - Файлы конфигурации виртуального хоста http сервера этого приложения  - <Kestrel порт>_ks.conf
      - Файлы запуска приложения                                             - <Kestrel порт>_app.sh
      - целевой каталог файлов приложения                                    - wsks_<Kestrel порт>

     ВАЖНО!!!
            1) При удалении приложения "Сервис ОД и ЭЦП", если файлы ОД расположены
               в каталоге приложения /opt/wsks-@ws_ver@_443/www/html/wsks_xxxxx/App_data,
               то они вместе с каталогом приложения будут также удалены.
               Будьте внимательны!!!

            2) При удалении последнего приложения, сервис экземпляра контейнера
               не запускается (по причине отсутствия развернутых приложений),
               таким образом, контейнер останавливается.

 3) Обновление существующего развернутого .NET Core приложения

    Для обновления существующего развернутого приложения необходимо запустить:
    [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_updapp.sh -t <тип> -a <имя файла архива> -p <Kestrel порт>

    Также поддерживается автоматическая закачка файла обновлений с интернет-ресурса. Для этого необходимо указать
    параметр -s, например:

    [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_updapp.sh -t "sBKS" \
                                                               -a "sBKS_19.3.1.2347.tar.gz" \
                                                               -p "54430" \
                                                               -s "https://keysystems.ru/files/smart/INSTALL/BUDGET_SMART/19.3"

    Информация о ходе выполнения:
    =========================================================================================================================

               ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
               ~          Обновление приложения WEB-Сервер-КС
               ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
               ~
               ~    Порт кестрел : 54430
               ~    Тип          : sBKS - Бюджет-СМАРТ
               ~    Вирт.каталог : bks
               ~
               ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    [   OK   ] Проверка типа архива обновления приложения.
    [   OK   ] Проверка существования каталога обновляемого приложения.
    [   OK   ] Запуск закачки файла архива из указанного интернет-ресурса.
               2021-09-28 18:02:48 URL:https://keysystems.ru/files/smart/INSTALL/BUDGET_SMART/19.3/BudgetSmart_netcore.tar.gz [24536930/24536930] -> "/opt/wsks-@ws_ver@_443/ctl/tar_files/_wget_/BudgetSmart_netcore.tar.gz" [1]
    [   OK   ] Обработка закачанного файла обновления.
               - cоздание резервной копии предыдущего файла архива в формате <имя файла>_YYYY-MM-DD_HH:MM:SS.
               - размещение нового файла обновления в каталоге ../tar_files.

    [   OK   ] Остановка приложения wsks_54430.
               Pid процесса(ов) хоста для остановки:  8533

    [   OK   ] Создание временного каталога /opt/wsks-@ws_ver@_443/ctl/tmp/___tmp_ksws_update_54431.
    [   OK   ] Распаковка архива обновления во временный каталог.
    [   OK   ] Сохранение файлов настроек.
    [   OK   ] Обновление рабочего каталога приложения.

    [   OK   ] Запуск приложения wsks_54430.

      Тип       Порт      Вирт.каталог          Каталог                                             Наименование                    Статус
      --------  --------  --------------------  --------------------------------------------------  ------------------------------  ------
      sBKS      54430     bks                   /opt/wsks-@ws_ver@_443/www/html/wsks_54430            Бюджет-СМАРТ                    Run

    =========================================================================================================================


     ВАЖНО!!!
            1) При обновлении .NET Core приложения в его корневом каталоге не перезаписываются
               каталоги данных и логов работы:
               - \App_Data\
               - \wwwroot\App_data\
               файлы настроек и конфигураций:
               - appsettings.Production.json
               - uploadservice.config (для типа приложений "sSiUp")


            2) Архив обновления должен включать полный набор файлов приложений. Поставка изменений не допускается,
               т.к. обновление производится путем полной замены содержимого рабочего каталога приложения и
               последующей записи файлов из архива обновления, кроме файлов и каталогов указанных в пункте 1).

            3) Если криптопровайдер установлен после разворачивания сервиса, который использует ЭЦП,
               то необходимо выполнить коррекцию установки провайдера в контейнере:
               [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_seteds.sh -crtv "cpro"
               или
               [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_seteds.sh -crtv "vnet"

               Это необходимо для обновления ссылок на библиотеки криптопровайдера внутри контейнера.

   4) Остановка отдельно взятого приложения.
         В процессе работы иногда возникает необходимость выполнить остановку отдельного .NET Core приложения,
      без остановки контейнера и других работающих приложений, для дополнительной настройки или просто
      для временного запрета работы, например, чтобы обновить БД. Управление запуском, остановкой или перезапуском
      осуществляется выполнением следующих команд:

      [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_ctlapp.sh -p "54430"  -m "stop"
      [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_ctlapp.sh -p "54430"  -m "start"
      [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_ctlapp.sh -p "54430"  -m "restart"

       где,
       параметры             по умолчанию   описание
       -------------------   ------------   ------------------------------------------------------
       -p | --kestrel_port   54430          кестрел порт развернутого приложения
       -m | --mode           restart        Выполняемое действие:
                                            - restart, остановить и запустить
                                            - stop, остановить
                                            - start, запустить



   5) Просмотр информации запущенных процессов
      Для просмотра запущенных процессов достаточно выполнить команду:

      [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_info.sh

      ----------------------------------------------------------
       Процессы http сервера порт 443
      ----------------------------------------------------------

        PID  PPID USERNAME %CPU% %MEM% CMD_apache
         29     1 root       0.0   0.1 /usr/sbin/apache2 -f /etc/apache2/conf.ks/apache2.conf -k start
         30    29 www-data   0.0   0.2 /usr/sbin/apache2 -f /etc/apache2/conf.ks/apache2.conf -k start
         31    29 www-data   0.0   0.2 /usr/sbin/apache2 -f /etc/apache2/conf.ks/apache2.conf -k start


      ----------------------------------------------------------
       Процессы мониторинга транслируемые на хост
      ----------------------------------------------------------

        PID  PPID USERNAME %CPU% %MEM% CMD_prometheus.yml
         177   155 www-data   0.1   0.6 /usr/local/bin/prometheus --config.file /etc/prometheus/prometheus.yml --storage.tsdb.path /var/lib/wsks-@ws_ver@_443/prometheus --web.listen-address=:9090


      ----------------------------------------------------------
       Процессы контейнеров dotnet, транслируемые на хост
      ----------------------------------------------------------

        PID  PPID USERNAME %CPU% %MEM% CMD_dotnet
        159   111 www-data  12.3   3.2 /opt/.dotnet/dotnet /var/www/html/wsks_54430/Keysystems.Webservice_core.dll
        162   114 www-data  22.4   4.5 /opt/.dotnet/dotnet /var/www/html/wsks_54431/web_core.dll
        168   118 www-data  12.5   2.9 /opt/.dotnet/dotnet /var/www/html/wsks_54432/Keysystems.AuthorizationService.dll
        172   124 www-data  26.4   3.0 /opt/.dotnet/dotnet /var/www/html/wsks_54433/Keysystems.RabbitWorker.dll
        179   134 www-data  10.5   2.2 /opt/.dotnet/dotnet /var/www/html/wsks_54434/Keysystems.UploadWebService.dll
        185   145 www-data  48.1   3.3 /opt/.dotnet/dotnet /var/www/html/wsks_54435/FileStorage.dll

        Тип       Порт      Вирт.каталог          Каталог                                             Наименование                    Статус
        --------  --------  --------------------  --------------------------------------------------  ------------------------------  ------
        sBKS      54430     bks                   /opt/wsks-@ws_ver@_443/www/html/wsks_54430            Бюджет-СМАРТ                    Run
        wBKS      54431     web                   /opt/wsks-@ws_ver@_443/www/html/wsks_54431            Бюджет-NEXT                     Run
        wSA       54432     sa                    /opt/wsks-@ws_ver@_443/www/html/wsks_54432            Сервис авторизации              Run
        wSWrk     54433     wrk                   /opt/wsks-@ws_ver@_443/www/html/wsks_54433            Сервис воркеров                 Run
        sSiUp     54434     ecp                   /opt/wsks-@ws_ver@_443/www/html/wsks_54434            Сервис ОД и ЭЦП                 Run
        sUPDS     54435     upd                   /opt/wsks-@ws_ver@_443/www/html/wsks_54435            Сервис обновлений               Run

      ----------------------------------------------------------
       Сервис (/lib/systemd/system/wsks-@ws_ver@_443.service)
      ----------------------------------------------------------

      ● wsks-@ws_ver@_443.service - (WSKS)wsks-@ws_ver@:443 docker container web server
         Loaded: loaded (/lib/systemd/system/wsks-@ws_ver@_443.service; enabled; vendor preset: enabled)
         Active: active (exited) since Fri 2021-09-17 17:29:16 MSK; 10s ago
        Process: 589 ExecStart=/opt/wsks-@ws_ver@_443/ctl/ws_start.sh (code=exited, status=0/SUCCESS)

      сен 17 17:29:13 demosrv systemd[1]: Starting (WSKS)wsks-@ws_ver@:443 docker container web server
      сен 17 17:29:14 demosrv ws_start.sh[589]: [   OK   ] Запуск контейнера wsks-@ws_ver@_443.
      сен 17 17:29:16 demosrv ws_start.sh[589]: [   OK   ] HTTP сервер Apache запущен.
      сен 17 17:29:16 demosrv ws_start.sh[589]: [   OK   ] Запуск .NetCore приложений.
      сен 17 17:29:16 demosrv systemd[1]: Started (WSKS)wsks-@ws_ver@:443 docker container web server

      ----------------------------------------------------------

   6) Копирование всех развернутых приложений, копирование одного отдельно взятого приложения
      с другого развернутого экземпляра WEB-Сервер-КС, текущей или предыдущей версии.

      Например:
       Развернут WEB-Сервер-КС версии 3.1.24 по порту 443  - источник (контейнер wsks-@ws_ver@_443).
       Развернут WEB-Сервер-КС версии 3.1.24 по порту 5444 - приемник.(контейнер wsks-@ws_ver@_5444)

       1) Необходимо выполнить полное копирование всех развернутых приложений на источнике
          развернутого по порту 443, на приемник по порту 5444.

          Копирование выполняется командой:

          [root@demosrv]# bash /opt/wsks-@ws_ver@_5444/ctl/ws_copyfrom.sh -s "wsks-@ws_ver@_443"

          Условия выполнения:
           - на приемнике не должно быть установленных приложений;
           - копируется только первые 100 приложений с источника (сортировка по именам каталогов приложений);

       2) Необходимо выполнить копирование одного развернутого приложения на источнике
          развернутого по порту 443 с портом кестрел 54430, на приемник по порту 5444.
          Копирование выполняется командой:

          [root@demosrv]# bash /opt/wsks-@ws_ver@_5444/ctl/ws_copyfrom.sh -s "wsks-@ws_ver@_443" -m "one" -p 54430

          Условия выполнения:
           - на приемнике должно быть установленных не более 100 приложений;

          Если есть необходимость переназначить виртуальный каталог для копируемого на приемник приложения, то
          необходимо в команде выполнения указать параметр -vc "<имя виртуального каталога>"


   7) Перенос всех развернутых приложений на новую версию WEB-Сервер-КС с другого развернутого
      экземпляра WEB-Сервер-КС предыдущей версии по одному и тому же порту web сервера.

      Например:
       Развернут WEB-Сервер-КС версии 3.1.18 по порту 443  - источник (контейнер wsks-3.1.18_443).
       Необходимо перенести все приложения на новый WEB-Сервер-КС версии @ws_ver@ по этому же порту.

       Порядок действий.
       1) Выполнить остановку сервиса wsks-3.1.18_443.
           $ systemctl stop wsks-3.1.18_443 (освобождаем порт 443).

       2) Выполнить установку WEB-Сервер-КС версии @ws_ver@
           $ bash /opt/dks-wsks-@ws_ver@/install.sh

       3) Запустить перенос приложений
          $ bash /opt/wsks-@ws_ver@_443/ctl/ws_copyfrom.sh -s "wsks-3.1.18_443" -m "replace"

         В результате переноса, все приложения будут запущены на новом экземпляре версии @ws_ver.
       Если приложение использовало штатный каталог данных /var/lib/wsks-3.1.18_443, то во время переноса
       данные будут скопированы в каталог данных нового экземпляра WEB-Сервер-КС /var/lib/wsks-@ws_ver@_443
       и в файлах конфигураций будет выполнена замена указания в путях выражения wsks-3.1.18_443
       на wsks-@ws_ver@_443.

         Сервис предыдущей версии wsks-3.1.18_443 будет остановлен и отключен.

       Важно!
         При переносе развернутых приложений с версий меньше чем 3.1.24, приложения могут работать некорректно.
       В этом случае необходимо привести конфигурационные файлы appsettings.Production.json
       и дополнительные файлы настроек updateservice.config, uploadservice.config и т.д. в соответствие 
       с версией @ws_ver@.

       Например, при переносе может быть такое сообщение:

        [  Инфо  ] В файле appsettings.Production.json отсутствует значение для виртуального каталога.
                   Приложение может работать некорректно или не работать совсем.
                   Для корректной работы необходимо в секциях "ServiceSettings": или "SystemSettings":
                   указать значение для виртуального каталога, в формате "PathBase": "<вирт.каталог>".
                   Например:

                     "ServiceSettings": {
                        "PathBase": "/web"
                     }




     Дополнительная информация:

     1) Общая схема

        В контейнере http сервер выступает в роли прокси сервера, который перенаправляет запросы
     на встроенный ASP.NET Core веб сервер Kestrel, который в свою очередь уже непосредственно связан с
     приложением. При разворачивании приложения (без указания порта Kestrel) веб серверу Kestrel назначается порт,
     равный порту http Apache с добавлением цифры от 0 до 9 (исключение - порт 443, для прибавления берется
     значение 5443).
         Например, для порта http сервера Apache 443, для приложения 1 будет назначен порт 54430, приложения 2 - 54431
     и так далее по порядку до 54439. Таким образом, без указания порта Kestrel можно развернуть
     до 100 приложений. Дальнейшее развертывание 101 приложения в рамкам текущего контейнера по 443 порту http сервера
     Apache или Nginx уже потребует указать порт вручную.
         Если установка производится без web сервера, то приложения доступны только по протоколу http и
     по портам Kestrel.


     Схема развертывания:

                           Хост

                         |                                   Контейнер 443
                         |   --------------------------------------------------------------------------------------
                         |                                   ______________________________________________________
                         |                                  |                                                      |
                         |    _______________               |              ASP.NET Core приложение 1               |
                         |   |               |              |    ___________                      ______________   |
                         |   |               |              |   |           |                    |              |  |
     Internet <-- Https -+-> |               | <---- Http --+-->|  Kestrel  |<- Http контекст -->|  Приложение  |  |
                         |   |               |              |   |___________|                    |______________|  |
                         |   |               |              |     порт=54430                                       |
                         |   |               |              |______________________________________________________|
                         |   |               |
                         |   |               |               ****
                         |   |               |               ______________________________________________________
                         |   |  Реверсивный  |              |                                                      |
                         |   | прокси сервер |              |              ASP.NET Core приложение 10              |
                         |   |    Apache     |              |    ___________                      ______________   |
                         |   |     Nginx     |              |   |           |                    |              |  |
     Internet <-- Https -+-> |     Angie     | <---- Http --+-->|  Kestrel  |<- Http контекст -->|  Приложение  |  |
                         |   |               |              |   |___________|                    |______________|  |
                         |   |   порт=443    |              |     порт=54439                                       |
                         |   |               |              |______________________________________________________|
                         |   |               |
                         |   |               |
                         |   |               |               ______________________________________________________
                         |   |               |              |                                                      |
                         |   |               |              |              ASP.NET Core приложение 11              |
                         |   |               |              |    ___________                      ______________   |
                         |   |               |              |   |           |                    |              |  |
     Internet <-- Https -+-> |               | <---- Http --+-->|  Kestrel  |<- Http контекст -->|  Приложение  |  |
                         |   |               |              |   |___________|                    |______________|  |
                         |   |_______________|              |     порт=55555                                       |
                         |                                  |______________________________________________________|

                             *****

                         |                                   Контейнер 5493
                         |   --------------------------------------------------------------------------------------
                         |    _______________
                         |   |               |               ______________________________________________________
                         |   |               |              |                                                      |
                         |   |  Реверсивный  |              |              ASP.NET Core приложение 1               |
                         |   | прокси сервер |              |    ___________                      ______________   |
                         |   |    Apache     |              |   |           |                    |              |  |
     Internet <-- Https -+-> |     Nginx     | <---- Http --+-->|  Kestrel  |<- Http контекст -->|  Приложение  |  |
                         |   |     Angie     |              |   |___________|                    |______________|  |
                         |   |               |              |     порт=54930                                       |
                         |   |  порт=5493    |              |______________________________________________________|
                         |   |               |
                         |   |_______________|




     2) Информация об установленных сервисах

       По умолчанию, при обращении к развернутому ресурсу без указания какого-либо виртуального каталога,
     выводится сообщение, которое содержится в файле /opt/wsks-@ws_ver@_443/www/html/index.html:

       You don't have permission to access folder on this server.
       Access forbidden - 403.

       Для размещения информации о развернутых сервисах необходимо выполнить генерацию нового файла index.html
     с последующей перезаписью файла по умолчанию в каталоге /opt/wsks-@ws_ver@_443/www/html. Генерация выполняется
     с указанием в качестве параметра ip или доменного имени ресурса через команду:

     [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_crtind.sh -n "192.168.46.107" -r
       или
     [root@demosrv]# bash /opt/wsks-@ws_ver@_443/ctl/ws_crtind.sh -n "mydomain.company.ru" -r

     где пареметр,
         -n -> доменное имя или ip хоста
         -r -> указание на перезапись файла

       После выполнения перегенерации файла index.html, при обращении к ресурсу: https://mydomain.company.ru в браузере
     будет выведено:

     ===========================================================

     WEB-Сервер-КС @ws_ver@ (apache2/nginx)

     Информация о развернутых сервисах:

     Сервис Авторизации
       Адрес: https://mydomain.company.ru/sa
       Идентификатор: 54430
       Примечание: Сервис авторизации

     Бюджет-СМАРТ
       Адрес: https://mydomain.company.ru/bks
       Идентификатор: 54431
       Примечание: Сервис смарта

     Бюджет-NEXT
       Адрес: https://mydomain.company.ru/web
       Идентификатор: 54433
       Примечание: Сервис Бюджет-NEXT

     ===========================================================

     3) Настройка http серверов Apache и Nginx

         Поставка http серверов в контейнере осуществляется с базовыми настройками, но все конфигурационные файлы
       и файлы логов работы серверов смонтированы на хост, что позволяет дополнительно их настраивать и конфигурировать.

       Структура смонтированных каталогов http сервера Apache:

      /opt/wsks-@ws_ver@_443
            |-- /conf.ks                                 # каталог конфигурационных файлов для http сервера (путь в контейнере /etc/apache2/conf.ks)
                   |-- /vhost.ks
                          |-- 54430_ks.conf              # описание виртуального хоста конечного .Net Core приложения
                          |-- ............

                   |-- apache2.conf                      # главный файл конфигурации ( запуск в контейнере: /usr/sbin/apache2ctl -f /etc/apache2/conf.ks/apache2.conf -k start )
                   |-- ports_ks.conf                     # конфигурация портов
                   |-- sslks.conf                        # конфигурация ssl соединений (https протокол)
                   |-- vhost_ks.conf                     # конфигурация виртуальных хостов

            |-- /log                                     # каталог логов работы (путь в контейнере /var/log/apache2/)
                   |-- error.log
                   |-- error_access.log

            |-- /ssl                                     # каталог с демо сертификатами (путь в контейнере /etc/apache2/ssl/)
                   |-- wsks-19.08_demo.crt
                   |-- wsks-19.08_demo.key


       Структура смонтированных каталогов http сервера Nginx:

      /opt/wsks-@ws_ver@_443
            |-- /conf.ks                                 # каталог конфигурационных файлов для http сервера (путь в контейнере /etc/apache2/conf.ks)
                   |-- /vhost.ks
                          |-- 54430_ks.conf              # описание виртуального хоста конечного .Net Core приложения
                          |-- ............

                   |-- nginx.conf                        # главный файл конфигурации ( запуск в контейнере: /usr/sbin/nginx -c /etc/nginx/conf.ks/nginx.conf )
                   |-- nginx_server.conf                 # файл конфигурации сервера и виртуальных хостов
                   |-- sslks.conf                        # конфигурация ssl соединений (https протокол)

            |-- /log                                     # каталог логов работы (путь в контейнере /var/log/nginx/)
                   |-- error.log
                   |-- error_access.log

            |-- /ssl                                     # каталог с демо сертификатами (путь в контейнере /etc/nginx/ssl/)
                   |-- wsks-19.08_demo.crt
                   |-- wsks-19.08_demo.key


       Структура смонтированных каталогов модулей мониторинга:

      /opt/wsks-@ws_ver@_443
            |-- /conf.etc                                # каталог конфигурационных файлов модулей мониторинга
                   |-- /prometheus
                          |-- /sd_files
                              |-- *_prometheus.json      # файлы конфигураций "работ" prometheus
                          |-- prometheus.yml             # главный файл конфигурации prometheus

            |-- /log                                     # каталог логов работы (путь в контейнере /var/log/apache2/ или /var/log/nginx/)
                   |-- prometheus.log

      /var/lib/wsks-@ws_ver@_443
             |-- /prometheus                             # каталог данных prometheus


     4) Prometheus — приложение, используемое для мониторинга и оповещения о событиях
        web приложений. Доступ к web странице самого Prometheus осуществляется по https протоколу под
        пользователем 'admin' пароль 'Admin2023!'

        Для смены пароля или имени пользователя необходимо в соответствующем файле конфигурации
        /opt/wsks-@ws_ver@_443/conf.etc/prometheus/prometheus_web_443.yml

        ============================================================================
        basic_auth_users:
               admin: 'хеш пароля'
        ============================================================================

        указать необходимые значения.

        По умолчанию хеш соответствует паролю: Admin2023!

        Если вы хотите использовать другой пароль, то необходимо выполнить следующие действия:
          - установить пакеты python3 и python3-bcrypt
          - создать файл -> gen-pass.py с содержимым:

        ===================
        import getpass
        import bcrypt

        password = getpass.getpass("password: ")
        hashed_password = bcrypt.hashpw(password.encode("utf-8"), bcrypt.gensalt())
        print(hashed_password.decode())
        ==================

         - запустить генерацию пароля
           $ python3 gen-pass.py


     5) Логирование ошибок

      Условно можно выделить три вида логов:

       - логирование ошибок работы http сервера Apache или Ngnix и модулей мониторинга.
         Файлы логирования размещаются в каталогах хоста:
             /opt/wsks-@ws_ver@_443
                |-- /log
                   |-- error.log
                   |-- error_access.log
                   |-- prometheus.log


           Если на хосте присутствует компонент logrotate, то при разворачивании экземпляра контейнера
         создается файл конфигурации для него, чтобы обеспечить ротацию логов http сервера и модулей мониторинга.
         Расположение файла на хосте -> /etc/logrotate.d/wsks-@ws_ver@_443.conf, описание используемых параметров
         ротации указано внутри самого файла. При необходимости значения параметров можно изменить под свои
         требования.


       - логирование ошибок запуска отдельно взятого .Net Core приложения.
         Файлы логирования размещаются в каталоге хоста:
             /opt/wsks-@ws_ver@_443
                 |-- /ctl
                    |-- /app
                       |-- <порт кестрел>_app.err
                       |-- ......................

       - логирование ошибок работы самого .Net Core приложения.
         Размещение файлов см. в документации по конкретному приложению.






