#!/bin/bash

action=$1
app_type="@app_type@"
kestrel_port="@kestrel_port@"
app_dir="wsks_"${kestrel_port}

# Определяем каталог выполнения текущего скрипта
app_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
app_logfile="${app_bashfile_dir}/${kestrel_port}_app.err"

# значение стартовой dll, переданное при создания приложения
app_startdll="@app_startdll@"
# значение стартовой dll стационарное из ws_getstartfname.sh
startdll="@startdll@"

if [ -z "${app_startdll}" ]; then
  startdll="${startdll}"
else
  startdll=${app_startdll}
fi;

cmdstart="/opt/.dotnet/dotnet /var/www/html/${app_dir}/${startdll}"
cmdstop="/opt/.dotnet/dotnet /var/www/html/${app_dir}/${startdll}"


if [ "$1" = "start" ]; then
  # проверка, запущено ли приложение
  check_exists=$(ps -ef | grep "${cmdstart}" | grep -v "grep")

  if [ -z ${check_exists} ]; then
    echo "Запускаем..."
    cd /var/www/html/${app_dir}
    # оба потока вывода в один файл
    # ${cmdstart} > ${app_logfile} 2>&1
    # только поток ошибок
    ${cmdstart} 2>${app_logfile}
  else
    echo "Уже запущено."
  fi;
fi;

if [ "$1" = "stop" ]; then
  start-stop-daemon -Kvx  ${cmdstop}
fi;


exit;
