#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

inet_source=$1
app_tar_archive=$2
force_install=$3

info_stdout="wget.stdout"
sOK=$(echo $($dks_bashfile_dir/ws_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/ws_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/ws_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/ws_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/ws_const_var.sh emptE)


function fn_file_echo() {
local LeftSpace=$2
LeftSpace=$(echo ${LeftSpace} | tr '#' ' ')
cat $1 | while read line
do
 echo -e "${LeftSpace}$line"
done
}

if [ -z $(which wget) ]; then
  # Отсутствует утилита закачки
  echo -e "${eRR}Отсутствует утилита закачки \"wget\"."
  echo -e "${emptE}Выполните установку утилиты с помощью менеджера пакетов."
  exit 1;
fi;

if [ -z $(which diff) ]; then
  # Отсутствует утилита сравнения файлов
  echo -e "${eRR}Отсутствует утилита сравнения файлов \"diff\"."
  echo -e "${emptE}Выполните установку утилиты с помощью менеджера пакетов."
  exit 1;
fi;


# Закачиваем
echo -e "${sOK}Запуск закачки файла архива из указанного интернет-ресурса."

wget --no-verbose \
     --no-check-certificate \
     --timestamping \
     ${inet_source}/${app_tar_archive} \
     --directory-prefix "${dks_bashfile_dir}/tar_files/_wget_" >/dev/null 2>${info_stdout}

_retcode="$?"

# Если файл не пустой
if [ -s ${info_stdout} ]; then
  fn_file_echo ${info_stdout} ${emptEsh}
fi;

# Если есть ошибка работы wget, то выходим
if ! [ "${_retcode}" == "0" ]; then
  echo -e "${wOK}Ошибка получения данных с интернет-ресурса."
  rm -f ${info_stdout}
  exit 1;
fi;

if [ -f "${dks_bashfile_dir}/tar_files/_wget_/${app_tar_archive}" ]; then
  # проверяем различие файлов в хранилище архивов и в скачанный
  if [ -f "${dks_bashfile_dir}/tar_files/${app_tar_archive}" ]; then

    diff -q "${dks_bashfile_dir}/tar_files/_wget_/${app_tar_archive}" "${dks_bashfile_dir}/tar_files/${app_tar_archive}" > ${info_stdout}

    # если файл пустой (значит нет различий) и не включен режим принудительной установки
    if ! [ -s ${info_stdout} ] && [ -z "${force_install}" ] ; then
      echo -e "${wOK}Нет новых обновлений c запрашиваемого интернет-ресурса."
      rm -f ${info_stdout}
      exit 2;
    fi;

    # Переименовываем старый файл архива в хранилище
    #date_pref=$(date '+%Y-%m-%d_%H:%M:%S')
    rm -f ${dks_bashfile_dir}/tar_files/${app_tar_archive}.prev
    mv ${dks_bashfile_dir}/tar_files/${app_tar_archive} ${dks_bashfile_dir}/tar_files/${app_tar_archive}.prev


  fi;

  # копируем новый
  cp ${dks_bashfile_dir}/tar_files/_wget_/${app_tar_archive} ${dks_bashfile_dir}/tar_files/
  echo -e "${sOK}Обработка закачанного файла обновления."
  echo -e "${emptE}- создание резервной копии предыдущего файла архива в формате <имя файла>_YYYY-MM-DD_HH:MM:SS."
  echo -e "${emptE}- размещение нового файла обновления в каталоге ../tar_files."

fi;

rm -f ${info_stdout}

exit 0;

