#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# Цвета
ErrColor=$($dks_bashfile_dir/ws_const_var.sh ErrColor)
SuccColor=$($dks_bashfile_dir/ws_const_var.sh SuccColor)
WarnColor=$($dks_bashfile_dir/ws_const_var.sh WarnColor)
NoColor=$($dks_bashfile_dir/ws_const_var.sh NoColor)

sOK=$(echo $($dks_bashfile_dir/ws_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/ws_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/ws_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/ws_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/ws_const_var.sh emptE)

dks_cont_name=$($dks_bashfile_dir/ws_const_var.sh dks_cont_name)
ws_type=$(${dks_bashfile_dir}/ws_const_var.sh     ws_type)
contsoft=$($dks_bashfile_dir/ws_const_var.sh      contsoft)

# Файл обмена
host_stdout=$($dks_bashfile_dir/ws_const_var.sh host_stdout)
cont_stdout=$($dks_bashfile_dir/ws_const_var.sh cont_stdout)

function fn_file_clr(){
cat > $1 << EOF
EOF
}

fn_file_clr ${host_stdout}
chmod 777 ${host_stdout}

echo ""
# sudo
is_root=$(${dks_bashfile_dir}/ws_const_var.sh is_root)
if [ "$is_root" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  exit 1;
fi

# Проверяем существование и активность контейнера
dks_exists=$(${contsoft} container ls -a | grep ${dks_cont_name})
if [ -z "${dks_exists}" ]; then
  echo -e "${wOK}Остановка контейнера ${dks_cont_name}."
  echo -e "${emptE}Контейнера ${dks_cont_name} не существует."
  echo ""
  exit;
fi

# Определяем запущен ли контейнера в docker/podman
dks_status=$(${contsoft} inspect -f '{{.State.Running}}' ${dks_cont_name})

if [ "${dks_status}" = "false" ]; then
  echo -e "${wOK}Остановка контейнера ${dks_cont_name}."
  echo -e "${emptE}Контейнер ${dks_cont_name} не запущен."
  echo ""
  exit;
fi

if [ "${ws_type}" = "no_http" ]; then
  StopHttpServer="no"
else
  StopHttpServer="yes"
fi;


if [ "${StopHttpServer}" = "yes" ]; then
  # Команды остановки и проверки
  if [ "${ws_type}" = "nginx" ]; then

    stop_cmd="/usr/sbin/nginx -c /etc/nginx/conf.ks/nginx.conf -s stop"
    chk_cmd="echo \\\$(ps -ef | grep -e \\\"nginx\\\" | grep -v \\\"grep\\\") > ${cont_stdout}"
    ws_servername="Nginx"

  fi;

  if [ "${ws_type}" = "angie" ]; then

    stop_cmd="/usr/sbin/angie -c /etc/angie/conf.ks/angie.conf -s stop"
    chk_cmd="echo \\\$(ps -ef | grep -e \\\"angie\\\" | grep -v \\\"grep\\\") > ${cont_stdout}"
    ws_servername="Angie"

  fi;

  if [ "${ws_type}" = "apache2" ]; then

    stop_cmd="/usr/sbin/apache2ctl -f /etc/apache2/conf.ks/apache2.conf -k stop"
    chk_cmd="echo \\\$(ps -ef | grep -e \\\"apache\\\" | grep -v \\\"grep\\\") > ${cont_stdout}"
    ws_servername="Apache"

  fi;

  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${chk_cmd}"

  http_is_stopped="no"

  file_stdout=$(cat ${host_stdout})
  fn_file_clr ${host_stdout}

  if [ -z "${file_stdout}" ]; then
    echo -e "${wOK}http сервер ${ws_servername} не запущен."
    http_is_stopped="yes"
  fi;

  # Останавливаем
  if [ "${http_is_stopped}" = "no" ]; then

    bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${stop_cmd}"
    bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${chk_cmd}"

    file_stdout=$(cat ${host_stdout})

    fn_file_clr ${host_stdout}
    if [ -z "${file_stdout}" ]; then
      echo -e "${sOK}Остановка http сервера ${ws_servername}."
      http_is_stopped="yes"
    fi;
  fi;
fi;

# Останавливаем контейнер
${contsoft} stop -t 1 ${dks_cont_name} >/dev/null
echo -e "${sOK}Остановка контейнера ${dks_cont_name}."

echo ""

rm -f ${host_stdout}

exit;



