#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# Цвета
ErrColor=$($dks_bashfile_dir/ws_const_var.sh ErrColor)
SuccColor=$($dks_bashfile_dir/ws_const_var.sh SuccColor)
WarnColor=$($dks_bashfile_dir/ws_const_var.sh WarnColor)
NoColor=$($dks_bashfile_dir/ws_const_var.sh NoColor)

sOK=$(echo $($dks_bashfile_dir/ws_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/ws_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/ws_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/ws_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/ws_const_var.sh emptE)

ws_type=$(${dks_bashfile_dir}/ws_const_var.sh ws_type)

# Файл обмена хоста и контейнера
host_stdout=$($dks_bashfile_dir/ws_const_var.sh host_stdout)
cont_stdout=$($dks_bashfile_dir/ws_const_var.sh cont_stdout)
dks_cont_name=$($dks_bashfile_dir/ws_const_var.sh dks_cont_name)
dks_inst_path=$($dks_bashfile_dir/ws_const_var.sh dks_inst_path)
contsoft=$($dks_bashfile_dir/ws_const_var.sh      contsoft)

function fn_file_clr(){
cat > $1 << EOF
EOF
}

fn_file_clr ${host_stdout}
chmod 777 ${host_stdout}

echo ""

# sudo
is_root=$($dks_bashfile_dir/ws_const_var.sh is_root)
if [ "$is_root" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  exit 1;
fi

# Проверка и запуск контейнера если не запущен
# Проверяем существование контейнера в docker/podman
dks_exists=$(${contsoft} container ls -a | grep ${dks_cont_name})
if [ -z "$dks_exists" ]; then
  echo -e "${eRR}Проверка существования контейнера ${dks_cont_name}."
  echo -e "${emptE}Контейнера ${dks_cont_name} не существует. Операция запуска невозможна."
  echo ""
  exit;
fi

# Определяем запущен ли контейнера в docker
dks_status=$(${contsoft} inspect -f '{{.State.Running}}' ${dks_cont_name})

if [ "${dks_status}" = "false" ]; then

  se_mode="Disabled"
  # Проверка Selinux
  if [ -f /etc/selinux/config ]; then
    se_mode=$(echo $(getenforce))
    if [ "${se_mode}" = "Enforcing" ]; then
      # переключаем в разрешительный :)
      setenforce Permissive
    fi;
  fi;


  # Запуск контейнера (процесса) в фоновом режиме
  ${contsoft} start ${dks_cont_name} >/dev/null

  dks_status=$(${contsoft} inspect -f '{{.State.Running}}' ${dks_cont_name})

  # восстанавливаем значение для selinux
  if [ "${se_mode}" = "Enforcing" ]; then
    # переключаем обратно.
    setenforce Enforcing
  fi;

  if [ "$dks_status" = "true" ]; then
    echo -e "${sOK}Запуск контейнера ${dks_cont_name}."
  else
    echo -e "${eRR}Запуск контейнера ${dks_cont_name}."
    echo -e "${emptE}Контейнер ${dks_cont_name} не запустился. Операция запуска не прошла."
    echo ""
    exit 1;
  fi
else
  echo -e "${wOK}Запуск контейнера ${dks_cont_name}."
  echo -e "${emptE}Контейнер ${dks_cont_name} уже работает."
fi

# провайдера ЭЦП могут поставить уже после создания контейнера.
# мы не знаем, в какой момент это будет,
# поэтому на всякий случай обновляем ссылки на
# библиотеки в кеше в контейнере при каждом запуске
bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "ldconfig" -noout


StartHttpServer="yes"

if [ "${ws_type}" = "nginx" ]; then
  ws_servername="Nginx"
fi;

if [ "${ws_type}" = "angie" ]; then
  ws_servername="Angie"
fi;

if [ "${ws_type}" = "apache2" ]; then
  ws_servername="Apache"
fi;

if [ "${ws_type}" = "no_http" ]; then
  StartHttpServer="no"
  ws_servername=""
fi;


# Команды запуска и проверки
if [ "${StartHttpServer}" = "yes" ]; then

  if [ "${ws_type}" = "nginx" ]; then

    start_cmd="/usr/sbin/nginx -c /etc/nginx/conf.ks/nginx.conf"
    chk_cmd="echo \\\$(ps -ef | grep -e \\\"nginx\\\" | grep -v \\\"grep\\\") > ${cont_stdout}"

  fi;

  if [ "${ws_type}" = "angie" ]; then

    start_cmd="/usr/sbin/angie -c /etc/angie/conf.ks/angie.conf"
    chk_cmd="echo \\\$(ps -ef | grep -e \\\"angie\\\" | grep -v \\\"grep\\\") > ${cont_stdout}"

  fi;


  if [ "${ws_type}" = "apache2" ]; then

    start_cmd="/usr/sbin/apache2ctl -f /etc/apache2/conf.ks/apache2.conf -k start"
    chk_cmd="echo \\\$(ps -ef | grep -e \\\"apache\\\" | grep -v \\\"grep -e apache\\\") > ${cont_stdout}"

  fi;


  http_is_started="no"

  fn_file_clr ${host_stdout}
  chmod 777 ${host_stdout}
  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${chk_cmd}"

  file_stdout=$(cat ${host_stdout})
  fn_file_clr ${host_stdout}
  if [ ! -z "${file_stdout}" ]; then
    echo -e "${wOK}http сервер ${ws_servername} уже запущен."
    http_is_started="yes";
  fi;


  # Запускаем http сервер
  if [ "${http_is_started}" = "no" ]; then
    bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${start_cmd}"

    bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${chk_cmd}"

    file_stdout=$(cat ${host_stdout})
    fn_file_clr ${host_stdout}
    if [ ! -z "${file_stdout}" ]; then
      echo -e "${sOK}Запуск http сервера ${ws_servername}."
      http_is_started="yes"
    fi;
  fi;

  if [ "${http_is_started}" = "no" ]; then
    echo ""
    echo -e "${eRR}http сервера ${ws_servername} не запущен."
    rm -f ${host_stdout}
    echo ""
    exit 1;
  fi;

else
  echo -e "${wOK}Запуск http сервера ${ws_servername} отменен."
  echo -e "${emptE}Установленным приложениям он не требуется."
fi;

# Запускаем приложения .NetCore (dotnet)

# Проверяем наличие хоть одного приложения, т.к.
# запускать без приложений не имеет смысла
exists_app=$(dir ${dks_bashfile_dir}/app | grep "_app.sh")

if [ -z "${exists_app}" ];then
  echo -e "${wOK}Запуск .NET Core приложений отменен."
  echo -e "${emptE}Отсутствуют установленные приложения."
  echo -e "${emptE}Для установки приложений используйте скрипт ws_addapp.sh."
  echo -e "${emptE}См. инструкцию по развертыванию ${dks_bashfile_dir}/readme.txt"
else
  start_cmd="bash /opt/wsks-@ws_ver@/ctl/app_start.sh"
  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                   -cn "${dks_cont_name}" \
                                                   -c  "${start_cmd}"     \
                                                   -u  "www-data"         \
                                                   -noout

  echo -e "${sOK}Запуск .NET Core приложений."
fi;

echo ""

rm -f ${host_stdout}

exit 0;

