#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###


# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# целевой файл должен передаваться с полным путем
_target_file=$1
_tmp_file="${dks_bashfile_dir}/_wskshelp.tmp"

echo -e "
        параметры                 по умолчанию   описание
        -------------------       ------------   ------------------------------------------------------------------------------------
        -t   | --app_type                        Тип устанавливаемого приложения.
                                                 Параметр поддерживает указание запускающего модуля, если приложение
                                                 нужно запустить нестандартно. Для этого необходимо после типа указать двоеточие
                                                 и имя стартового модуля, например: \"wBKS:web_core.dll\".

                                                 Допустимые типы приложений и сервисов:
                                                 wBKS   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wBKS))`"
                                                 sBKS   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh sBKS))`"
                                                 sSiUp  - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh sSiUp))`"
                                                 sUPDS  - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh sUPDS))`"
                                                 wSVOD  - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wSVOD))`"
                                                 sSVOD  - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh sSVOD))`"
                                                 wSA    - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wSA))`"
                                                 wRVZ   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wRVZ))`"
                                                 sRVZ   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh sRVZ))`"
                                                 wDWH   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wDWH))`"
                                                 sDWH   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh sDWH))`"
                                                 dDWH   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh dDWH))`"
                                                 wADM   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wADM))`"
                                                 sADM   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh sADM))`"
                                                 wSMT   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wSMT))`"
                                                 sSMT   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh sSMT))`"
                                                 wSWrk  - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wSWrk))`"
                                                 wLs    - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wLs))`"
                                                 wCs    - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wCs))`"
                                                 wSREG  - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wSREG))`"
                                                 sID    - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh sID))`"
                                                 wIDA   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wIDA))`"
                                                 sTSH   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh sTSH))`"
                                                 sMSS   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh sMSS))`"
                                                 wMSS   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wMSS))`"
                                                 wDBA   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wDBA))`"
                                                 wNEWS  - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wNEWS))`"
                                                 wMCU   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wMCU))`"
                                                 wAC    - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wAC))`"
                                                 wIDM   - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wIDM))`"
                                                 wDESK  - "`(echo $(${dks_bashfile_dir}/ws_getntype.sh wDESK))`"


        -a   | --app_tar_archive                 Имя архива *.tar.gz для развертывания, обязательное условие - наличие одной
                                                 корневой папки внутри архива.

        -p   | --kestrel_port     auto           Порт кестрел, необходимо указать, если нет возможности автоматически его присвоить,
                                                 в том случае если все порты заняты другими приложениями. Автоматически вычисляется как
                                                 рабочий порт текущего http сервера + число от 0 до 9.
                                                 Используется для всех типов приложений.

        -vc  | --virt_catalog                    Виртуальный каталог для приложения, если не указан, то берется тип + кестрел порт.
                                                 Используется для всех типов приложений.


        -st  | --servertype                      Тип источника СУБД: 0 - MSSQL; 1 - Oracle; 2 - Sqllite; 3 - Postgres.
        -sn  | --servername                      Имя или ip источника СУБД, если используется порт, то его необходимо указать через двоеточие.
        -dn  | --dbname                          Имя базы данных источника СУБД.
                                                 Используются для типов приложения: "`(echo $(${dks_bashfile_dir}/ws_getntype.sh webType))`".

        -du  | --dbuser                          Имя пользователя для соединения с БД
        -dpwd| --dbpwd                           Пароль пользователя БД
                                                 Используются для типа приложения: wSA, wSWrk, wLs, sID.

        -wu  | --wsuser                          Имя пользователя-администратора сайта приложения.
        -wpwd| --wspwd                           Пароль пользователя-администратора сайта.
                                                 Используются для типа приложения: wSA, wSWrk, wLs, wCs, sID.

        -crtk| --crtkey                          Ключ шифрования информации в БД.
                                                 Используются для типа приложения: wSA.

        -mq  | --mqconn                          Строка соединения с брокером очередей в формате: \"amqp://<имя пользователя>:1@<ip адрес>:<порт>\"
                                                 Используется для типа приложения: wSWrk

        -crtv| --cryptovendor     cpro           Имя криптопровайдера: \"cpro\" - КриптоПро; \"vnet\" - VipNet; \"nocheck\" - не проверять провайдера
                                                 Используется для типа приложения: sSiUp.

        -s   | --inet_source                     Интернет-ресурс для закачки файла архива. Закачка осуществляется через утилиту wget.
                                                 Используется для всех типов приложений.

        -cert| --certificate                     Cертификат для подписывания токенов.
                                                 Используются для типа приложения: sID.

        -ci  | --clientid                        Идентификатор клиентcкого приложения.
        -cs  | --clientsecret                    Секрет клиентского приложения.
                                                 Используются для типа приложения: sID, wIDA.

" > ${_tmp_file}

if ! [ -z "${_target_file}" ]; then

  # замена непосредственно в файле по тегу #ws_showhelp#
  sed -i -e '/@ws_showhelp@/r '${dks_bashfile_dir}'/_wskshelp.tmp' "${_target_file}"
  # убираем сам тег
  sed -i -e 's/@ws_showhelp@//' "${_target_file}"

else

  cat ${_tmp_file}

fi;

rm -f  ${_tmp_file}

exit 1;



