#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###


# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# каталог приложения dotnet
target_app_catalog=$1
_ExcludeFile=$2
target_temp_catalog=$3

appMaskAccess400="400"
appMaskAccess755="755"
appMaskAccess777="777"

# права доступа и владелец на каталог приложения ################
chown ks-www-data:ks-www-data   -R ${target_app_catalog}
chmod ${appMaskAccess755} -R ${target_app_catalog}

#################################################################


# права доступа на файл настроек и конфигураций #################
appTarget="appsettings.json"
if [ -f "${target_app_catalog}/${appTarget}" ]; then
  chown ks-www-data:ks-www-data ${target_app_catalog}/${appTarget}
  chmod ${appMaskAccess400} ${target_app_catalog}/${appTarget}
fi;

appTarget="appsettings.Production.json"
if [ -f "${target_app_catalog}/${appTarget}" ]; then

  _Exclude="no"
  # Проверка имени файла в исключаемых массив _ExcludeFile
  for _i in ${!_ExcludeFile[@]}; do
    if [ "${_ExcludeFile[$_i]}" = "${appTarget}" ];then
      _Exclude="yes"
      break;
    fi;
  done;

  if [ "${_Exclude}" = "no" ]; then
    chown ks-www-data:ks-www-data ${target_app_catalog}/${appTarget}
    chmod ${appMaskAccess400} ${target_app_catalog}/${appTarget}
  else
    # иначе  копируем с временного каталога старыt правами
    chmod --reference=${target_temp_catalog}/${appTarget} ${target_app_catalog}/${appTarget}
  fi;

  chown ks-www-data:ks-www-data ${target_app_catalog}/${appTarget}

fi;

appTarget="uploadservice.config"
if [ -f "${target_app_catalog}/${appTarget}" ]; then
  chown ks-www-data:ks-www-data ${target_app_catalog}/${appTarget}
  chmod ${appMaskAccess400} ${target_app_catalog}/${appTarget}
fi;

#################################################################


# Права на временные и общепользовательские каталоги ############
appTarget="App_data"
if [ -d ${target_app_catalog}/${appTarget}/ ]; then
  chown ks-www-data:ks-www-data   -R ${target_app_catalog}/${appTarget}
  chmod ${appMaskAccess777} -R ${target_app_catalog}/${appTarget}
fi;

appTarget="wwwroot/App_data"
if [ -d ${target_app_catalog}/${appTarget}/ ]; then
  chown ks-www-data:ks-www-data   -R ${target_app_catalog}/${appTarget}
  chmod ${appMaskAccess777} -R ${target_app_catalog}/${appTarget}
fi;

#################################################################

exit 0;
