#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###


# коррекция установки провайдера в контейнере:
# Парамеры:
# $1 тип провайдера ЭЦП

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -crtv| --cryptovendor)
        cryptovendor="$2"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${show_help}" ]; then

echo -e "
 параметры                по умолчанию   описание
 ---------------------    ------------   ------------------------------------------------------
 -crtv| --cryptovendor    cpro           Имя криптопровайдера: \"cpro\" - КриптоПро; \"vnet\" - VipNet;
                                         Используется для типа приложения \"sSiUp\".


"
exit 1;
fi;

if [ -z "${cryptovendor}" ]; then
  cryptovendor="cpro"
fi;


echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~   Коррекция установки провайдера ЭЦП WEB-Сервер-КС   ~"
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"

echo ""

# Путь установки
dks_inst_path=$($dks_bashfile_dir/ws_const_var.sh dks_inst_path)
dks_cont_name=$($dks_bashfile_dir/ws_const_var.sh dks_cont_name)
dks_serv_name="${dks_cont_name}.service"
contsoft=$($dks_bashfile_dir/ws_const_var.sh      contsoft)

# Цвета
ErrColor=$($dks_bashfile_dir/ws_const_var.sh ErrColor)
SuccColor=$($dks_bashfile_dir/ws_const_var.sh SuccColor)
WarnColor=$($dks_bashfile_dir/ws_const_var.sh WarnColor)
NoColor=$($dks_bashfile_dir/ws_const_var.sh NoColor)

sOK=$(echo $($dks_bashfile_dir/ws_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/ws_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/ws_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/ws_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/ws_const_var.sh emptE)


if [ "${cryptovendor}" != "cpro" ] && [ "${cryptovendor}" != "vnet" ]; then
  echo -e "${eRR}Некорректное имя провайдера ЭЦП."
  echo -e "${emptE}Допустимые значения \"cpro\" или \"vnet\"."
  echo -e ""
  exit 1;
fi;


# Определяем запущен ли контейнера в docker/podman
dks_status=$(${contsoft} inspect -f '{{.State.Running}}' ${dks_cont_name})

if [ "${dks_status}" = "false" ]; then
  echo -e "${eRR}Контейнер ${dks_cont_name} не запущен."
  echo -e "${emptE}Выполните запуск контейнера с помощью команды:"
  echo -e "${emptE}\$ systemctl start ${dks_serv_name}"
  echo ""
  exit;
fi;



# Проверка наличия провайдера
if [ "${cryptovendor}" = "cpro" ]; then
  if [ ! -f "/opt/cprocsp/lib/amd64/libcapi10.so.4" ]; then
    echo -e "${eRR}Не установлен модули для работы ЭЦП."
    echo -e "${emptE}Для установки приложения необходимо установить КриптоПро CSP 4.0 и выше"
    echo ""
    exit 1;
  else
    cont_cmd="echo \"/opt/cprocsp/lib/amd64\" > /etc/ld.so.conf.d/cpro.conf && ldconfig"
    bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${cont_cmd}" -noout

    echo -e "${sOK}Коррекция провайдера \"${cryptovendor}\" выполнена."
    echo -e "${emptE}Для завершения перезапустите контейнер с помощью команды:"
    echo -e "${emptE}\$ systemctl restart ${dks_serv_name}"

  fi;
fi;


if [ "${cryptovendor}" = "vnet" ]; then
  if [ ! -f "/opt/itcs/lib/libcrypt32.so" ]; then
    echo -e "${eRR}Не установлен модули для работы ЭЦП."
    echo -e "${emptE}Для установки приложения необходимо установить ViPNet CSP 4.2 и выше."
    echo ""
    exit 1;
  else
    cont_cmd="echo \"/opt/itcs/lib\" > /etc/ld.so.conf.d/itcs.conf && ldconfig"
    bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${cont_cmd}" -noout

    echo -e "${sOK}Коррекция провайдера \"${cryptovendor}\" выполнена."
    echo -e "${emptE}Для завершения перезапустите контейнер с помощью команды:"
    echo -e "${emptE}\$ systemctl restart ${dks_serv_name}"
  fi;
fi;


echo ""

exit 0;