#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###

kestrel_port=$1
status_only=$2

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

format() {
        printf "%-$1s\n" $2
}

function fn_file_clr(){
cat > $1 << EOF
EOF
}


# длина строки в байтах
bLen() {
  curLang=$LANG curLcAll=$LC_ALL
  LANG=C LC_ALL=C
  local _bytlen=${#1}
  LANG=${curLang} LC_ALL=${curLcAll}
  echo ${_bytlen}
}

if [ -z "${kestrel_port}" ]; then
  search_filter="*"
else
  search_filter="${kestrel_port}"
fi;



# Цвета
ErrColor=$($dks_bashfile_dir/ws_const_var.sh ErrColor)
SuccColor=$($dks_bashfile_dir/ws_const_var.sh SuccColor)
WarnColor=$($dks_bashfile_dir/ws_const_var.sh WarnColor)
NoColor=$($dks_bashfile_dir/ws_const_var.sh NoColor)

dks_inst_path=$(${dks_bashfile_dir}/ws_const_var.sh dks_inst_path)
dks_cont_name=$(${dks_bashfile_dir}/ws_const_var.sh dks_cont_name)
tag_name=$(${dks_bashfile_dir}/ws_const_var.sh tag_name)

uid_whost=$(id -u ks-www-data)


if [ -z "${status_only}" ]; then
  echo "  Тип       Порт      Вирт.каталог          Каталог                                             Наименование                    Статус   "
  echo "  --------  --------  --------------------  --------------------------------------------------  ------------------------------  ------   "
fi;

for app_info_file in `find ${dks_inst_path}/www/html -type d -name "wsks_${search_filter}" | sort`
  do
    if [ -f "${app_info_file}/wskstype" ]; then

      wskstype="${app_info_file}/wskstype"

      app_catalog="  Каталог: ${app_info_file}"
      app_type=$(echo $(cat ${wskstype} | grep "type=") | sed 's|.*=||')

      # наименование #############################################################

      app_type_name=$(echo $(cat ${wskstype} | grep "type_name=") | sed 's|.*=||')
      app_type_name=$(echo  ${app_type_name} | sed 's/ /_/g')

      if [ -z "${app_type_name}" ]; then
        app_type_name=$(${dks_bashfile_dir}/ws_getntype.sh ${app_type})
      fi;

      nsizeB=$(bLen ${app_type_name})
      nsizeS=${#app_type_name}
      nsize=$((${nsizeB} - ${nsizeS} + 32))

      ###########################################################################

      app_port=$(echo $(cat ${wskstype} | grep "kestrel_port=") | sed 's|.*=||')


      # состояние ################################################################
      kestrel_port=${app_port}
      apppidfile_host="${dks_inst_path}/ctl/app/tmp_${kestrel_port}_info.txt"

      ps -u ${uid_whost} -ef | grep -E "${kestrel_port}_app|wsks_${kestrel_port}" | grep -v "grep -E ${kestrel_port}_app|wsks_${kestrel_port}" > ${apppidfile_host}

      if [ -s ${apppidfile_host} ]; then
        app_status="${SuccColor}Run${NoColor}"
        app_status_return="Run"
      else
        app_status="${ErrColor}Stop${NoColor}"
        app_status_return="Stop"
      fi;
      rm -f ${apppidfile_host}
      ##########################################################################


      app_virt=$(echo $(cat ${wskstype} | grep "virt_catalog=") | sed 's|.*=||')
      app_note=$(echo $(cat ${wskstype} | grep "note") | sed 's|.*=||')

      if [ -z "${status_only}" ]; then
        echo -e "  $(format 10 ${app_type})$(format 10 ${app_port})$(format 22 ${app_virt})$(format 52 ${app_info_file})$(format ${nsize} ${app_type_name})${app_status}"
      fi;
    fi;
  done

if [ -z "${status_only}" ]; then
  echo ""
else
  echo "${app_status_return}"
fi;

exit;