#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###


# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# Цвета
ErrColor=$($dks_bashfile_dir/ws_const_var.sh ErrColor)
SuccColor=$($dks_bashfile_dir/ws_const_var.sh SuccColor)
WarnColor=$($dks_bashfile_dir/ws_const_var.sh WarnColor)
NoColor=$($dks_bashfile_dir/ws_const_var.sh NoColor)

sOK=$(echo $($dks_bashfile_dir/ws_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/ws_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/ws_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/ws_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/ws_const_var.sh emptE)

# Файл обмена хоста и контейнера
host_stdout=$($dks_bashfile_dir/ws_const_var.sh host_stdout)
cont_stdout=$($dks_bashfile_dir/ws_const_var.sh cont_stdout)
dks_cont_name=$($dks_bashfile_dir/ws_const_var.sh dks_cont_name)
ws_port=$($dks_bashfile_dir/ws_const_var.sh ws_port)
ws_type=$($dks_bashfile_dir/ws_const_var.sh ws_type)
contsoft=$($dks_bashfile_dir/ws_const_var.sh    contsoft)

function fn_file_clr(){
cat > $1 << EOF
EOF
}

fn_file_clr ${host_stdout}
chmod 777 ${host_stdout}

# sudo
is_root=$($dks_bashfile_dir/ws_const_var.sh is_root)
if [ "$is_root" -ne 0 ]; then
  echo ""
  echo -e "${eRR}Для выполнения текущей операции необходимы права суперпользователя."
  echo ""
  exit 1;
fi;

if [ "${ws_type}" = "nginx" ]; then
  ws_servername="Nginx"
fi;

if [ "${ws_type}" = "angie" ]; then
  ws_servername="Angie"
fi;

if [ "${ws_type}" = "apache2" ]; then
  ws_servername="Apache"
fi;

if [ "${ws_type}" = "no_http" ]; then
  ws_servername="(отсутствует)"
fi;



# Определяем запущен ли контейнера в docker
dks_status=$(${contsoft} inspect -f '{{.State.Running}}' ${dks_cont_name})

if [ "${dks_status}" = "false" ]; then
  echo ""
  echo -e "${wOK}Контейнер ${dks_cont_name} не запущен."
  echo ""
  exit;
fi;


echo ""
echo -e "${WarnColor}----------------------------------------------------------${NoColor}"
echo -e "${WarnColor} Процессы http сервера ${ws_servername}, порт ${ws_port}${NoColor}"
echo -e "${WarnColor}----------------------------------------------------------${NoColor}"
echo ""

if ! [ "${ws_type}" = "no_http" ]; then

  fn_file_clr ${host_stdout}

  if [ "${ws_type}" = "nginx" ]; then
    chk_cmd="ps -eo pid=PID,ppid=PPID,uname=USERNAME,pcpu=%CPU%,pmem=%MEM%,cmd=CMD_nginx   | grep -e \\\"nginx\\\"  | grep -v \\\"grep\\\" | grep -v \\\"ps -eo\\\" > ${cont_stdout}"
  fi;

  if [ "${ws_type}" = "angie" ]; then
    chk_cmd="ps -eo pid=PID,ppid=PPID,uname=USERNAME,pcpu=%CPU%,pmem=%MEM%,cmd=CMD_angie   | grep -e \\\"Angie\\\"  | grep -v \\\"grep\\\" | grep -v \\\"ps -eo\\\" > ${cont_stdout}"
  fi;

  if [ "${ws_type}" = "apache2" ]; then
    chk_cmd="ps -eo pid=PID,ppid=PPID,uname=USERNAME,pcpu=%CPU%,pmem=%MEM%,cmd=CMD_apache  | grep -e \\\"apache\\\" | grep -v \\\"grep\\\" | grep -v \\\"ps -eo\\\" > ${cont_stdout}"
  fi;



  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${chk_cmd}"

  cat ${host_stdout}
  fn_file_clr ${host_stdout}

fi;

echo ""
echo -e "${WarnColor}----------------------------------------------------------${NoColor}"
echo -e "${WarnColor} Процессы мониторинга транслируемые на хост ${NoColor}"
echo -e "${WarnColor}----------------------------------------------------------${NoColor}"
echo ""

  chk_cmd="ps -eo pid=PID,ppid=PPID,uname=USERNAME,pcpu=%CPU%,pmem=%MEM%,cmd=CMD_prometheus_${ws_port}.yml | grep -e \\\"prometheus_${ws_port}.yml\\\" | grep -v \\\"grep\\\" | grep -v \\\"ps -eo \\\" > ${cont_stdout}"

  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${chk_cmd}"

  cat ${host_stdout}
  fn_file_clr ${host_stdout}


echo ""
echo -e "${WarnColor}----------------------------------------------------------${NoColor}"
echo -e "${WarnColor} Процессы dotnet, транслируемые на хост ${NoColor}"
echo -e "${WarnColor}----------------------------------------------------------${NoColor}"
echo ""

  chk_cmd="ps -eo pid=PID,ppid=PPID,uname=USERNAME,pcpu=%CPU%,pmem=%MEM%,cmd=CMD_dotnet | grep -e \\\"dotnet\\\" | grep -v \\\"grep -e dotnet\\\" | grep -v \\\"ps -eo \\\" > ${cont_stdout}"
  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${chk_cmd}"

  cat ${host_stdout}
  fn_file_clr ${host_stdout}

  echo ""

  chk_cmd="ps -eo pid=PID,ppid=PPID,uname=USERNAME,pcpu=%CPU%,pmem=%MEM%,cmd=CMD_Keysystems.CryptoModule | grep -e \\\"Keysystems.CryptoModule\\\" | grep -v \\\"grep\\\" | grep -v \\\"ps -eo \\\" > ${cont_stdout}"
  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${chk_cmd}"

  cat ${host_stdout}
  fn_file_clr ${host_stdout}

  echo ""

echo ""
echo -e "${WarnColor}----------------------------------------------------------${NoColor}"
echo -e "${WarnColor} Развернутые приложения ${NoColor}"
echo -e "${WarnColor}----------------------------------------------------------${NoColor}"
echo ""

  # информация о каталогах
  bash ${dks_bashfile_dir}/ws_info_app.sh

  dks_serv_name="${dks_cont_name}.service"

  if [ ! -f "/lib/systemd/system/${dks_serv_name}" ]; then
    echo -e "${ErrColor}Сервис ${dks_serv_name} отсутствует в системе.${NoColor}"
  else
    echo -e "${WarnColor}----------------------------------------------------------${NoColor}"
    echo -e "${WarnColor} Сервис (/lib/systemd/system/${dks_serv_name})${NoColor}"
    echo -e "${WarnColor}----------------------------------------------------------${NoColor}"
    echo ""
    systemctl status ${dks_serv_name} --no-pager
  fi;



echo ""
echo -e "${WarnColor}----------------------------------------------------------${NoColor}"
echo ""

rm -f ${host_stdout}

exit;