#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###

# Получение версии win файла приложения

_searchfile=$1
_noversion="???.??"
_nobinutils="нет binutils"

strings_exists=$(which strings 2>/dev/null)
if [ -z "${strings_exists}" ] || ! [ -f "${_searchfile}" ]; then
  echo "${_nobinutils}"
  exit 0;
fi;

_tmpfile1="1.tmp"
_tmpfile2="2.tmp"

#_searchword="FileVersion"
_searchword="Assembly Version"
_searchletter=${_searchword:0:1}

strings -el ${_searchfile} > ${_tmpfile1}
cat -n ${_tmpfile1} | grep "${_searchword}" > ${_tmpfile2}

if ! [ -s ${_tmpfile2} ]; then
  rm -f ${_tmpfile1}
  rm -f ${_tmpfile2}
  echo "${_noversion}"
  exit 0;
fi;

_markerfile=$(cat ${_tmpfile2})

# debug
#echo ${_markerfile}
#echo ${_markerfile} | sed 's|.*'"${_searchletter}"'||'

_numstr=$(echo ${_markerfile} | sed -r 's/'"${_searchletter}"'.+//')
_ver_numstr=$((${_numstr} + 1))


_versionfile=$(sed -n ''"${_ver_numstr}"'p' ${_tmpfile1})

rm -f ${_tmpfile1}
rm -f ${_tmpfile2}

echo ${_versionfile}

exit 0;








