#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###

_ws_port=$1
_used_ports=$2

# Определяем каталог выполнения текущего скрипта
_dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# Определяем порт кестрела
_dks_inst_path=$(${_dks_bashfile_dir}/ws_const_var.sh dks_inst_path)
_dks_app_path="${_dks_inst_path}/www/html"


# первая составляющая порта
if [ "${_ws_port}" = "443" ]; then
  _kestrel_port="5443"
else
  _kestrel_port="${_ws_port}"
fi;

# Вычисляем первое незанятое в диапазоне от 0 до 99 и добавляем к
# первой составляющей порта кестрела, если все занято, то выдаем
# об этом инфу и предлагаем указать "ручками"

_kestrel_port_return=""

for (( count=0; count<100; count++ ))
  do
    if [ "${count}" = "0" ]; then
     _kestrel_port_check="${_kestrel_port}0"
    else
     _kestrel_port_check=$(($_kestrel_port_check+1))
    fi;

    # 0) проверка в массиве используемых портов, если занят,
    #    то переходим к следующей цифре

    _isUsed="no"
    case "${_used_ports[@]}" in *"${_kestrel_port_check}"*) _isUsed="yes" ;; esac

    if [ "${_isUsed}" = "no" ]; then

      # 1) проверка на существование каталога уже по этому порту в текущем контейнере,
      #    если есть, то переходим к следующей цифре
      # 2) проверка на "занятость" по всему хосту, если занят,
      #    то переходим к следующей цифре

      if ! [ -d "${_dks_app_path}/wsks_${_kestrel_port_check}" ]; then

        # проверка "свободности" порта на хосте
        _ssu_exists=$(ss -V | grep "ss utility")
        if [ ! -z "${_ssu_exists}" ]; then
          _port_exists=$(ss -lntup | grep ":${_kestrel_port_check}")
          if [ -z "${_port_exists}" ]; then
            _kestrel_port_return=${_kestrel_port_check}
            break;
          fi;
        else
          _kestrel_port_return=${_kestrel_port_check}
          break;
        fi;
      fi;
    fi;
  done

  echo ${_kestrel_port_return}

exit 1;




